/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.rocksdb;

import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.Maybe;
import io.reactivex.rxjava3.processors.UnicastProcessor;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.infinispan.AdvancedCache;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.commons.configuration.ConfiguredBy;
import org.infinispan.commons.io.ByteBuffer;
import org.infinispan.commons.marshall.MarshallUtil;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.reactive.RxJavaInterop;
import org.infinispan.commons.time.TimeService;
import org.infinispan.commons.util.AbstractIterator;
import org.infinispan.commons.util.IntSet;
import org.infinispan.commons.util.IntSets;
import org.infinispan.commons.util.Util;
import org.infinispan.commons.util.Version;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.distribution.ch.KeyPartitioner;
import org.infinispan.marshall.persistence.PersistenceMarshaller;
import org.infinispan.marshall.persistence.impl.MarshallableEntryImpl;
import org.infinispan.metadata.Metadata;
import org.infinispan.metadata.impl.PrivateMetadata;
import org.infinispan.persistence.PersistenceUtil;
import org.infinispan.persistence.rocksdb.PersistenceContextInitializerImpl;
import org.infinispan.persistence.rocksdb.configuration.RocksDBStoreConfiguration;
import org.infinispan.persistence.rocksdb.logging.Log;
import org.infinispan.persistence.spi.InitializationContext;
import org.infinispan.persistence.spi.MarshallableEntry;
import org.infinispan.persistence.spi.MarshallableEntryFactory;
import org.infinispan.persistence.spi.MarshalledValue;
import org.infinispan.persistence.spi.NonBlockingStore;
import org.infinispan.persistence.spi.PersistenceException;
import org.infinispan.protostream.SerializationContextInitializer;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoTypeId;
import org.infinispan.util.concurrent.BlockingManager;
import org.infinispan.util.concurrent.CompletableFutures;
import org.infinispan.util.concurrent.CompletionStages;
import org.infinispan.util.logging.LogFactory;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.rocksdb.BuiltinComparator;
import org.rocksdb.ColumnFamilyDescriptor;
import org.rocksdb.ColumnFamilyHandle;
import org.rocksdb.ColumnFamilyOptions;
import org.rocksdb.DBOptions;
import org.rocksdb.Options;
import org.rocksdb.ReadOptions;
import org.rocksdb.RocksDB;
import org.rocksdb.RocksDBException;
import org.rocksdb.RocksIterator;
import org.rocksdb.WriteBatch;
import org.rocksdb.WriteOptions;

@ConfiguredBy(value=RocksDBStoreConfiguration.class)
public class RocksDBStore<K, V>
implements NonBlockingStore<K, V> {
    private static final Log log = (Log)LogFactory.getLog(MethodHandles.lookup().lookupClass(), Log.class);
    private static final byte[] BEGIN_KEY = RocksDBStore.createAndFillArray(1, (byte)0);
    private static final byte[] END_KEY = RocksDBStore.createAndFillArray(128, (byte)-1);
    static final String DATABASE_PROPERTY_NAME_WITH_SUFFIX = "database.";
    static final String COLUMN_FAMILY_PROPERTY_NAME_WITH_SUFFIX = "data.";
    static final byte[] META_COLUMN_FAMILY = "meta-cf".getBytes();
    static final byte[] META_COLUMN_FAMILY_KEY = "metadata".getBytes();
    protected RocksDBStoreConfiguration configuration;
    private RocksDB db;
    private RocksDB expiredDb;
    private InitializationContext ctx;
    private TimeService timeService;
    private WriteOptions dataWriteOptions;
    private RocksDBHandler handler;
    private Properties databaseProperties;
    private Properties columnFamilyProperties;
    private Marshaller marshaller;
    private KeyPartitioner keyPartitioner;
    private MarshallableEntryFactory<K, V> entryFactory;
    private BlockingManager blockingManager;

    public CompletionStage<Void> start(InitializationContext ctx) {
        this.configuration = (RocksDBStoreConfiguration)ctx.getConfiguration();
        this.ctx = ctx;
        this.timeService = ctx.getTimeService();
        this.marshaller = ctx.getPersistenceMarshaller();
        this.entryFactory = ctx.getMarshallableEntryFactory();
        this.blockingManager = ctx.getBlockingManager();
        this.keyPartitioner = ctx.getKeyPartitioner();
        ctx.getPersistenceMarshaller().register((SerializationContextInitializer)new PersistenceContextInitializerImpl());
        Properties allProperties = this.configuration.properties();
        for (Map.Entry<Object, Object> entry : allProperties.entrySet()) {
            String key = entry.getKey().toString();
            if (key.startsWith(DATABASE_PROPERTY_NAME_WITH_SUFFIX)) {
                if (this.databaseProperties == null) {
                    this.databaseProperties = new Properties();
                }
                this.databaseProperties.setProperty(key.substring(DATABASE_PROPERTY_NAME_WITH_SUFFIX.length()), entry.getValue().toString());
                continue;
            }
            if (!key.startsWith(COLUMN_FAMILY_PROPERTY_NAME_WITH_SUFFIX)) continue;
            if (this.columnFamilyProperties == null) {
                this.columnFamilyProperties = new Properties();
            }
            this.columnFamilyProperties.setProperty(key.substring(COLUMN_FAMILY_PROPERTY_NAME_WITH_SUFFIX.length()), entry.getValue().toString());
        }
        return this.blockingManager.runBlocking(() -> {
            try {
                this.initDefaultHandler();
                MetadataImpl existingMeta = this.handler.loadMetadata();
                if (existingMeta == null && !this.configuration.purgeOnStartup()) {
                    String cacheName = ctx.getCache().getName();
                    org.infinispan.util.logging.Log.PERSISTENCE.startMigratingPersistenceData(cacheName);
                    this.migrateFromV11();
                    org.infinispan.util.logging.Log.PERSISTENCE.persistedDataSuccessfulMigrated(cacheName);
                }
                this.handler.writeMetadata();
            }
            catch (Exception e) {
                throw new CacheConfigurationException("Unable to open database", (Throwable)e);
            }
        }, (Object)"rocksdb-open");
    }

    private void initDefaultHandler() throws RocksDBException {
        this.handler = this.createHandler(this.getLocation(), this.getExpirationLocation());
        this.db = this.handler.db;
        this.expiredDb = this.handler.expiredDb;
    }

    private RocksDBHandler createHandler(Path data, Path expired) throws RocksDBException {
        AdvancedCache cache = this.ctx.getCache().getAdvancedCache();
        if (this.configuration.segmented()) {
            return new SegmentedRocksDBHandler(data, expired, cache.getCacheConfiguration().clustering().hash().numSegments());
        }
        return new NonSegmentedRocksDBHandler(data, expired, this.keyPartitioner);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void migrateFromV11() throws IOException, RocksDBException {
        IntSet segments;
        if (this.configuration.segmented()) {
            int numSegments = this.ctx.getCache().getCacheConfiguration().clustering().hash().numSegments();
            segments = IntSets.immutableRangeSet((int)numSegments);
        } else {
            segments = null;
        }
        if ((Long)CompletionStages.join(this.handler.size(segments)) == 0L) {
            return;
        }
        Path newDbLocation = this.getQualifiedLocation("new_data");
        Path newExpiredDbLocation = this.getQualifiedLocation("new_expired");
        try {
            RocksDBHandler migrationHandler = this.createHandler(newDbLocation, newExpiredDbLocation);
            Function function = it -> Flowable.fromIterable(() -> new RocksLegacyEntryIterator((RocksIterator)it));
            Object publisher = this.configuration.segmented() ? ((SegmentedRocksDBHandler)this.handler).handleIteratorFunction(function, segments) : this.handler.publish(-1, function);
            WriteBatch batch = new WriteBatch();
            HashSet expirableEntries = new HashSet();
            Flowable.fromPublisher(publisher).subscribe(e -> {
                ColumnFamilyHandle handle = migrationHandler.getHandle(this.keyPartitioner.getSegment(e.getKey()));
                batch.put(handle, e.getKeyBytes().copy().getBuf(), this.marshall(e.getMarshalledValue()));
                if (e.expiryTime() > 1L) {
                    expirableEntries.add(e);
                }
            });
            if (batch.count() <= 0) {
                batch.close();
            }
            migrationHandler.db.write(this.dataWriteOptions(), batch);
            for (MarshallableEntry e2 : expirableEntries) {
                this.addNewExpiry(migrationHandler.expiredDb, e2);
            }
            this.handler.close();
            migrationHandler.close();
            Path dataLocation = this.getLocation();
            Path expirationLocation = this.getExpirationLocation();
            Util.recursiveFileRemove((Path)dataLocation);
            Util.recursiveFileRemove((Path)expirationLocation);
            Files.move(newDbLocation, dataLocation, StandardCopyOption.REPLACE_EXISTING);
            Files.move(newExpiredDbLocation, expirationLocation, StandardCopyOption.REPLACE_EXISTING);
            this.initDefaultHandler();
        }
        finally {
            Util.recursiveFileRemove((Path)newDbLocation);
            Util.recursiveFileRemove((Path)newExpiredDbLocation);
        }
    }

    private Path getQualifiedLocation(String qualifier) {
        return PersistenceUtil.getQualifiedLocation((GlobalConfiguration)this.ctx.getGlobalConfiguration(), (String)this.configuration.location(), (String)this.ctx.getCache().getName(), (String)qualifier);
    }

    private Path getLocation() {
        return this.getQualifiedLocation("data");
    }

    private Path getExpirationLocation() {
        return this.getQualifiedLocation("expired");
    }

    private WriteOptions dataWriteOptions() {
        if (this.dataWriteOptions == null) {
            this.dataWriteOptions = new WriteOptions().setDisableWAL(false);
        }
        return this.dataWriteOptions;
    }

    protected DBOptions dataDbOptions() {
        DBOptions dbOptions;
        if (this.databaseProperties != null) {
            dbOptions = DBOptions.getDBOptionsFromProps((Properties)this.databaseProperties);
            if (dbOptions == null) {
                throw log.rocksDBUnknownPropertiesSupplied(this.databaseProperties.toString());
            }
        } else {
            dbOptions = new DBOptions();
        }
        return dbOptions.setCreateIfMissing(true).setCreateMissingColumnFamilies(true);
    }

    protected Options expiredDbOptions() {
        return new Options().setCreateIfMissing(true).setComparator(BuiltinComparator.BYTEWISE_COMPARATOR);
    }

    protected static RocksDB openDatabase(Path location, Options options) throws RocksDBException {
        File dir = location.toFile();
        dir.mkdirs();
        return RocksDB.open((Options)options, (String)location.toString());
    }

    public CompletionStage<Void> stop() {
        return this.blockingManager.runBlocking(() -> this.handler.close(), (Object)"rocksdb-stop");
    }

    public Set<NonBlockingStore.Characteristic> characteristics() {
        return EnumSet.of(NonBlockingStore.Characteristic.BULK_READ, NonBlockingStore.Characteristic.EXPIRATION, NonBlockingStore.Characteristic.SEGMENTABLE);
    }

    public CompletionStage<Boolean> isAvailable() {
        return this.blockingManager.supplyBlocking(() -> this.getLocation().toFile().exists() && this.getExpirationLocation().toFile().exists(), (Object)"rocksdb-available");
    }

    public CompletionStage<Void> clear() {
        return this.handler.clear();
    }

    public CompletionStage<Long> size(IntSet segments) {
        return this.handler.size(segments);
    }

    public CompletionStage<Long> approximateSize(IntSet segments) {
        return this.handler.approximateSize(segments);
    }

    public CompletionStage<Boolean> containsKey(int segment, Object key) {
        return this.load(segment, key).thenApply(Objects::nonNull);
    }

    public Publisher<K> publishKeys(IntSet segments, Predicate<? super K> filter) {
        return Flowable.fromPublisher(this.handler.publishEntries(segments, filter, false)).map(MarshallableEntry::getKey);
    }

    public Publisher<MarshallableEntry<K, V>> publishEntries(IntSet segments, Predicate<? super K> filter, boolean includeValues) {
        return this.handler.publishEntries(segments, filter, includeValues);
    }

    public CompletionStage<Boolean> delete(int segment, Object key) {
        return this.handler.delete(segment, key);
    }

    public CompletionStage<Void> write(int segment, MarshallableEntry<? extends K, ? extends V> entry) {
        return this.handler.write(segment, entry);
    }

    public CompletionStage<MarshallableEntry<K, V>> load(int segment, Object key) {
        return this.handler.load(segment, key);
    }

    public CompletionStage<Void> batch(int publisherCount, Publisher<NonBlockingStore.SegmentedPublisher<Object>> removePublisher, Publisher<NonBlockingStore.SegmentedPublisher<MarshallableEntry<K, V>>> writePublisher) {
        WriteBatch batch = new WriteBatch();
        HashSet expirableEntries = new HashSet();
        Flowable.fromPublisher(removePublisher).subscribe(sp -> {
            ColumnFamilyHandle handle = this.handler.getHandle(sp.getSegment());
            Flowable.fromPublisher((Publisher)sp).subscribe(removed -> batch.delete(handle, this.marshall(removed)));
        });
        Flowable.fromPublisher(writePublisher).subscribe(sp -> {
            ColumnFamilyHandle handle = this.handler.getHandle(sp.getSegment());
            Flowable.fromPublisher((Publisher)sp).subscribe(me -> {
                batch.put(handle, this.marshall(me.getKey()), this.marshall(me.getMarshalledValue()));
                if (me.expiryTime() > -1L) {
                    expirableEntries.add(me);
                }
            });
        });
        if (batch.count() <= 0) {
            batch.close();
            return CompletableFutures.completedNull();
        }
        return this.blockingManager.runBlocking(() -> {
            try {
                this.db.write(this.dataWriteOptions(), batch);
                for (MarshallableEntry me : expirableEntries) {
                    this.addNewExpiry(this.expiredDb, me);
                }
            }
            catch (RocksDBException e) {
                throw new PersistenceException((Throwable)e);
            }
        }, (Object)"rocksdb-batch").whenComplete((ignore, t) -> batch.close());
    }

    public Publisher<MarshallableEntry<K, V>> purgeExpired() {
        Publisher purgedBatches = this.blockingManager.blockingPublisher((Publisher)Flowable.defer(() -> {
            long now = this.timeService.wallClockTime();
            return this.actualPurgeExpired(now).buffer(16);
        }));
        return Flowable.fromPublisher((Publisher)purgedBatches).concatMap(Flowable::fromIterable);
    }

    private Flowable<MarshallableEntry<K, V>> actualPurgeExpired(final long now) {
        Flowable expiredFlowable = Flowable.using(() -> {
            ReadOptions readOptions = new ReadOptions().setFillCache(false);
            return new AbstractMap.SimpleImmutableEntry<ReadOptions, RocksIterator>(readOptions, this.expiredDb.newIterator(readOptions));
        }, entry -> {
            if (entry.getValue() == null) {
                return Flowable.empty();
            }
            final RocksIterator iterator = (RocksIterator)entry.getValue();
            iterator.seekToFirst();
            return Flowable.fromIterable(() -> new AbstractIterator<byte[]>(){

                protected byte[] getNext() {
                    if (!iterator.isValid()) {
                        return null;
                    }
                    byte[] keyBytes = iterator.key();
                    Long time = (Long)RocksDBStore.this.unmarshall(keyBytes);
                    if (time > now) {
                        return null;
                    }
                    try {
                        RocksDBStore.this.expiredDb.delete(keyBytes);
                    }
                    catch (RocksDBException e) {
                        throw new PersistenceException((Throwable)e);
                    }
                    byte[] value = iterator.value();
                    iterator.next();
                    return value;
                }
            });
        }, entry -> {
            ((ReadOptions)entry.getKey()).close();
            RocksIterator rocksIterator = (RocksIterator)entry.getValue();
            if (rocksIterator != null) {
                rocksIterator.close();
            }
        });
        Flowable expiredEntryFlowable = expiredFlowable.flatMap(expiredBytes -> {
            Object bucketKey = this.unmarshall((byte[])expiredBytes);
            if (bucketKey instanceof ExpiryBucket) {
                return Flowable.fromIterable(((ExpiryBucket)bucketKey).entries).flatMapMaybe(marshalledKey -> {
                    ColumnFamilyHandle columnFamilyHandle = this.handler.getHandleForMarshalledKey((byte[])marshalledKey);
                    MarshalledValue mv = this.handlePossiblyExpiredKey(columnFamilyHandle, (byte[])marshalledKey, now);
                    return mv == null ? Maybe.empty() : Maybe.just((Object)this.entryFactory.create(this.unmarshall((byte[])marshalledKey), mv));
                });
            }
            ColumnFamilyHandle columnFamilyHandle = this.handler.getHandle(bucketKey);
            MarshalledValue mv = this.handlePossiblyExpiredKey(columnFamilyHandle, this.marshall(bucketKey), now);
            return mv == null ? Flowable.empty() : Flowable.just((Object)this.entryFactory.create(bucketKey, mv));
        });
        if (log.isTraceEnabled()) {
            UnicastProcessor mirrorEntries = UnicastProcessor.create();
            expiredEntryFlowable = expiredEntryFlowable.doOnEach((Subscriber)mirrorEntries).doOnSubscribe(subscription -> log.tracef("Purging entries from RocksDBStore", new Object[0]));
            mirrorEntries.count().subscribe(count -> log.tracef("Purged %d entries from RocksDBStore", count));
        }
        return expiredEntryFlowable;
    }

    private MarshalledValue handlePossiblyExpiredKey(ColumnFamilyHandle columnFamilyHandle, byte[] marshalledKey, long now) throws RocksDBException {
        Metadata metadata;
        byte[] valueBytes = this.db.get(columnFamilyHandle, marshalledKey);
        if (valueBytes == null) {
            return null;
        }
        MarshalledValue mv = (MarshalledValue)this.unmarshall(valueBytes);
        if (mv != null && MarshallableEntryImpl.isExpired((Metadata)(metadata = (Metadata)this.unmarshall(MarshallUtil.toByteArray((ByteBuffer)mv.getMetadataBytes()))), (long)now, (long)mv.getCreated(), (long)mv.getLastUsed())) {
            this.db.delete(columnFamilyHandle, marshalledKey);
            return mv;
        }
        return null;
    }

    public CompletionStage<Void> addSegments(IntSet segments) {
        return this.handler.addSegments(segments);
    }

    public CompletionStage<Void> removeSegments(IntSet segments) {
        return this.handler.removeSegments(segments);
    }

    private byte[] marshall(Object entry) {
        try {
            return this.marshaller.objectToByteBuffer(entry);
        }
        catch (IOException e) {
            throw new PersistenceException((Throwable)e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PersistenceException((Throwable)e);
        }
    }

    private <E> E unmarshall(byte[] bytes, Marshaller marshaller) {
        if (bytes == null) {
            return null;
        }
        try {
            return (E)marshaller.objectFromByteBuffer(bytes);
        }
        catch (IOException | ClassNotFoundException e) {
            throw new PersistenceException((Throwable)e);
        }
    }

    private <E> E unmarshall(byte[] bytes) {
        return this.unmarshall(bytes, this.marshaller);
    }

    private MarshallableEntry<K, V> unmarshallEntry(Object key, byte[] valueBytes) {
        MarshalledValue value = (MarshalledValue)this.unmarshall(valueBytes);
        if (value == null) {
            return null;
        }
        return this.entryFactory.create(key, value.getValueBytes(), value.getMetadataBytes(), value.getInternalMetadataBytes(), value.getCreated(), value.getLastUsed());
    }

    private void addNewExpiry(RocksDB expiredDb, MarshallableEntry<? extends K, ? extends V> entry) throws RocksDBException {
        long expiry = entry.expiryTime();
        long maxIdle = entry.getMetadata().maxIdle();
        if (maxIdle > 0L) {
            expiry = maxIdle + this.ctx.getTimeService().wallClockTime();
        }
        byte[] keyBytes = entry.getKeyBytes().copy().getBuf();
        this.putExpireDbData(expiredDb, new ExpiryEntry(expiry, keyBytes));
    }

    private void putExpireDbData(RocksDB expiredDb, ExpiryEntry entry) throws RocksDBException {
        byte[] expiryBytes = this.marshall(entry.expiry);
        byte[] existingBytes = expiredDb.get(expiryBytes);
        if (existingBytes != null) {
            Object existing = this.unmarshall(existingBytes);
            if (existing instanceof ExpiryBucket) {
                ((ExpiryBucket)existing).entries.add(entry.keyBytes);
                expiredDb.put(expiryBytes, this.marshall(existing));
            } else {
                ExpiryBucket bucket = new ExpiryBucket(existingBytes, entry.keyBytes);
                expiredDb.put(expiryBytes, this.marshall(bucket));
            }
        } else {
            expiredDb.put(expiryBytes, entry.keyBytes);
        }
    }

    private void clearColumnFamily(ColumnFamilyHandle handle) {
        block15: {
            try {
                if (handle == null) break block15;
                this.db.deleteRange(handle, BEGIN_KEY, END_KEY);
                try (ReadOptions iteratorOptions = new ReadOptions().setFillCache(false);
                     RocksIterator it = this.db.newIterator(handle, iteratorOptions);){
                    it.seekToFirst();
                    while (it.isValid()) {
                        this.db.delete(handle, it.key());
                        it.next();
                    }
                }
            }
            catch (RocksDBException e) {
                throw new PersistenceException((Throwable)e);
            }
        }
    }

    private static byte[] createAndFillArray(int length, byte value) {
        byte[] array = new byte[length];
        Arrays.fill(array, value);
        return array;
    }

    private class SegmentedRocksDBHandler
    extends RocksDBHandler {
        private final AtomicReferenceArray<ColumnFamilyHandle> handles;

        private SegmentedRocksDBHandler(Path data, Path expired, int segmentCount) throws RocksDBException {
            this.handles = new AtomicReferenceArray(segmentCount);
            this.db = this.open(data, RocksDBStore.this.dataDbOptions());
            this.expiredDb = RocksDBStore.openDatabase(expired, RocksDBStore.this.expiredDbOptions());
        }

        byte[] byteArrayFromInt(int val) {
            return new byte[]{(byte)(val >>> 24), (byte)(val >>> 16), (byte)(val >>> 8), (byte)val};
        }

        @Override
        ColumnFamilyHandle getHandle(int segment) {
            return this.handles.get(segment);
        }

        @Override
        ColumnFamilyHandle getHandle(Object key) {
            return this.handles.get(RocksDBStore.this.keyPartitioner.getSegment(key));
        }

        @Override
        ColumnFamilyHandle getHandleForMarshalledKey(byte[] marshalledKey) {
            return this.getHandle(RocksDBStore.this.unmarshall(marshalledKey));
        }

        @Override
        RocksDB open(Path location, DBOptions options) throws RocksDBException {
            File dir = location.toFile();
            dir.mkdirs();
            int segmentCount = this.handles.length();
            ArrayList<ColumnFamilyDescriptor> descriptors = new ArrayList<ColumnFamilyDescriptor>(segmentCount + 2);
            ArrayList outHandles = new ArrayList(segmentCount + 2);
            descriptors.add(new ColumnFamilyDescriptor(RocksDB.DEFAULT_COLUMN_FAMILY, new ColumnFamilyOptions()));
            descriptors.add(new ColumnFamilyDescriptor(META_COLUMN_FAMILY, new ColumnFamilyOptions()));
            for (int i = 0; i < segmentCount; ++i) {
                descriptors.add(this.newDescriptor(this.byteArrayFromInt(i)));
            }
            RocksDB rocksDB = RocksDB.open((DBOptions)options, (String)location.toString(), descriptors, outHandles);
            this.metaColumnFamilyHandle = (ColumnFamilyHandle)outHandles.get(1);
            for (int i = 0; i < segmentCount; ++i) {
                this.handles.set(i, (ColumnFamilyHandle)outHandles.get(i + 2));
            }
            return rocksDB;
        }

        @Override
        CompletionStage<Void> clear() {
            return RocksDBStore.this.blockingManager.runBlocking(() -> {
                for (int i = 0; i < this.handles.length(); ++i) {
                    this.clearForSegment(i);
                }
            }, (Object)"rocksdb-clear");
        }

        private void clearForSegment(int segment) {
            ColumnFamilyHandle handle = this.handles.get(segment);
            RocksDBStore.this.clearColumnFamily(handle);
        }

        @Override
        void close() {
            for (int i = 0; i < this.handles.length(); ++i) {
                ColumnFamilyHandle handle = this.handles.getAndSet(i, null);
                if (handle == null) continue;
                handle.close();
            }
            this.db.close();
            this.expiredDb.close();
        }

        @Override
        Publisher<MarshallableEntry<K, V>> publishEntries(IntSet segments, Predicate<? super K> filter, boolean fetchValue) {
            Function function = it -> Flowable.fromIterable(() -> {
                long now = RocksDBStore.this.timeService.wallClockTime();
                return new RocksEntryIterator((RocksIterator)it, filter, now);
            });
            return this.handleIteratorFunction(function, segments);
        }

        @Override
        CompletionStage<Long> approximateSize(IntSet segments) {
            return RocksDBStore.this.blockingManager.subscribeBlockingCollector((Publisher)Flowable.fromIterable((Iterable)segments), Collectors.summingLong(segment -> {
                ColumnFamilyHandle handle = this.getHandle(segment);
                try {
                    return Long.parseLong(this.db.getProperty(handle, "rocksdb.estimate-num-keys"));
                }
                catch (RocksDBException e) {
                    throw new PersistenceException((Throwable)e);
                }
            }), (Object)"rocksdb-approximateSize");
        }

        <R> Publisher<R> handleIteratorFunction(Function<RocksIterator, Flowable<R>> function, IntSet segments) {
            if (segments != null && segments.size() == 1) {
                return this.publish(segments.iterator().nextInt(), function);
            }
            IntSet segmentsToUse = segments == null ? IntSets.immutableRangeSet((int)this.handles.length()) : segments;
            return Flowable.fromStream(segmentsToUse.intStream().mapToObj(i -> this.publish(i, function))).concatMap(RxJavaInterop.identityFunction());
        }

        @Override
        RocksIterator wrapIterator(RocksDB db, ReadOptions readOptions, int segment) {
            ColumnFamilyHandle handle = this.handles.get(segment);
            if (handle != null) {
                return db.newIterator(handle, readOptions);
            }
            return null;
        }

        @Override
        CompletionStage<Void> addSegments(IntSet segments) {
            Flowable segmentFlowable = Flowable.fromIterable((Iterable)segments).filter(segment -> this.handles.get((int)segment) == null);
            return RocksDBStore.this.blockingManager.subscribeBlockingConsumer((Publisher)segmentFlowable, segment -> {
                if (log.isTraceEnabled()) {
                    log.tracef("Creating column family for segment %d", segment);
                }
                byte[] cfName = this.byteArrayFromInt((int)segment);
                try {
                    ColumnFamilyHandle handle = this.db.createColumnFamily(this.newDescriptor(cfName));
                    this.handles.set((int)segment, handle);
                }
                catch (RocksDBException e) {
                    throw new PersistenceException((Throwable)e);
                }
            }, (Object)"testng-addSegments");
        }

        @Override
        CompletionStage<Void> removeSegments(IntSet segments) {
            Flowable handleFlowable = Flowable.fromIterable((Iterable)segments).map(segment -> {
                ColumnFamilyHandle cf = this.handles.getAndSet((int)segment, (ColumnFamilyHandle)null);
                return cf != null ? cf : this;
            }).ofType(ColumnFamilyHandle.class);
            return RocksDBStore.this.blockingManager.subscribeBlockingConsumer((Publisher)handleFlowable, handle -> {
                if (log.isTraceEnabled()) {
                    log.tracef("Dropping column family %s", handle);
                }
                try {
                    this.db.dropColumnFamily(handle);
                }
                catch (RocksDBException e) {
                    throw new PersistenceException((Throwable)e);
                }
                handle.close();
            }, (Object)"testng-removeSegments");
        }
    }

    private final class NonSegmentedRocksDBHandler
    extends RocksDBHandler {
        private final KeyPartitioner keyPartitioner;
        private ColumnFamilyHandle defaultColumnFamilyHandle;

        private NonSegmentedRocksDBHandler(Path data, Path expired, KeyPartitioner keyPartitioner) throws RocksDBException {
            this.db = this.open(data, RocksDBStore.this.dataDbOptions());
            this.expiredDb = RocksDBStore.openDatabase(expired, RocksDBStore.this.expiredDbOptions());
            this.keyPartitioner = keyPartitioner;
        }

        @Override
        ColumnFamilyHandle getHandle(int segment) {
            return this.defaultColumnFamilyHandle;
        }

        @Override
        ColumnFamilyHandle getHandle(Object key) {
            return this.defaultColumnFamilyHandle;
        }

        @Override
        ColumnFamilyHandle getHandleForMarshalledKey(byte[] marshalledKey) {
            return this.defaultColumnFamilyHandle;
        }

        @Override
        RocksDB open(Path location, DBOptions options) throws RocksDBException {
            File dir = location.toFile();
            dir.mkdirs();
            ArrayList<ColumnFamilyDescriptor> descriptors = new ArrayList<ColumnFamilyDescriptor>(2);
            ArrayList handles = new ArrayList(2);
            descriptors.add(this.newDescriptor(RocksDB.DEFAULT_COLUMN_FAMILY));
            descriptors.add(this.newDescriptor(META_COLUMN_FAMILY));
            RocksDB rocksDB = RocksDB.open((DBOptions)options, (String)location.toString(), descriptors, handles);
            this.defaultColumnFamilyHandle = (ColumnFamilyHandle)handles.get(0);
            this.metaColumnFamilyHandle = (ColumnFamilyHandle)handles.get(1);
            return rocksDB;
        }

        @Override
        CompletionStage<Void> clear() {
            return this.clear(null);
        }

        CompletionStage<Void> clear(IntSet segments) {
            return RocksDBStore.this.blockingManager.runBlocking(() -> {
                if (segments == null) {
                    RocksDBStore.this.clearColumnFamily(this.defaultColumnFamilyHandle);
                } else {
                    try (ReadOptions readOptions = new ReadOptions().setFillCache(false);
                         RocksIterator it = this.db.newIterator(this.defaultColumnFamilyHandle, readOptions);){
                        it.seekToFirst();
                        while (it.isValid()) {
                            byte[] keyBytes = it.key();
                            Object key = RocksDBStore.this.unmarshall(keyBytes);
                            int segment = this.keyPartitioner.getSegment(key);
                            if (segments.contains(segment)) {
                                this.db.delete(this.defaultColumnFamilyHandle, keyBytes);
                            }
                            it.next();
                        }
                    }
                    catch (Exception e) {
                        throw new PersistenceException((Throwable)e);
                    }
                }
            }, (Object)"rocksdb-clear");
        }

        @Override
        void close() {
            this.defaultColumnFamilyHandle.close();
            this.db.close();
            this.expiredDb.close();
        }

        @Override
        protected RocksIterator wrapIterator(RocksDB db, ReadOptions readOptions, int segment) {
            return db.newIterator(this.defaultColumnFamilyHandle, readOptions);
        }

        @Override
        Publisher<MarshallableEntry<K, V>> publishEntries(IntSet segments, Predicate<? super K> filter, boolean fetchValue) {
            Predicate combinedFilter = org.infinispan.persistence.internal.PersistenceUtil.combinePredicate((IntSet)segments, (KeyPartitioner)this.keyPartitioner, filter);
            return this.publish(-1, it -> Flowable.fromIterable(() -> {
                long now = RocksDBStore.this.timeService.wallClockTime();
                return new RocksEntryIterator((RocksIterator)it, combinedFilter, now);
            }));
        }

        @Override
        CompletionStage<Long> approximateSize(IntSet segments) {
            return this.size(segments);
        }

        @Override
        CompletionStage<Void> addSegments(IntSet segments) {
            return CompletableFutures.completedNull();
        }

        @Override
        CompletionStage<Void> removeSegments(IntSet segments) {
            return this.clear(segments);
        }
    }

    private abstract class RocksDBHandler {
        protected RocksDB db;
        protected RocksDB expiredDb;
        protected ColumnFamilyHandle metaColumnFamilyHandle;

        private RocksDBHandler() {
        }

        abstract RocksDB open(Path var1, DBOptions var2) throws RocksDBException;

        abstract void close();

        abstract ColumnFamilyHandle getHandle(int var1);

        abstract ColumnFamilyHandle getHandle(Object var1);

        abstract ColumnFamilyHandle getHandleForMarshalledKey(byte[] var1);

        void writeMetadata() throws RocksDBException {
            MetadataImpl metadata = new MetadataImpl(Version.getVersionShort());
            this.db.put(this.metaColumnFamilyHandle, META_COLUMN_FAMILY_KEY, RocksDBStore.this.marshall(metadata));
        }

        MetadataImpl loadMetadata() throws RocksDBException {
            return (MetadataImpl)RocksDBStore.this.unmarshall(this.db.get(this.metaColumnFamilyHandle, META_COLUMN_FAMILY_KEY));
        }

        ColumnFamilyDescriptor newDescriptor(byte[] name) {
            ColumnFamilyOptions columnFamilyOptions;
            if (RocksDBStore.this.columnFamilyProperties != null) {
                columnFamilyOptions = ColumnFamilyOptions.getColumnFamilyOptionsFromProps((Properties)RocksDBStore.this.columnFamilyProperties);
                if (columnFamilyOptions == null) {
                    throw log.rocksDBUnknownPropertiesSupplied(RocksDBStore.this.columnFamilyProperties.toString());
                }
            } else {
                columnFamilyOptions = new ColumnFamilyOptions();
            }
            if (RocksDBStore.this.configuration.attributes().attribute(RocksDBStoreConfiguration.COMPRESSION_TYPE).isModified()) {
                columnFamilyOptions.setCompressionType(RocksDBStore.this.configuration.compressionType().getValue());
            }
            return new ColumnFamilyDescriptor(name, columnFamilyOptions);
        }

        CompletionStage<MarshallableEntry<K, V>> load(int segment, Object key) {
            ColumnFamilyHandle handle = this.getHandle(segment);
            if (handle == null) {
                log.trace("Ignoring load as handle is not currently configured");
                return CompletableFutures.completedNull();
            }
            try {
                CompletionStage entryByteStage = RocksDBStore.this.blockingManager.supplyBlocking(() -> {
                    try {
                        return this.db.get(handle, RocksDBStore.this.marshall(key));
                    }
                    catch (RocksDBException e) {
                        throw new CompletionException(e);
                    }
                }, (Object)"rocksdb-load");
                return entryByteStage.thenApply(entryBytes -> {
                    MarshallableEntry me = RocksDBStore.this.unmarshallEntry(key, entryBytes);
                    if (me == null || me.isExpired(RocksDBStore.this.timeService.wallClockTime())) {
                        return null;
                    }
                    return me;
                });
            }
            catch (Exception e) {
                throw new PersistenceException((Throwable)e);
            }
        }

        CompletionStage<Void> write(int segment, MarshallableEntry<? extends K, ? extends V> me) {
            ColumnFamilyHandle handle = this.getHandle(segment);
            if (handle == null) {
                log.trace("Ignoring write as handle is not currently configured");
                return CompletableFutures.completedNull();
            }
            try {
                byte[] marshalledKey = MarshallUtil.toByteArray((ByteBuffer)me.getKeyBytes());
                byte[] marshalledValue = RocksDBStore.this.marshall(me.getMarshalledValue());
                return RocksDBStore.this.blockingManager.runBlocking(() -> {
                    try {
                        this.db.put(handle, marshalledKey, marshalledValue);
                        if (me.expiryTime() > -1L) {
                            RocksDBStore.this.addNewExpiry(this.expiredDb, me);
                        }
                    }
                    catch (RocksDBException e) {
                        throw new PersistenceException((Throwable)e);
                    }
                }, (Object)"rocksdb-write");
            }
            catch (Exception e) {
                throw new PersistenceException((Throwable)e);
            }
        }

        CompletionStage<Boolean> delete(int segment, Object key) {
            try {
                byte[] keyBytes = RocksDBStore.this.marshall(key);
                ColumnFamilyHandle handle = this.getHandle(segment);
                return RocksDBStore.this.blockingManager.supplyBlocking(() -> {
                    try {
                        this.db.delete(handle, keyBytes);
                        return null;
                    }
                    catch (RocksDBException e) {
                        throw new PersistenceException((Throwable)e);
                    }
                }, (Object)"rocksdb-delete");
            }
            catch (Exception e) {
                throw new PersistenceException((Throwable)e);
            }
        }

        abstract CompletionStage<Void> clear();

        abstract Publisher<MarshallableEntry<K, V>> publishEntries(IntSet var1, Predicate<? super K> var2, boolean var3);

        CompletionStage<Long> size(IntSet segments) {
            return Flowable.fromPublisher(RocksDBStore.this.publishKeys(segments, null)).count().toCompletionStage();
        }

        abstract CompletionStage<Long> approximateSize(IntSet var1);

        <P> Publisher<P> publish(int segment, Function<RocksIterator, Flowable<P>> function) {
            ReadOptions readOptions = new ReadOptions().setFillCache(false);
            return RocksDBStore.this.blockingManager.blockingPublisher((Publisher)Flowable.using(() -> this.wrapIterator(this.db, readOptions, segment), iterator -> {
                if (iterator == null) {
                    return Flowable.empty();
                }
                iterator.seekToFirst();
                return (Publisher)function.apply((RocksIterator)iterator);
            }, iterator -> {
                if (iterator != null) {
                    iterator.close();
                }
                readOptions.close();
            }));
        }

        abstract RocksIterator wrapIterator(RocksDB var1, ReadOptions var2, int var3);

        abstract CompletionStage<Void> addSegments(IntSet var1);

        abstract CompletionStage<Void> removeSegments(IntSet var1);
    }

    private class RocksEntryIterator
    extends AbstractIterator<MarshallableEntry<K, V>> {
        private final RocksIterator it;
        private final Predicate<? super K> filter;
        private final long now;

        RocksEntryIterator(RocksIterator it, Predicate<? super K> filter, long now) {
            this.it = it;
            this.filter = filter;
            this.now = now;
        }

        protected MarshallableEntry<K, V> getNext() {
            MarshallableEntry entry = null;
            while (entry == null && this.it.isValid()) {
                MarshallableEntry me;
                Object key = RocksDBStore.this.unmarshall(this.it.key());
                if ((this.filter == null || this.filter.test(key)) && (me = RocksDBStore.this.unmarshallEntry(key, this.it.value())) != null && !me.isExpired(this.now)) {
                    entry = me;
                }
                this.it.next();
            }
            return entry;
        }
    }

    private class RocksLegacyEntryIterator
    extends AbstractIterator<MarshallableEntry<K, V>> {
        private final RocksIterator it;
        private final long now;
        private final PersistenceMarshaller pm;
        private final Marshaller userMarshaller;

        RocksLegacyEntryIterator(RocksIterator it) {
            this.it = it;
            this.now = RocksDBStore.this.timeService.wallClockTime();
            this.pm = RocksDBStore.this.ctx.getPersistenceMarshaller();
            this.userMarshaller = this.pm.getUserMarshaller();
        }

        protected MarshallableEntry<K, V> getNext() {
            MarshallableEntry entry = null;
            while (entry == null && this.it.isValid()) {
                Metadata meta;
                Object key = RocksDBStore.this.unmarshall(this.it.key(), this.userMarshaller);
                MarshalledValue mv = (MarshalledValue)RocksDBStore.this.unmarshall(this.it.value(), (Marshaller)this.pm);
                Object value = RocksDBStore.this.unmarshall(mv.getValueBytes().getBuf(), this.userMarshaller);
                try {
                    meta = (Metadata)RocksDBStore.this.unmarshall(mv.getMetadataBytes().getBuf(), this.userMarshaller);
                }
                catch (IllegalArgumentException e) {
                    meta = (Metadata)RocksDBStore.this.unmarshall(mv.getMetadataBytes().getBuf(), (Marshaller)this.pm);
                }
                PrivateMetadata internalMeta = (PrivateMetadata)RocksDBStore.this.unmarshall(mv.getInternalMetadataBytes().copy().getBuf(), this.userMarshaller);
                MarshallableEntry me = RocksDBStore.this.entryFactory.create(key, value, meta, internalMeta, mv.getCreated(), mv.getLastUsed());
                if (me != null && !me.isExpired(this.now)) {
                    entry = me;
                }
                this.it.next();
            }
            return entry;
        }
    }

    private static final class ExpiryEntry {
        final long expiry;
        final byte[] keyBytes;

        ExpiryEntry(long expiry, byte[] keyBytes) {
            this.expiry = expiry;
            this.keyBytes = keyBytes;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ExpiryEntry that = (ExpiryEntry)o;
            return this.expiry == that.expiry && Arrays.equals(this.keyBytes, that.keyBytes);
        }

        public int hashCode() {
            int result = Objects.hash(this.expiry);
            result = 31 * result + Arrays.hashCode(this.keyBytes);
            return result;
        }
    }

    @ProtoTypeId(value=5101)
    static final class MetadataImpl {
        @ProtoField(number=1, defaultValue="-1")
        short version;

        @ProtoFactory
        MetadataImpl(short version) {
            this.version = version;
        }
    }

    @ProtoTypeId(value=5100)
    static final class ExpiryBucket {
        @ProtoField(number=1, collectionImplementation=ArrayList.class)
        List<byte[]> entries;

        ExpiryBucket() {
        }

        ExpiryBucket(byte[] existingKey, byte[] newKey) {
            this.entries = new ArrayList<byte[]>(2);
            this.entries.add(existingKey);
            this.entries.add(newKey);
        }
    }
}

