/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.rocksdb;

import io.reactivex.Flowable;
import io.reactivex.Scheduler;
import io.reactivex.schedulers.Schedulers;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.PrimitiveIterator;
import java.util.Properties;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.function.Function;
import java.util.function.Predicate;
import org.infinispan.AdvancedCache;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.configuration.ConfiguredBy;
import org.infinispan.commons.persistence.Store;
import org.infinispan.commons.util.AbstractIterator;
import org.infinispan.commons.util.IntSet;
import org.infinispan.commons.util.IntSets;
import org.infinispan.commons.util.Util;
import org.infinispan.distribution.ch.KeyPartitioner;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.marshall.core.MarshalledEntry;
import org.infinispan.metadata.InternalMetadata;
import org.infinispan.persistence.internal.PersistenceUtil;
import org.infinispan.persistence.rocksdb.configuration.RocksDBStoreConfiguration;
import org.infinispan.persistence.rocksdb.logging.Log;
import org.infinispan.persistence.spi.AdvancedCacheWriter;
import org.infinispan.persistence.spi.InitializationContext;
import org.infinispan.persistence.spi.PersistenceException;
import org.infinispan.persistence.spi.SegmentedAdvancedLoadWriteStore;
import org.infinispan.util.TimeService;
import org.infinispan.util.logging.LogFactory;
import org.reactivestreams.Publisher;
import org.rocksdb.BuiltinComparator;
import org.rocksdb.ColumnFamilyDescriptor;
import org.rocksdb.ColumnFamilyHandle;
import org.rocksdb.ColumnFamilyOptions;
import org.rocksdb.CompressionType;
import org.rocksdb.DBOptions;
import org.rocksdb.Options;
import org.rocksdb.ReadOptions;
import org.rocksdb.RocksDB;
import org.rocksdb.RocksDBException;
import org.rocksdb.RocksIterator;
import org.rocksdb.WriteBatch;
import org.rocksdb.WriteOptions;

@Store
@ConfiguredBy(value=RocksDBStoreConfiguration.class)
public class RocksDBStore<K, V>
implements SegmentedAdvancedLoadWriteStore<K, V> {
    private static final Log log = (Log)LogFactory.getLog(RocksDBStore.class, Log.class);
    static final String databasePropertyNameWithSuffix = "database.";
    static final String columnFamilyPropertyNameWithSuffix = "data.";
    private RocksDBStoreConfiguration configuration;
    private BlockingQueue<ExpiryEntry> expiryEntryQueue;
    private RocksDB db;
    private RocksDB expiredDb;
    private InitializationContext ctx;
    private Scheduler scheduler;
    private TimeService timeService;
    private Semaphore semaphore;
    private WriteOptions dataWriteOptions;
    private RocksDBHandler handler;
    private Properties databaseProperties;
    private Properties columnFamilyProperties;
    private volatile boolean stopped = true;

    public void init(InitializationContext ctx) {
        this.configuration = (RocksDBStoreConfiguration)ctx.getConfiguration();
        this.ctx = ctx;
        this.scheduler = Schedulers.from((Executor)ctx.getExecutor());
        this.timeService = ctx.getTimeService();
        this.semaphore = new Semaphore(Integer.MAX_VALUE, true);
    }

    public void start() {
        this.expiryEntryQueue = new LinkedBlockingQueue<ExpiryEntry>(this.configuration.expiryQueueSize());
        AdvancedCache cache = this.ctx.getCache().getAdvancedCache();
        ComponentRegistry registry = cache.getComponentRegistry();
        KeyPartitioner keyPartitioner = (KeyPartitioner)registry.getComponent(KeyPartitioner.class);
        this.handler = this.configuration.segmented() ? new SegmentedRocksDBHandler(cache.getCacheConfiguration().clustering().hash().numSegments(), keyPartitioner) : new NonSegmentedRocksDBHandler(keyPartitioner);
        Properties allProperties = this.configuration.properties();
        for (Map.Entry<Object, Object> entry : allProperties.entrySet()) {
            String key = entry.getKey().toString();
            if (key.startsWith(databasePropertyNameWithSuffix)) {
                if (this.databaseProperties == null) {
                    this.databaseProperties = new Properties();
                }
                this.databaseProperties.setProperty(key.substring(databasePropertyNameWithSuffix.length()), entry.getValue().toString());
                continue;
            }
            if (!key.startsWith(columnFamilyPropertyNameWithSuffix)) continue;
            if (this.columnFamilyProperties == null) {
                this.columnFamilyProperties = new Properties();
            }
            this.columnFamilyProperties.setProperty(key.substring(columnFamilyPropertyNameWithSuffix.length()), entry.getValue().toString());
        }
        try {
            this.db = this.handler.open(this.getQualifiedLocation(), this.dataDbOptions());
            this.expiredDb = this.openDatabase(this.getQualifiedExpiredLocation(), this.expiredDbOptions());
            this.stopped = false;
        }
        catch (Exception e) {
            throw new CacheConfigurationException("Unable to open database", (Throwable)e);
        }
    }

    private String sanitizedCacheName() {
        return this.ctx.getCache().getName().replaceAll("[^a-zA-Z0-9-_\\.]", "_");
    }

    private String getQualifiedLocation() {
        return this.configuration.location() + this.sanitizedCacheName();
    }

    private String getQualifiedExpiredLocation() {
        return this.configuration.expiredLocation() + this.sanitizedCacheName();
    }

    private WriteOptions dataWriteOptions() {
        if (this.dataWriteOptions == null) {
            this.dataWriteOptions = new WriteOptions().setDisableWAL(false);
        }
        return this.dataWriteOptions;
    }

    private DBOptions dataDbOptions() {
        DBOptions dbOptions;
        if (this.databaseProperties != null) {
            dbOptions = DBOptions.getDBOptionsFromProps((Properties)this.databaseProperties);
            if (dbOptions == null) {
                throw log.rocksDBUnknownPropertiesSupplied(this.databaseProperties.toString());
            }
        } else {
            dbOptions = new DBOptions();
        }
        return dbOptions.setCreateIfMissing(true).setCreateMissingColumnFamilies(true);
    }

    private Options expiredDbOptions() {
        return new Options().setCreateIfMissing(true).setComparator(BuiltinComparator.BYTEWISE_COMPARATOR);
    }

    protected RocksDB openDatabase(String location, Options options) throws IOException, RocksDBException {
        File dir = new File(location);
        dir.mkdirs();
        return RocksDB.open((Options)options, (String)location);
    }

    public void stop() {
        try {
            this.semaphore.acquire(Integer.MAX_VALUE);
        }
        catch (InterruptedException e) {
            throw new PersistenceException("Cannot acquire semaphore", (Throwable)e);
        }
        try {
            this.handler.close();
            this.expiredDb.close();
        }
        finally {
            this.stopped = true;
            this.semaphore.release(Integer.MAX_VALUE);
        }
    }

    public void destroy() {
        this.stop();
        Util.recursiveFileRemove((File)new File(this.getQualifiedLocation()));
        Util.recursiveFileRemove((File)new File(this.getQualifiedExpiredLocation()));
    }

    public boolean isAvailable() {
        return new File(this.getQualifiedLocation()).exists() && new File(this.getQualifiedExpiredLocation()).exists();
    }

    public void clear() {
        this.handler.clear(null);
    }

    public void clear(IntSet segments) {
        this.handler.clear(segments);
    }

    public int size() {
        return this.handler.size(null);
    }

    public int size(IntSet segments) {
        return this.handler.size(segments);
    }

    public boolean contains(Object key) {
        return this.handler.contains(-1, key);
    }

    public boolean contains(int segment, Object key) {
        return this.handler.contains(segment, key);
    }

    public Publisher<K> publishKeys(Predicate<? super K> filter) {
        return this.handler.publishKeys(null, filter);
    }

    public Publisher<K> publishKeys(IntSet segments, Predicate<? super K> filter) {
        return this.handler.publishKeys(segments, filter);
    }

    public Publisher<MarshalledEntry<K, V>> publishEntries(Predicate<? super K> filter, boolean fetchValue, boolean fetchMetadata) {
        return this.handler.publishEntries(null, filter, fetchValue, fetchMetadata);
    }

    public Publisher<MarshalledEntry<K, V>> publishEntries(IntSet segments, Predicate<? super K> filter, boolean fetchValue, boolean fetchMetadata) {
        return this.handler.publishEntries(segments, filter, fetchValue, fetchMetadata);
    }

    public boolean delete(Object key) {
        return this.handler.delete(-1, key);
    }

    public boolean delete(int segment, Object key) {
        return this.handler.delete(segment, key);
    }

    public void write(MarshalledEntry entry) {
        this.handler.write(-1, entry);
    }

    public void write(int segment, MarshalledEntry<? extends K, ? extends V> entry) {
        this.handler.write(segment, entry);
    }

    public MarshalledEntry load(Object key) {
        return this.handler.load(-1, key);
    }

    public MarshalledEntry<K, V> load(int segment, Object key) {
        return this.handler.load(segment, key);
    }

    public void writeBatch(Iterable<MarshalledEntry<? extends K, ? extends V>> marshalledEntries) {
        this.handler.writeBatch(marshalledEntries);
    }

    public void deleteBatch(Iterable<Object> keys) {
        this.handler.deleteBatch(keys);
    }

    public void purge(Executor executor, AdvancedCacheWriter.PurgeListener purgeListener) {
        block33: {
            try {
                this.semaphore.acquire();
            }
            catch (InterruptedException e) {
                throw new PersistenceException("Cannot acquire semaphore: CacheStore is likely stopped.", (Throwable)e);
            }
            try {
                if (this.stopped) {
                    throw new PersistenceException("RocksDB is stopped");
                }
                ArrayList entries = new ArrayList();
                this.expiryEntryQueue.drainTo(entries);
                for (ExpiryEntry entry : entries) {
                    byte[] expiryBytes = this.marshall(entry.expiry);
                    byte[] keyBytes = this.marshall(entry.key);
                    byte[] existingBytes = this.expiredDb.get(expiryBytes);
                    if (existingBytes != null) {
                        Object existing = this.unmarshall(existingBytes);
                        if (existing instanceof List) {
                            ((List)existing).add(entry.key);
                            this.expiredDb.put(expiryBytes, this.marshall(existing));
                            continue;
                        }
                        ArrayList<Object> al = new ArrayList<Object>(2);
                        al.add(existing);
                        al.add(entry.key);
                        this.expiredDb.put(expiryBytes, this.marshall(al));
                        continue;
                    }
                    this.expiredDb.put(expiryBytes, keyBytes);
                }
                ArrayList<Object> times = new ArrayList<Object>();
                ArrayList<Object> keys = new ArrayList<Object>();
                long now = this.ctx.getTimeService().wallClockTime();
                RocksIterator iterator = this.expiredDb.newIterator(new ReadOptions().setFillCache(false));
                if (iterator == null) break block33;
                try (RocksIterator it = iterator;){
                    Object time;
                    it.seekToFirst();
                    while (it.isValid() && (Long)(time = (Long)this.unmarshall(it.key())) <= now) {
                        times.add(time);
                        Object object = this.unmarshall(it.value());
                        if (object instanceof List) {
                            keys.addAll((List)object);
                        } else {
                            keys.add(object);
                        }
                        it.next();
                    }
                    for (Long l : times) {
                        this.expiredDb.delete(this.marshall(l));
                    }
                    if (!keys.isEmpty()) {
                        log.debugf("purge (up to) %d entries", keys.size());
                    }
                    int count = 0;
                    for (Object e : keys) {
                        MarshalledEntry me;
                        byte[] keyBytes;
                        int segment = this.handler.calculateSegment(e);
                        ColumnFamilyHandle handle = this.handler.getHandle(segment);
                        byte[] b = this.db.get(handle, keyBytes = this.marshall(e));
                        if (b == null || (me = (MarshalledEntry)this.ctx.getMarshaller().objectFromByteBuffer(b)).getMetadata() == null || !me.getMetadata().isExpired(now)) continue;
                        this.db.delete(handle, keyBytes);
                        purgeListener.entryPurged(e);
                        ++count;
                    }
                    if (count != 0) {
                        log.debugf("purged %d entries", count);
                    }
                }
                catch (Exception e) {
                    throw new PersistenceException((Throwable)e);
                }
            }
            catch (PersistenceException e) {
                throw e;
            }
            catch (Exception e) {
                throw new PersistenceException((Throwable)e);
            }
            finally {
                this.semaphore.release();
            }
        }
    }

    public void addSegments(IntSet segments) {
        this.handler.addSegments(segments);
    }

    public void removeSegments(IntSet segments) {
        this.handler.removeSegments(segments);
    }

    private byte[] marshall(Object entry) throws IOException, InterruptedException {
        return this.ctx.getMarshaller().objectToByteBuffer(entry);
    }

    private Object unmarshall(byte[] bytes) throws IOException, ClassNotFoundException {
        if (bytes == null) {
            return null;
        }
        return this.ctx.getMarshaller().objectFromByteBuffer(bytes);
    }

    private void addNewExpiry(MarshalledEntry entry) throws IOException {
        long expiry = entry.getMetadata().expiryTime();
        long maxIdle = entry.getMetadata().maxIdle();
        if (maxIdle > 0L) {
            expiry = maxIdle + this.ctx.getTimeService().wallClockTime();
        }
        Long at = expiry;
        Object key = entry.getKey();
        try {
            this.expiryEntryQueue.put(new ExpiryEntry(at, key));
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    private class SegmentedRocksDBHandler
    extends RocksDBHandler {
        private final KeyPartitioner keyPartitioner;
        private final AtomicReferenceArray<ColumnFamilyHandle> handles;

        private SegmentedRocksDBHandler(int segmentCount, KeyPartitioner keyPartitioner) {
            this.keyPartitioner = keyPartitioner;
            this.handles = new AtomicReferenceArray(segmentCount);
        }

        byte[] byteArrayFromInt(int val) {
            return new byte[]{(byte)(val >>> 24), (byte)(val >>> 16), (byte)(val >>> 8), (byte)val};
        }

        @Override
        ColumnFamilyHandle getHandle(int segment) {
            return this.handles.get(segment);
        }

        @Override
        int calculateSegment(Object key) {
            return this.keyPartitioner.getSegment(key);
        }

        @Override
        RocksDB open(String location, DBOptions options) throws RocksDBException {
            File dir = new File(location);
            dir.mkdirs();
            int segmentCount = this.handles.length();
            ArrayList<ColumnFamilyDescriptor> descriptors = new ArrayList<ColumnFamilyDescriptor>(segmentCount + 1);
            ArrayList outHandles = new ArrayList(segmentCount + 1);
            descriptors.add(new ColumnFamilyDescriptor(RocksDB.DEFAULT_COLUMN_FAMILY, new ColumnFamilyOptions()));
            for (int i = 0; i < segmentCount; ++i) {
                descriptors.add(this.newDescriptor(this.byteArrayFromInt(i)));
            }
            RocksDB rocksDB = RocksDB.open((DBOptions)options, (String)location, descriptors, outHandles);
            for (int i = 0; i < segmentCount; ++i) {
                this.handles.set(i, (ColumnFamilyHandle)outHandles.get(i + 1));
            }
            return rocksDB;
        }

        @Override
        void clear(IntSet segments) {
            if (segments != null) {
                PrimitiveIterator.OfInt segmentIterator = segments.iterator();
                while (segmentIterator.hasNext()) {
                    int segment = segmentIterator.nextInt();
                    if (this.clearForSegment(segment)) continue;
                    this.recreateColumnFamily(segment);
                }
            } else {
                for (int i = 0; i < this.handles.length(); ++i) {
                    if (this.clearForSegment(i)) continue;
                    this.recreateColumnFamily(i);
                }
            }
        }

        /*
         * Exception decompiling
         */
        private boolean clearForSegment(int segment) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[TRYBLOCK]], but top level block is 23[WHILELOOP]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        @Override
        void close() {
            for (int i = 0; i < this.handles.length(); ++i) {
                ColumnFamilyHandle handle = this.handles.getAndSet(i, null);
                if (handle == null) continue;
                handle.close();
            }
            RocksDBStore.this.db.close();
        }

        private void recreateColumnFamily(int segment) {
            ColumnFamilyHandle handle = this.handles.get(segment);
            if (handle != null) {
                try {
                    RocksDBStore.this.db.dropColumnFamily(handle);
                    handle = RocksDBStore.this.db.createColumnFamily(this.newDescriptor(this.byteArrayFromInt(segment)));
                    this.handles.set(segment, handle);
                }
                catch (RocksDBException e) {
                    throw new PersistenceException((Throwable)e);
                }
            }
        }

        @Override
        Publisher<K> publishKeys(IntSet segments, Predicate<? super K> filter) {
            return PersistenceUtil.parallelizePublisher((IntSet)(segments == null ? IntSets.immutableRangeSet((int)this.handles.length()) : segments), (Scheduler)RocksDBStore.this.scheduler, i -> this.publish(i, it -> Flowable.fromIterable(() -> new RocksKeyIterator((RocksIterator)it, filter))));
        }

        @Override
        Publisher<MarshalledEntry<K, V>> publishEntries(IntSet segments, Predicate<? super K> filter, boolean fetchValue, boolean fetchMetadata) {
            return PersistenceUtil.parallelizePublisher((IntSet)(segments == null ? IntSets.immutableRangeSet((int)this.handles.length()) : segments), (Scheduler)RocksDBStore.this.scheduler, i -> this.publish(i, it -> Flowable.fromIterable(() -> {
                long now = RocksDBStore.this.timeService.wallClockTime();
                return new RocksEntryIterator((RocksIterator)it, filter, fetchValue, fetchMetadata, now);
            })));
        }

        @Override
        RocksIterator wrapIterator(RocksDB db, int segment) {
            ColumnFamilyHandle handle = this.handles.get(segment);
            if (handle != null) {
                return db.newIterator(handle, new ReadOptions().setFillCache(false));
            }
            return null;
        }

        @Override
        void addSegments(IntSet segments) {
            PrimitiveIterator.OfInt segmentIterator = segments.iterator();
            while (segmentIterator.hasNext()) {
                int segment = segmentIterator.nextInt();
                ColumnFamilyHandle handle = this.handles.get(segment);
                if (handle != null) continue;
                log.tracef("Creating column family for segment %d", segment);
                byte[] cfName = this.byteArrayFromInt(segment);
                try {
                    handle = RocksDBStore.this.db.createColumnFamily(this.newDescriptor(cfName));
                    this.handles.set(segment, handle);
                }
                catch (RocksDBException e) {
                    throw new PersistenceException((Throwable)e);
                }
            }
        }

        @Override
        void removeSegments(IntSet segments) {
            PrimitiveIterator.OfInt segmentIterator = segments.iterator();
            while (segmentIterator.hasNext()) {
                int segment = segmentIterator.nextInt();
                ColumnFamilyHandle handle = this.handles.getAndSet(segment, null);
                if (handle == null) continue;
                log.tracef("Dropping column family for segment %d", segment);
                try {
                    RocksDBStore.this.db.dropColumnFamily(handle);
                }
                catch (RocksDBException e) {
                    throw new PersistenceException((Throwable)e);
                }
                handle.close();
            }
        }
    }

    private final class NonSegmentedRocksDBHandler
    extends RocksDBHandler {
        private final KeyPartitioner keyPartitioner;
        private ColumnFamilyHandle defaultColumnFamilyHandle;

        public NonSegmentedRocksDBHandler(KeyPartitioner keyPartitioner) {
            this.keyPartitioner = keyPartitioner;
        }

        @Override
        ColumnFamilyHandle getHandle(int segment) {
            return this.defaultColumnFamilyHandle;
        }

        @Override
        int calculateSegment(Object key) {
            return 0;
        }

        @Override
        RocksDB open(String location, DBOptions options) throws RocksDBException {
            File dir = new File(location);
            dir.mkdirs();
            ArrayList handles = new ArrayList(1);
            RocksDB rocksDB = RocksDB.open((DBOptions)options, (String)location, Collections.singletonList(this.newDescriptor(RocksDB.DEFAULT_COLUMN_FAMILY)), handles);
            this.defaultColumnFamilyHandle = (ColumnFamilyHandle)handles.get(0);
            return rocksDB;
        }

        @Override
        void clear(IntSet segments) {
            boolean destroyDatabase;
            block32: {
                long count = 0L;
                destroyDatabase = false;
                try {
                    RocksDBStore.this.semaphore.acquire();
                }
                catch (InterruptedException e) {
                    throw new PersistenceException("Cannot acquire semaphore", (Throwable)e);
                }
                try {
                    if (RocksDBStore.this.stopped) {
                        throw new PersistenceException("RocksDB is stopped");
                    }
                    RocksIterator optionalIterator = this.wrapIterator(RocksDBStore.this.db, -1);
                    if (optionalIterator != null && (RocksDBStore.this.configuration.clearThreshold() > 0 || segments == null)) {
                        try (RocksIterator it = optionalIterator;){
                            it.seekToFirst();
                            while (it.isValid()) {
                                byte[] keyBytes = it.key();
                                if (segments != null) {
                                    Object key = RocksDBStore.this.unmarshall(keyBytes);
                                    if (segments.contains(this.keyPartitioner.getSegment(key))) {
                                        RocksDBStore.this.db.delete(this.defaultColumnFamilyHandle, keyBytes);
                                    }
                                } else {
                                    RocksDBStore.this.db.delete(this.defaultColumnFamilyHandle, keyBytes);
                                    if (++count > (long)RocksDBStore.this.configuration.clearThreshold()) {
                                        destroyDatabase = true;
                                        break block32;
                                    }
                                }
                                it.next();
                            }
                            break block32;
                        }
                        catch (RocksDBException e) {
                            if (segments != null) {
                                throw e;
                            }
                            destroyDatabase = true;
                        }
                        break block32;
                    }
                    destroyDatabase = true;
                }
                catch (Exception e) {
                    throw new PersistenceException((Throwable)e);
                }
                finally {
                    RocksDBStore.this.semaphore.release();
                }
            }
            if (destroyDatabase) {
                try {
                    this.reinitAllDatabases();
                }
                catch (Exception e) {
                    throw new PersistenceException((Throwable)e);
                }
            }
        }

        @Override
        void close() {
            this.defaultColumnFamilyHandle.close();
            RocksDBStore.this.db.close();
        }

        protected void reinitAllDatabases() throws IOException, RocksDBException {
            try {
                RocksDBStore.this.semaphore.acquire(Integer.MAX_VALUE);
            }
            catch (InterruptedException e) {
                throw new PersistenceException("Cannot acquire semaphore", (Throwable)e);
            }
            try {
                if (RocksDBStore.this.stopped) {
                    throw new PersistenceException("RocksDB is stopped");
                }
                RocksDBStore.this.db.close();
                RocksDBStore.this.expiredDb.close();
                System.gc();
                String dataLocation = RocksDBStore.this.getQualifiedLocation();
                Util.recursiveFileRemove((File)new File(dataLocation));
                RocksDBStore.this.db = this.open(RocksDBStore.this.getQualifiedLocation(), RocksDBStore.this.dataDbOptions());
                String expirationLocation = RocksDBStore.this.getQualifiedExpiredLocation();
                Util.recursiveFileRemove((File)new File(expirationLocation));
                RocksDBStore.this.expiredDb = RocksDBStore.this.openDatabase(expirationLocation, RocksDBStore.this.expiredDbOptions());
            }
            finally {
                RocksDBStore.this.semaphore.release(Integer.MAX_VALUE);
            }
        }

        @Override
        protected RocksIterator wrapIterator(RocksDB db, int segment) {
            return db.newIterator(this.defaultColumnFamilyHandle, new ReadOptions().setFillCache(false));
        }

        @Override
        Publisher<K> publishKeys(IntSet segments, Predicate<? super K> filter) {
            Predicate combinedFilter = PersistenceUtil.combinePredicate((IntSet)segments, (KeyPartitioner)this.keyPartitioner, filter);
            return this.publish(-1, it -> Flowable.fromIterable(() -> new RocksKeyIterator((RocksIterator)it, combinedFilter)));
        }

        @Override
        Publisher<MarshalledEntry<K, V>> publishEntries(IntSet segments, Predicate<? super K> filter, boolean fetchValue, boolean fetchMetadata) {
            Predicate combinedFilter = PersistenceUtil.combinePredicate((IntSet)segments, (KeyPartitioner)this.keyPartitioner, filter);
            return this.publish(-1, it -> Flowable.fromIterable(() -> {
                long now = RocksDBStore.this.timeService.wallClockTime();
                return new RocksEntryIterator((RocksIterator)it, combinedFilter, fetchValue, fetchMetadata, now);
            }));
        }

        @Override
        void addSegments(IntSet segments) {
        }

        @Override
        void removeSegments(IntSet segments) {
            this.clear(segments);
        }
    }

    private abstract class RocksDBHandler {
        private RocksDBHandler() {
        }

        abstract RocksDB open(String var1, DBOptions var2) throws RocksDBException;

        abstract void close();

        abstract ColumnFamilyHandle getHandle(int var1);

        final ColumnFamilyHandle getHandle(int segment, Object key) {
            if (segment < 0) {
                segment = this.calculateSegment(key);
            }
            return this.getHandle(segment);
        }

        abstract int calculateSegment(Object var1);

        ColumnFamilyDescriptor newDescriptor(byte[] name) {
            ColumnFamilyOptions columnFamilyOptions;
            if (RocksDBStore.this.columnFamilyProperties != null) {
                columnFamilyOptions = ColumnFamilyOptions.getColumnFamilyOptionsFromProps((Properties)RocksDBStore.this.columnFamilyProperties);
                if (columnFamilyOptions == null) {
                    throw log.rocksDBUnknownPropertiesSupplied(RocksDBStore.this.columnFamilyProperties.toString());
                }
            } else {
                columnFamilyOptions = new ColumnFamilyOptions();
            }
            return new ColumnFamilyDescriptor(name, columnFamilyOptions.setCompressionType(CompressionType.getCompressionType((String)RocksDBStore.this.configuration.compressionType().toString())));
        }

        boolean contains(int segment, Object key) {
            return this.load(segment, key) != null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        MarshalledEntry<K, V> load(int segment, Object key) {
            ColumnFamilyHandle handle = this.getHandle(segment, key);
            if (handle == null) {
                log.trace("Ignoring load as handle is not currently configured");
                return null;
            }
            try {
                byte[] marshalledEntry;
                RocksDBStore.this.semaphore.acquire();
                try {
                    if (RocksDBStore.this.stopped) {
                        throw new PersistenceException("RocksDB is stopped");
                    }
                    marshalledEntry = RocksDBStore.this.db.get(handle, RocksDBStore.this.marshall(key));
                }
                finally {
                    RocksDBStore.this.semaphore.release();
                }
                MarshalledEntry me = (MarshalledEntry)RocksDBStore.this.unmarshall(marshalledEntry);
                if (me == null) {
                    return null;
                }
                InternalMetadata meta = me.getMetadata();
                if (meta != null && meta.isExpired(RocksDBStore.this.timeService.wallClockTime())) {
                    return null;
                }
                return me;
            }
            catch (Exception e) {
                throw new PersistenceException((Throwable)e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void write(int segment, MarshalledEntry<? extends K, ? extends V> me) {
            Object key = me.getKey();
            ColumnFamilyHandle handle = this.getHandle(segment, key);
            if (handle == null) {
                log.trace("Ignoring write as handle is not currently configured");
                return;
            }
            try {
                byte[] marshalledKey = RocksDBStore.this.marshall(key);
                byte[] marshalledEntry = RocksDBStore.this.marshall(me);
                RocksDBStore.this.semaphore.acquire();
                try {
                    if (RocksDBStore.this.stopped) {
                        throw new PersistenceException("RocksDB is stopped");
                    }
                    RocksDBStore.this.db.put(handle, marshalledKey, marshalledEntry);
                }
                finally {
                    RocksDBStore.this.semaphore.release();
                }
                InternalMetadata meta = me.getMetadata();
                if (meta != null && meta.expiryTime() > -1L) {
                    RocksDBStore.this.addNewExpiry(me);
                }
            }
            catch (Exception e) {
                throw new PersistenceException((Throwable)e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        boolean delete(int segment, Object key) {
            try {
                byte[] keyBytes = RocksDBStore.this.marshall(key);
                RocksDBStore.this.semaphore.acquire();
                try {
                    if (RocksDBStore.this.stopped) {
                        throw new PersistenceException("RocksDB is stopped");
                    }
                    if (RocksDBStore.this.db.get(this.getHandle(segment, key), keyBytes) == null) {
                        boolean bl = false;
                        return bl;
                    }
                    RocksDBStore.this.db.delete(this.getHandle(segment, key), keyBytes);
                    return true;
                }
                finally {
                    RocksDBStore.this.semaphore.release();
                }
            }
            catch (Exception e) {
                throw new PersistenceException((Throwable)e);
            }
        }

        void writeBatch(Iterable<MarshalledEntry<? extends K, ? extends V>> marshalledEntries) {
            try {
                int batchSize = 0;
                WriteBatch batch = new WriteBatch();
                for (MarshalledEntry marshalledEntry : marshalledEntries) {
                    Object key = marshalledEntry.getKey();
                    batch.put(this.getHandle(this.calculateSegment(key)), RocksDBStore.this.marshall(key), RocksDBStore.this.marshall(marshalledEntry));
                    if (++batchSize != RocksDBStore.this.configuration.maxBatchSize()) continue;
                    batchSize = 0;
                    this.writeBatch(batch);
                    batch = new WriteBatch();
                }
                if (batchSize != 0) {
                    this.writeBatch(batch);
                }
                for (MarshalledEntry marshalledEntry : marshalledEntries) {
                    InternalMetadata meta = marshalledEntry.getMetadata();
                    if (meta == null || meta.expiryTime() <= -1L) continue;
                    RocksDBStore.this.addNewExpiry(marshalledEntry);
                }
            }
            catch (Exception e) {
                throw new PersistenceException((Throwable)e);
            }
        }

        void deleteBatch(Iterable<Object> keys) {
            try {
                int batchSize = 0;
                WriteBatch batch = new WriteBatch();
                for (Object key : keys) {
                    batch.remove(this.getHandle(this.calculateSegment(key)), RocksDBStore.this.marshall(key));
                    if (++batchSize != RocksDBStore.this.configuration.maxBatchSize()) continue;
                    batchSize = 0;
                    this.writeBatch(batch);
                    batch = new WriteBatch();
                }
                if (batchSize != 0) {
                    this.writeBatch(batch);
                }
            }
            catch (Exception e) {
                throw new PersistenceException((Throwable)e);
            }
        }

        abstract void clear(IntSet var1);

        abstract Publisher<K> publishKeys(IntSet var1, Predicate<? super K> var2);

        abstract Publisher<MarshalledEntry<K, V>> publishEntries(IntSet var1, Predicate<? super K> var2, boolean var3, boolean var4);

        int size(IntSet segments) {
            long count = (Long)Flowable.fromPublisher(this.publishKeys(segments, null)).count().blockingGet();
            if (count > Integer.MAX_VALUE) {
                return Integer.MAX_VALUE;
            }
            return (int)count;
        }

        <P> Flowable<P> publish(int segment, Function<RocksIterator, Flowable<P>> function) {
            return Flowable.using(() -> {
                RocksDBStore.this.semaphore.acquire();
                if (RocksDBStore.this.stopped) {
                    throw new PersistenceException("RocksDB is stopped");
                }
                return this.wrapIterator(RocksDBStore.this.db, segment);
            }, iterator -> {
                if (iterator == null) {
                    return Flowable.empty();
                }
                iterator.seekToFirst();
                return (Publisher)function.apply((RocksIterator)iterator);
            }, iterator -> {
                if (iterator != null) {
                    iterator.close();
                }
                RocksDBStore.this.semaphore.release();
            });
        }

        abstract RocksIterator wrapIterator(RocksDB var1, int var2);

        private void writeBatch(WriteBatch batch) throws InterruptedException, RocksDBException {
            RocksDBStore.this.semaphore.acquire();
            try {
                if (RocksDBStore.this.stopped) {
                    throw new PersistenceException("RocksDB is stopped");
                }
                RocksDBStore.this.db.write(RocksDBStore.this.dataWriteOptions(), batch);
            }
            finally {
                RocksDBStore.this.semaphore.release();
            }
        }

        abstract void addSegments(IntSet var1);

        abstract void removeSegments(IntSet var1);
    }

    private class RocksEntryIterator
    extends AbstractIterator<MarshalledEntry<K, V>> {
        private final RocksIterator it;
        private final Predicate<? super K> filter;
        private final boolean fetchValue;
        private final boolean fetchMetadata;
        private final long now;

        public RocksEntryIterator(RocksIterator it, Predicate<? super K> filter, boolean fetchValue, boolean fetchMetadata, long now) {
            this.it = it;
            this.filter = filter;
            this.fetchValue = fetchValue;
            this.fetchMetadata = fetchMetadata;
            this.now = now;
        }

        protected MarshalledEntry<K, V> getNext() {
            MarshalledEntry entry = null;
            try {
                while (entry == null && this.it.isValid()) {
                    Object key = RocksDBStore.this.unmarshall(this.it.key());
                    if (this.filter == null || this.filter.test(key)) {
                        if (this.fetchValue || this.fetchMetadata) {
                            MarshalledEntry unmarshalledEntry = (MarshalledEntry)RocksDBStore.this.unmarshall(this.it.value());
                            InternalMetadata metadata = unmarshalledEntry.getMetadata();
                            if (metadata == null || !metadata.isExpired(this.now)) {
                                entry = this.fetchMetadata && this.fetchValue ? unmarshalledEntry : RocksDBStore.this.ctx.getMarshalledEntryFactory().newMarshalledEntry(key, this.fetchValue ? unmarshalledEntry.getValue() : null, this.fetchMetadata ? unmarshalledEntry.getMetadata() : null);
                            }
                        } else {
                            entry = RocksDBStore.this.ctx.getMarshalledEntryFactory().newMarshalledEntry(key, null, null);
                        }
                    }
                    this.it.next();
                }
            }
            catch (IOException | ClassNotFoundException e) {
                throw new CacheException((Throwable)e);
            }
            return entry;
        }
    }

    private class RocksKeyIterator
    extends AbstractIterator<K> {
        private final RocksIterator it;
        private final Predicate<? super K> filter;

        public RocksKeyIterator(RocksIterator it, Predicate<? super K> filter) {
            this.it = it;
            this.filter = filter;
        }

        protected K getNext() {
            Object key = null;
            try {
                while (key == null && this.it.isValid()) {
                    Object testKey = RocksDBStore.this.unmarshall(this.it.key());
                    if (this.filter == null || this.filter.test(testKey)) {
                        key = testKey;
                    }
                    this.it.next();
                }
            }
            catch (IOException | ClassNotFoundException e) {
                throw new CacheException((Throwable)e);
            }
            return key;
        }
    }

    private static final class ExpiryEntry {
        private final Long expiry;
        private final Object key;

        private ExpiryEntry(long expiry, Object key) {
            this.expiry = expiry;
            this.key = key;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.key == null ? 0 : this.key.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ExpiryEntry other = (ExpiryEntry)obj;
            return !(this.key == null ? other.key != null : !this.key.equals(other.key));
        }
    }
}

