/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.loader.s3;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashSet;
import java.util.Set;
import org.infinispan.Cache;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.loader.CacheLoaderConfig;
import org.infinispan.loader.CacheLoaderException;
import org.infinispan.loader.bucket.Bucket;
import org.infinispan.loader.bucket.BucketBasedCacheStore;
import org.infinispan.loader.s3.S3Bucket;
import org.infinispan.loader.s3.S3CacheStoreConfig;
import org.infinispan.loader.s3.S3Connection;
import org.infinispan.logging.Log;
import org.infinispan.logging.LogFactory;
import org.infinispan.marshall.Marshaller;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class S3CacheStore
extends BucketBasedCacheStore {
    private static final Log log = LogFactory.getLog(S3CacheStore.class);
    private S3CacheStoreConfig config;
    Cache cache;
    Marshaller marshaller;
    private S3Connection connection;
    private S3Bucket s3Bucket;

    public Class<? extends CacheLoaderConfig> getConfigurationClass() {
        return S3CacheStoreConfig.class;
    }

    public void init(CacheLoaderConfig config, Cache cache, Marshaller m) {
        this.init(config, cache, m, null, null);
    }

    public void stop() throws CacheLoaderException {
        super.stop();
        this.connection.disconnect();
    }

    public void init(CacheLoaderConfig config, Cache cache, Marshaller m, S3Connection connection, S3Bucket bucket) {
        super.init(config, cache, m);
        this.config = (S3CacheStoreConfig)config;
        this.cache = cache;
        this.marshaller = m;
        this.connection = connection;
        this.s3Bucket = bucket;
    }

    public void start() throws CacheLoaderException {
        super.start();
        if (this.config.getAwsAccessKey() == null) {
            throw new IllegalArgumentException("awsAccessKey must be set");
        }
        if (this.config.getAwsSecretKey() == null) {
            throw new IllegalArgumentException("awsSecretKey must be set");
        }
        this.connection.connect(this.config, this.marshaller);
        String s3Bucket = this.config.getBucket();
        if (s3Bucket == null) {
            throw new IllegalArgumentException("s3Bucket must be set");
        }
        this.s3Bucket.init(this.connection, this.connection.verifyOrCreateBucket(s3Bucket));
    }

    protected Set<InternalCacheEntry> loadAllLockSafe() throws CacheLoaderException {
        HashSet<InternalCacheEntry> result = new HashSet<InternalCacheEntry>();
        for (Bucket bucket : this.s3Bucket.values()) {
            if (bucket.removeExpiredEntries()) {
                this.saveBucket(bucket);
            }
            result.addAll(bucket.getStoredEntries());
        }
        return result;
    }

    protected void fromStreamLockSafe(ObjectInput objectInput) throws CacheLoaderException {
        String source;
        try {
            source = (String)objectInput.readObject();
        }
        catch (Exception e) {
            throw this.convertToCacheLoaderException("Error while reading from stream", e);
        }
        if (this.config.getBucket().equals(source)) {
            log.info((Object)"Attempt to load the same s3 bucket ignored");
        } else {
            this.connection.copyBucket(source, this.config.getBucket());
        }
    }

    protected void toStreamLockSafe(ObjectOutput objectOutput) throws CacheLoaderException {
        try {
            objectOutput.writeObject(this.config.getBucket());
        }
        catch (IOException e) {
            throw this.convertToCacheLoaderException("Error while writing to stream", e);
        }
    }

    protected void clearLockSafe() throws CacheLoaderException {
        this.s3Bucket.clear();
    }

    CacheLoaderException convertToCacheLoaderException(String message, Exception caught) {
        return caught instanceof CacheLoaderException ? (CacheLoaderException)caught : new CacheLoaderException(message, (Throwable)caught);
    }

    protected void purgeInternal() throws CacheLoaderException {
        this.loadAll();
    }

    protected Bucket loadBucket(String bucketName) throws CacheLoaderException {
        return this.s3Bucket.get(bucketName);
    }

    protected void insertBucket(Bucket bucket) throws CacheLoaderException {
        this.s3Bucket.insert(bucket);
    }

    protected void saveBucket(Bucket bucket) throws CacheLoaderException {
        this.s3Bucket.insert(bucket);
    }
}

