/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.loader.s3.jclouds;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Future;
import org.infinispan.loader.bucket.Bucket;
import org.infinispan.loader.s3.S3Bucket;
import org.infinispan.loader.s3.S3ConnectionException;
import org.infinispan.loader.s3.jclouds.JCloudsConnection;
import org.jclouds.aws.s3.domain.S3Object;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JCloudsBucket
implements S3Bucket<org.jclouds.aws.s3.domain.S3Bucket, JCloudsConnection> {
    private String name;
    private JCloudsConnection connection;
    protected org.jclouds.aws.s3.domain.S3Bucket rootS3Bucket;

    @Override
    public void init(JCloudsConnection connection, org.jclouds.aws.s3.domain.S3Bucket bucket) {
        this.connection = connection;
        this.rootS3Bucket = bucket;
        this.name = bucket.getName();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Bucket get(String key) throws S3ConnectionException {
        Bucket bucket = null;
        InputStream is = null;
        InputStream ois = null;
        try {
            S3Object s3Object = (S3Object)this.connection.getConnection().getObject(this.rootS3Bucket, key).get();
            if (s3Object != null && s3Object.getContent() != null) {
                is = (InputStream)s3Object.getContent();
                bucket = (Bucket)this.connection.marshaller.objectFromStream(is);
                bucket.setBucketName(key);
            }
        }
        catch (Exception e) {
            throw this.connection.convertToS3ConnectionException("Error while reading from object: " + key, e);
        }
        finally {
            this.safeClose(ois);
            this.safeClose(is);
        }
        return bucket;
    }

    @Override
    public void remove(String key) throws S3ConnectionException {
        try {
            this.connection.getConnection().deleteObject(this.rootS3Bucket, key).get();
        }
        catch (Exception ex) {
            throw this.connection.convertToS3ConnectionException("Exception removing key " + key, ex);
        }
    }

    @Override
    public Set<String> keySet() throws S3ConnectionException {
        return this.connection.keysInBucket(this.rootS3Bucket);
    }

    @Override
    public Set<Bucket> values() throws S3ConnectionException {
        HashSet<Bucket> buckets = new HashSet<Bucket>();
        for (String s : this.keySet()) {
            Bucket bucket = this.get(s);
            if (bucket == null) continue;
            buckets.add(bucket);
        }
        return buckets;
    }

    @Override
    public void clear() throws S3ConnectionException {
        try {
            ArrayList<Future> deletes = new ArrayList<Future>();
            for (String key : this.keySet()) {
                deletes.add(this.connection.getConnection().deleteObject(this.rootS3Bucket, key));
            }
            for (Future delete : deletes) {
                if (((Boolean)delete.get()).booleanValue()) continue;
                throw new S3ConnectionException("could not delete entry");
            }
        }
        catch (Exception ex) {
            throw this.connection.convertToS3ConnectionException("Exception clearing store", ex);
        }
    }

    @Override
    public void insert(Bucket b) throws S3ConnectionException {
        try {
            if (b.getEntries().isEmpty()) {
                if (!((Boolean)this.connection.getConnection().deleteObject(this.rootS3Bucket, b.getBucketName()).get()).booleanValue()) {
                    throw new S3ConnectionException(String.format("Could not delete object [%2s] in s3bucket [%1s] ", this.rootS3Bucket.getName(), b.getBucketName()));
                }
            } else {
                S3Object s3Object = new S3Object();
                s3Object.setKey(b.getBucketName());
                s3Object.setContent((Object)this.connection.marshaller.objectToByteBuffer((Object)b));
                s3Object.setContentType("application/octet-string");
                String id = (String)this.connection.getConnection().addObject(this.rootS3Bucket, s3Object).get();
                assert (id != null) : String.format("Should have received an id for entry %1s:%2s ", this.rootS3Bucket.getName(), b.getBucketName());
            }
        }
        catch (Exception ex) {
            throw this.connection.convertToS3ConnectionException("Exception while saving bucket " + b, ex);
        }
    }

    protected final void safeClose(InputStream stream) throws S3ConnectionException {
        if (stream == null) {
            return;
        }
        try {
            stream.close();
        }
        catch (Exception e) {
            throw new S3ConnectionException("Problems closing input stream", e);
        }
    }
}

