/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.loaders.s3;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashSet;
import java.util.Set;
import org.infinispan.Cache;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.loaders.CacheLoaderConfig;
import org.infinispan.loaders.CacheLoaderException;
import org.infinispan.loaders.bucket.Bucket;
import org.infinispan.loaders.bucket.BucketBasedCacheStore;
import org.infinispan.loaders.s3.S3Bucket;
import org.infinispan.loaders.s3.S3CacheStoreConfig;
import org.infinispan.loaders.s3.S3Connection;
import org.infinispan.loaders.s3.jclouds.JCloudsBucket;
import org.infinispan.loaders.s3.jclouds.JCloudsConnection;
import org.infinispan.marshall.Marshaller;
import org.infinispan.util.Util;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class S3CacheStore
extends BucketBasedCacheStore {
    private static final Log log = LogFactory.getLog(S3CacheStore.class);
    private S3CacheStoreConfig config;
    Cache cache;
    Marshaller marshaller;
    private S3Connection connection;
    private S3Bucket s3Bucket;

    public Class<? extends CacheLoaderConfig> getConfigurationClass() {
        return S3CacheStoreConfig.class;
    }

    public void init(CacheLoaderConfig cfg, Cache cache, Marshaller m) throws CacheLoaderException {
        this.config = (S3CacheStoreConfig)cfg;
        JCloudsBucket cloudsBucket = null;
        JCloudsConnection cloudsConnection = null;
        try {
            cloudsConnection = this.config.getConnectionClass() != null ? (S3Connection)Util.getInstance((String)this.config.getConnectionClass()) : new JCloudsConnection();
            cloudsBucket = this.config.getBucketClass() != null ? (S3Bucket)Util.getInstance((String)this.config.getBucketClass()) : new JCloudsBucket();
        }
        catch (Exception e) {
            throw new CacheLoaderException((Throwable)e);
        }
        this.init(cfg, cache, m, cloudsConnection, cloudsBucket);
    }

    public void stop() throws CacheLoaderException {
        super.stop();
        this.connection.disconnect();
    }

    public void init(CacheLoaderConfig config, Cache cache, Marshaller m, S3Connection connection, S3Bucket bucket) throws CacheLoaderException {
        super.init(config, cache, m);
        this.config = (S3CacheStoreConfig)config;
        this.cache = cache;
        this.marshaller = m;
        this.connection = connection;
        this.s3Bucket = bucket;
    }

    public void start() throws CacheLoaderException {
        super.start();
        if (this.config.getAwsAccessKey() == null) {
            throw new IllegalArgumentException("awsAccessKey must be set");
        }
        if (this.config.getAwsSecretKey() == null) {
            throw new IllegalArgumentException("awsSecretKey must be set");
        }
        this.connection.connect(this.config, this.marshaller);
        if (this.config.getBucketPrefix() == null) {
            throw new IllegalArgumentException("s3Bucket must be set");
        }
        String s3Bucket = this.getThisBucketName();
        this.s3Bucket.init(this.connection, this.connection.verifyOrCreateBucket(s3Bucket));
    }

    private String getThisBucketName() {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Bucket prefix is " + this.config.getBucketPrefix() + " and cache name is " + this.cache.getName()));
        }
        return this.config.getBucketPrefix() + "-" + this.cache.getName().toLowerCase();
    }

    protected Set<InternalCacheEntry> loadAllLockSafe() throws CacheLoaderException {
        HashSet<InternalCacheEntry> result = new HashSet<InternalCacheEntry>();
        for (Bucket bucket : this.s3Bucket.values()) {
            if (bucket.removeExpiredEntries()) {
                this.saveBucket(bucket);
            }
            result.addAll(bucket.getStoredEntries());
        }
        return result;
    }

    protected void fromStreamLockSafe(ObjectInput objectInput) throws CacheLoaderException {
        String source;
        try {
            source = (String)objectInput.readObject();
        }
        catch (Exception e) {
            throw this.convertToCacheLoaderException("Error while reading from stream", e);
        }
        if (this.getThisBucketName().equals(source)) {
            log.info((Object)"Attempt to load the same s3 bucket ignored");
        } else {
            this.connection.copyBucket(source, this.getThisBucketName());
        }
    }

    protected void toStreamLockSafe(ObjectOutput objectOutput) throws CacheLoaderException {
        try {
            objectOutput.writeObject(this.getThisBucketName());
        }
        catch (IOException e) {
            throw this.convertToCacheLoaderException("Error while writing to stream", e);
        }
    }

    protected void clearLockSafe() throws CacheLoaderException {
        this.s3Bucket.clear();
    }

    CacheLoaderException convertToCacheLoaderException(String message, Exception caught) {
        return caught instanceof CacheLoaderException ? (CacheLoaderException)caught : new CacheLoaderException(message, (Throwable)caught);
    }

    protected void purgeInternal() throws CacheLoaderException {
        this.loadAll();
    }

    protected Bucket loadBucket(String bucketName) throws CacheLoaderException {
        return this.s3Bucket.get(bucketName);
    }

    protected void insertBucket(Bucket bucket) throws CacheLoaderException {
        this.s3Bucket.insert(bucket);
    }

    protected void saveBucket(Bucket bucket) throws CacheLoaderException {
        this.s3Bucket.insert(bucket);
    }
}

