/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.sql.configuration;

import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.configuration.attributes.Attribute;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.configuration.cache.AbstractStoreConfiguration;
import org.infinispan.configuration.cache.PersistenceConfigurationBuilder;
import org.infinispan.persistence.jdbc.common.configuration.AbstractJdbcStoreConfigurationBuilder;
import org.infinispan.persistence.sql.configuration.AbstractSchemaJdbcConfiguration;
import org.infinispan.persistence.sql.configuration.SchemaJdbcConfigurationBuilder;
import org.infinispan.util.logging.Log;

public abstract class AbstractSchemaJdbcConfigurationBuilder<T extends AbstractSchemaJdbcConfiguration, S extends AbstractSchemaJdbcConfigurationBuilder<T, S>>
extends AbstractJdbcStoreConfigurationBuilder<T, S> {
    protected final SchemaJdbcConfigurationBuilder<S> schemaBuilder = new SchemaJdbcConfigurationBuilder(this);

    public AbstractSchemaJdbcConfigurationBuilder(PersistenceConfigurationBuilder builder, AttributeSet attributes) {
        super(builder, attributes);
    }

    @Deprecated
    public SchemaJdbcConfigurationBuilder<S> schemaJdbcConfigurationBuilder() {
        return this.schemaBuilder;
    }

    public SchemaJdbcConfigurationBuilder<S> schema() {
        return this.schemaBuilder;
    }

    public void validate() {
        super.validate();
        this.schemaBuilder.validate();
        Attribute segmentedAttr = this.attributes.attribute(AbstractStoreConfiguration.SEGMENTED);
        if (!segmentedAttr.isModified()) {
            org.infinispan.commons.logging.Log.CONFIG.debugf("%s is defaulting to not being segmented", (Object)((Object)((Object)this)).getClass().getSimpleName());
            segmentedAttr.set((Object)Boolean.FALSE);
        } else if (((Boolean)segmentedAttr.get()).booleanValue()) {
            throw Log.CONFIG.storeDoesNotSupportBeingSegmented(((Object)((Object)this)).getClass().getSimpleName());
        }
    }

    public Builder<?> read(T template) {
        super.read(template);
        this.schemaBuilder.read(((AbstractSchemaJdbcConfiguration)((Object)template)).schema());
        return this;
    }
}

