/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.sql.configuration;

import org.infinispan.commons.configuration.io.ConfigurationReader;
import org.infinispan.configuration.cache.AbstractStoreConfigurationBuilder;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.PersistenceConfigurationBuilder;
import org.infinispan.configuration.cache.StoreConfigurationBuilder;
import org.infinispan.configuration.parsing.CacheParser;
import org.infinispan.configuration.parsing.ConfigurationBuilderHolder;
import org.infinispan.configuration.parsing.Namespace;
import org.infinispan.configuration.parsing.Namespaces;
import org.infinispan.configuration.parsing.ParseUtils;
import org.infinispan.persistence.jdbc.common.configuration.AbstractJdbcStoreConfigurationParser;
import org.infinispan.persistence.jdbc.common.configuration.Attribute;
import org.infinispan.persistence.jdbc.common.configuration.Element;
import org.infinispan.persistence.sql.configuration.QueriesJdbcConfigurationBuilder;
import org.infinispan.persistence.sql.configuration.QueriesJdbcStoreConfigurationBuilder;
import org.infinispan.persistence.sql.configuration.SchemaJdbcConfigurationBuilder;
import org.infinispan.persistence.sql.configuration.TableJdbcStoreConfigurationBuilder;

@Namespaces(value={@Namespace(root="table-jdbc-store"), @Namespace(root="query-jdbc-store"), @Namespace(uri="urn:infinispan:config:store:sql:*", root="table-jdbc-store"), @Namespace(uri="urn:infinispan:config:store:sql:*", root="query-jdbc-store")})
public class SqlStoreConfigurationParser
extends AbstractJdbcStoreConfigurationParser {
    static final String NAMESPACE = "urn:infinispan:config:store:sql:";

    public void readElement(ConfigurationReader reader, ConfigurationBuilderHolder holder) {
        ConfigurationBuilder builder = holder.getCurrentConfigurationBuilder();
        Element element = Element.forName((String)reader.getLocalName());
        switch (element) {
            case TABLE_JDBC_STORE: {
                this.parseTableJdbcStore(reader, builder.persistence());
                break;
            }
            case QUERY_JDBC_STORE: {
                this.parseQueryJdbcStore(reader, builder.persistence());
                break;
            }
            default: {
                throw ParseUtils.unexpectedElement((ConfigurationReader)reader);
            }
        }
    }

    private void parseTableJdbcStore(ConfigurationReader reader, PersistenceConfigurationBuilder persistenceBuilder) {
        TableJdbcStoreConfigurationBuilder builder = (TableJdbcStoreConfigurationBuilder)persistenceBuilder.addStore(TableJdbcStoreConfigurationBuilder.class);
        for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName((String)reader.getAttributeName(i));
            if (this.handleCommonAttributes(reader, builder, attribute, value)) continue;
            if (attribute == Attribute.TABLE_NAME) {
                builder.tableName(value);
                continue;
            }
            CacheParser.parseStoreAttribute((ConfigurationReader)reader, (int)i, (AbstractStoreConfigurationBuilder)builder);
        }
        while (reader.inTag()) {
            Element element = Element.forName((String)reader.getLocalName());
            if (this.handleCommonElement(builder, element, reader)) continue;
            if (element == Element.SCHEMA) {
                this.parseSchema(reader, builder.schema());
                continue;
            }
            CacheParser.parseStoreElement((ConfigurationReader)reader, (StoreConfigurationBuilder)builder);
        }
    }

    private void parseQueryJdbcStore(ConfigurationReader reader, PersistenceConfigurationBuilder persistenceBuilder) {
        QueriesJdbcStoreConfigurationBuilder builder = (QueriesJdbcStoreConfigurationBuilder)persistenceBuilder.addStore(QueriesJdbcStoreConfigurationBuilder.class);
        for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName((String)reader.getAttributeName(i));
            if (this.handleCommonAttributes(reader, builder, attribute, value)) continue;
            if (attribute == Attribute.KEY_COLUMNS) {
                builder.keyColumns(value);
                continue;
            }
            CacheParser.parseStoreAttribute((ConfigurationReader)reader, (int)i, (AbstractStoreConfigurationBuilder)builder);
        }
        block5: while (reader.inTag()) {
            Element element = Element.forName((String)reader.getLocalName());
            if (this.handleCommonElement(builder, element, reader)) continue;
            switch (element) {
                case QUERIES: {
                    this.parseQueries(reader, builder.queries());
                    continue block5;
                }
                case SCHEMA: {
                    this.parseSchema(reader, builder.schema());
                    continue block5;
                }
            }
            CacheParser.parseStoreElement((ConfigurationReader)reader, (StoreConfigurationBuilder)builder);
        }
    }

    private void parseQueries(ConfigurationReader reader, QueriesJdbcConfigurationBuilder builder) {
        block8: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName((String)reader.getAttributeName(i));
            switch (attribute) {
                case SELECT_ALL: {
                    builder.selectAll(value);
                    continue block8;
                }
                case SELECT_SINGLE: {
                    builder.select(value);
                    continue block8;
                }
                case DELETE_ALL: {
                    builder.deleteAll(value);
                    continue block8;
                }
                case DELETE_SINGLE: {
                    builder.delete(value);
                    continue block8;
                }
                case UPSERT: {
                    builder.upsert(value);
                    continue block8;
                }
                case SIZE: {
                    builder.size(value);
                    continue block8;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((ConfigurationReader)reader, (int)i);
                }
            }
        }
        if (reader.inTag()) {
            Element element = Element.forName((String)reader.getLocalName());
            throw ParseUtils.unexpectedElement((ConfigurationReader)reader, (Enum)element);
        }
    }

    private void parseSchema(ConfigurationReader reader, SchemaJdbcConfigurationBuilder<?> builder) {
        block6: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName((String)reader.getAttributeName(i));
            switch (attribute) {
                case KEY_MESSAGE_NAME: {
                    builder.keyMessageName(value);
                    continue block6;
                }
                case MESSAGE_NAME: {
                    builder.messageName(value);
                    continue block6;
                }
                case EMBEDDED_KEY: {
                    builder.embeddedKey(Boolean.parseBoolean(value));
                    continue block6;
                }
                case PACKAGE: {
                    builder.packageName(value);
                }
            }
        }
        if (reader.inTag()) {
            Element element = Element.forName((String)reader.getLocalName());
            throw ParseUtils.unexpectedElement((ConfigurationReader)reader, (Enum)element);
        }
    }

    public Namespace[] getNamespaces() {
        return ParseUtils.getNamespaceAnnotations(((Object)((Object)this)).getClass());
    }
}

