/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.sql.configuration;

import java.util.Objects;
import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.persistence.jdbc.common.configuration.AbstractJdbcStoreConfigurationBuilder;
import org.infinispan.persistence.jdbc.common.configuration.AbstractJdbcStoreConfigurationChildBuilder;
import org.infinispan.persistence.jdbc.common.logging.Log;
import org.infinispan.persistence.sql.configuration.SchemaJdbcConfiguration;

public class SchemaJdbcConfigurationBuilder<S extends AbstractJdbcStoreConfigurationBuilder<?, S>>
extends AbstractJdbcStoreConfigurationChildBuilder<S>
implements Builder<SchemaJdbcConfiguration> {
    private final AttributeSet attributes = SchemaJdbcConfiguration.attributeDefinitionSet();

    protected SchemaJdbcConfigurationBuilder(AbstractJdbcStoreConfigurationBuilder<?, S> builder) {
        super(builder);
    }

    public AttributeSet attributes() {
        return this.attributes;
    }

    public SchemaJdbcConfigurationBuilder<S> messageName(String messageName) {
        this.attributes.attribute(SchemaJdbcConfiguration.MESSAGE_NAME).set((Object)messageName);
        return this;
    }

    public SchemaJdbcConfigurationBuilder<S> keyMessageName(String keyMessageName) {
        this.attributes.attribute(SchemaJdbcConfiguration.KEY_MESSAGE_NAME).set((Object)keyMessageName);
        return this;
    }

    public SchemaJdbcConfigurationBuilder<S> packageName(String packageName) {
        this.attributes.attribute(SchemaJdbcConfiguration.PACKAGE).set((Object)Objects.requireNonNull(packageName));
        return this;
    }

    public SchemaJdbcConfigurationBuilder<S> embeddedKey(boolean embeddedKey) {
        this.attributes.attribute(SchemaJdbcConfiguration.EMBEDDED_KEY).set((Object)embeddedKey);
        return this;
    }

    public void validate() {
        Boolean embedKey = (Boolean)this.attributes.attribute(SchemaJdbcConfiguration.EMBEDDED_KEY).get();
        if (embedKey != null && embedKey.booleanValue() && this.attributes.attribute(SchemaJdbcConfiguration.MESSAGE_NAME).get() == null) {
            throw Log.CONFIG.messageNameRequiredIfEmbeddedKey();
        }
    }

    public SchemaJdbcConfiguration create() {
        return new SchemaJdbcConfiguration(this.attributes.protect());
    }

    public Builder<?> read(SchemaJdbcConfiguration template) {
        this.attributes.read(template.attributes());
        return this;
    }
}

