/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cdi.common.util;

import jakarta.enterprise.context.spi.CreationalContext;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.BeanManager;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;

public class ContextualReference<T> {
    private final Bean<T> bean;
    private T instance;
    private boolean disposed = false;

    public ContextualReference(BeanManager beanManager, Type beantype, Annotation ... qualifiers) {
        this.bean = beanManager.resolve(beanManager.getBeans(beantype, qualifiers));
    }

    public T get() {
        return this.instance;
    }

    public ContextualReference<T> create(CreationalContext<T> ctx) {
        if (this.instance != null) {
            throw new IllegalStateException("Trying to call create() on already constructed instance");
        }
        if (this.disposed) {
            throw new IllegalStateException("Trying to call create() on an already disposed instance");
        }
        this.instance = this.bean.create(ctx);
        return this;
    }

    public ContextualReference<T> destroy(CreationalContext<T> ctx) {
        if (this.instance == null) {
            throw new IllegalStateException("Trying to call destroy() before create() was called");
        }
        if (this.disposed) {
            throw new IllegalStateException("Trying to call destroy() on already disposed instance");
        }
        this.disposed = true;
        this.bean.destroy(this.instance, ctx);
        return this;
    }
}

