/*
 * Decompiled with CFR 0.152.
 */
package javax.cache;

import java.util.concurrent.TimeUnit;
import javax.cache.Cache;
import javax.cache.CacheBuilder;
import javax.cache.CacheConfiguration;
import javax.cache.CacheLoader;
import javax.cache.CacheWriter;
import javax.cache.Caching;
import javax.cache.InvalidConfigurationException;
import javax.cache.OptionalFeature;
import javax.cache.transaction.IsolationLevel;
import javax.cache.transaction.Mode;
import javax.cache.util.ExcludeListExcluder;
import org.junit.After;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;

public class CacheBuilderTest {
    protected static final String CACHE_NAME = "testCache";
    @Rule
    public ExcludeListExcluder rule = new ExcludeListExcluder(this.getClass());

    @After
    public void cleanup() {
        Caching.getCacheManager().removeCache(CACHE_NAME);
    }

    @Test
    public void setCacheLoader_Null() {
        CacheBuilder builder = this.getCacheBuilder();
        CacheLoader cl = null;
        try {
            builder.setCacheLoader(cl);
            Assert.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void setReadThrough_NoCacheLoader() {
        CacheBuilder builder = this.getCacheBuilder();
        builder.setReadThrough(true);
        try {
            builder.build();
            Assert.fail();
        }
        catch (InvalidConfigurationException invalidConfigurationException) {
            // empty catch block
        }
    }

    @Test
    public void setCacheWriter_Null() {
        CacheBuilder builder = this.getCacheBuilder();
        CacheWriter cw = null;
        try {
            builder.setCacheWriter(cw);
            Assert.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void setWriteThrough_NoCacheWriter() {
        CacheBuilder builder = this.getCacheBuilder();
        builder.setWriteThrough(true);
        try {
            builder.build();
            Assert.fail();
        }
        catch (InvalidConfigurationException invalidConfigurationException) {
            // empty catch block
        }
    }

    @Test
    public void testValidCacheNames() {
        try {
            Caching.getCacheManager().createCacheBuilder(null).build();
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            Caching.getCacheManager().createCacheBuilder("").build();
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            Caching.getCacheManager().createCacheBuilder(" ").build();
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            Caching.getCacheManager().createCacheBuilder("    ").build();
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            Caching.getCacheManager().createCacheBuilder("\t\u000b\f\u001d\u001e\u001f").build();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        Caching.getCacheManager().createCacheBuilder("Greg Luck's Cache").build();
        Caching.getCacheManager().createCacheBuilder("G").build();
        Caching.getCacheManager().createCacheBuilder(" G ").build();
    }

    @Test
    public void setTransactionEnabled() {
        CacheBuilder builder = this.getCacheBuilder();
        IsolationLevel isolationLevel = null;
        Mode mode = null;
        if (this.isSupported(OptionalFeature.TRANSACTIONS)) {
            Cache cache = builder.setTransactionEnabled(isolationLevel, mode).build();
            Assert.assertTrue((boolean)cache.getConfiguration().isTransactionEnabled());
        } else {
            try {
                builder.setTransactionEnabled(isolationLevel, mode);
                Assert.fail((String)"expected InvalidConfigurationException");
            }
            catch (InvalidConfigurationException e) {
                // empty catch block
            }
        }
    }

    @Test
    public void setStoreByValue_false() {
        CacheBuilder builder = this.getCacheBuilder();
        if (this.isSupported(OptionalFeature.STORE_BY_REFERENCE)) {
            Cache cache = builder.setStoreByValue(false).build();
            Assert.assertFalse((boolean)cache.getConfiguration().isStoreByValue());
        } else {
            try {
                builder.setStoreByValue(false);
                Assert.fail();
            }
            catch (InvalidConfigurationException invalidConfigurationException) {
                // empty catch block
            }
        }
    }

    @Test
    public void setExpiry_null_good() {
        CacheBuilder builder = this.getCacheBuilder();
        try {
            builder.setExpiry(null, CacheConfiguration.Duration.ETERNAL);
            Assert.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void setExpiry_good_null() {
        CacheBuilder builder = this.getCacheBuilder();
        try {
            builder.setExpiry(CacheConfiguration.ExpiryType.MODIFIED, null);
            Assert.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void getExpiry_default() {
        CacheBuilder builder = this.getCacheBuilder();
        CacheConfiguration configuration = builder.build().getConfiguration();
        for (CacheConfiguration.ExpiryType type : CacheConfiguration.ExpiryType.values()) {
            Assert.assertEquals((Object)CacheConfiguration.Duration.ETERNAL, (Object)configuration.getExpiry(type));
        }
    }

    @Test
    public void setExpiry_accessed() {
        CacheBuilder builder = this.getCacheBuilder();
        CacheConfiguration.ExpiryType type = CacheConfiguration.ExpiryType.ACCESSED;
        CacheConfiguration.Duration duration = new CacheConfiguration.Duration(TimeUnit.MINUTES, 4L);
        builder.setExpiry(type, duration);
        CacheConfiguration configuration = builder.build().getConfiguration();
        Assert.assertEquals((Object)duration, (Object)configuration.getExpiry(type));
        Assert.assertEquals((Object)CacheConfiguration.Duration.ETERNAL, (Object)configuration.getExpiry(CacheConfiguration.ExpiryType.MODIFIED));
    }

    @Test
    public void setExpiry_modified() {
        CacheBuilder builder = this.getCacheBuilder();
        CacheConfiguration.ExpiryType type = CacheConfiguration.ExpiryType.MODIFIED;
        CacheConfiguration.Duration duration = new CacheConfiguration.Duration(TimeUnit.HOURS, 4L);
        builder.setExpiry(type, duration);
        CacheConfiguration configuration = builder.build().getConfiguration();
        Assert.assertEquals((Object)duration, (Object)configuration.getExpiry(type));
        Assert.assertEquals((Object)CacheConfiguration.Duration.ETERNAL, (Object)configuration.getExpiry(CacheConfiguration.ExpiryType.ACCESSED));
    }

    @Test
    public void setExpiry_both() {
        CacheBuilder builder = this.getCacheBuilder();
        CacheConfiguration.Duration[] durations = new CacheConfiguration.Duration[CacheConfiguration.ExpiryType.values().length];
        for (CacheConfiguration.ExpiryType type : CacheConfiguration.ExpiryType.values()) {
            CacheConfiguration.Duration duration = new CacheConfiguration.Duration(TimeUnit.DAYS, 4L + (long)type.ordinal());
            builder.setExpiry(type, duration);
            durations[type.ordinal()] = duration;
        }
        CacheConfiguration configuration = builder.build().getConfiguration();
        for (CacheConfiguration.ExpiryType type : CacheConfiguration.ExpiryType.values()) {
            Assert.assertEquals((Object)durations[type.ordinal()], (Object)configuration.getExpiry(type));
        }
    }

    protected <K, V> CacheBuilder<K, V> getCacheBuilder() {
        return Caching.getCacheManager().createCacheBuilder(CACHE_NAME);
    }

    protected boolean isSupported(OptionalFeature feature) {
        return Caching.isSupported((OptionalFeature)feature);
    }
}

