/*
 * Decompiled with CFR 0.152.
 */
package javax.cache;

import java.util.Date;
import java.util.LinkedHashMap;
import javax.cache.Cache;
import javax.cache.CacheBuilder;
import javax.cache.TestSupport;
import org.junit.After;
import org.junit.Before;

public abstract class CacheTestSupport<K, V>
extends TestSupport {
    protected Cache<K, V> cache;

    @Before
    public void setUp() {
        this.cache = this.extraSetup(this.getCacheManager().createCacheBuilder(this.getTestCacheName())).build();
    }

    @After
    public void teardown() {
        this.getCacheManager().removeCache(this.getTestCacheName());
    }

    protected <A, B> CacheBuilder<A, B> extraSetup(CacheBuilder<A, B> builder) {
        return builder;
    }

    private LinkedHashMap<Long, String> createLSData(int count, long now) {
        LinkedHashMap<Long, String> map = new LinkedHashMap<Long, String>(count);
        for (int i = 0; i < count; ++i) {
            Long key = now + (long)i;
            map.put(key, "value" + key);
        }
        return map;
    }

    private LinkedHashMap<Date, Date> createDDData(int count, long now) {
        LinkedHashMap<Date, Date> map = new LinkedHashMap<Date, Date>(count);
        for (int i = 0; i < count; ++i) {
            map.put(new Date(now + (long)i), new Date(now + 1000L + (long)i));
        }
        return map;
    }

    protected LinkedHashMap<Date, Date> createDDData(int count) {
        return this.createDDData(count, System.currentTimeMillis());
    }

    protected LinkedHashMap<Long, String> createLSData(int count) {
        return this.createLSData(count, System.currentTimeMillis());
    }
}

