/*
 * Decompiled with CFR 0.152.
 */
package javax.cache;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import javax.cache.Cache;
import javax.cache.CacheManager;
import javax.cache.Caching;
import javax.cache.util.ExcludeListExcluder;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class CachingClassLoaderTest {
    @Rule
    public ExcludeListExcluder rule = new ExcludeListExcluder(this.getClass());

    @Before
    public void startUp() {
        CachingClassLoaderTest.shutdown();
    }

    @Test
    public void getCacheManager_singleton() {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        CacheManager defaultCacheManager = CachingClassLoaderTest.getCacheManager(cl);
        Assert.assertNotNull((Object)defaultCacheManager);
        Assert.assertSame((Object)defaultCacheManager, (Object)CachingClassLoaderTest.getCacheManager(cl));
        MyClassLoader cl1 = new MyClassLoader(cl);
        CacheManager defaultCacheManager1 = CachingClassLoaderTest.getCacheManager(cl1);
        Assert.assertNotSame((Object)defaultCacheManager, (Object)defaultCacheManager1);
        Assert.assertSame((Object)defaultCacheManager1, (Object)CachingClassLoaderTest.getCacheManager(cl1));
    }

    @Test
    public void getCacheManager_name() {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        CacheManager defaultCacheManager = CachingClassLoaderTest.getCacheManager(cl);
        Assert.assertSame((Object)"__default__", (Object)defaultCacheManager.getName());
    }

    @Test
    public void getCacheManager_named_default() {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        String name = "__default__";
        Assert.assertSame((Object)CachingClassLoaderTest.getCacheManager(cl), (Object)CachingClassLoaderTest.getCacheManager(cl, name));
        MyClassLoader cl1 = new MyClassLoader(cl);
        Assert.assertSame((Object)CachingClassLoaderTest.getCacheManager(cl1), (Object)CachingClassLoaderTest.getCacheManager(cl1, name));
        Assert.assertNotSame((Object)CachingClassLoaderTest.getCacheManager(cl), (Object)CachingClassLoaderTest.getCacheManager(cl1, name));
    }

    @Test
    public void getCacheManager_named() {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        String name = "__default__1";
        CacheManager cacheManager = CachingClassLoaderTest.getCacheManager(cl, name);
        Assert.assertNotNull((Object)cacheManager);
        Assert.assertSame((Object)cacheManager, (Object)CachingClassLoaderTest.getCacheManager(cl, name));
        MyClassLoader cl1 = new MyClassLoader(cl);
        CacheManager cacheManager1 = CachingClassLoaderTest.getCacheManager(cl1, name);
        Assert.assertSame((Object)cacheManager1, (Object)CachingClassLoaderTest.getCacheManager(cl1, name));
        Assert.assertNotSame((Object)cacheManager, (Object)cacheManager1);
    }

    @Test
    public void getCacheManager_named_name() {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        String name = "__default__1";
        Assert.assertEquals((Object)name, (Object)CachingClassLoaderTest.getCacheManager(cl, name).getName());
    }

    @Test
    public void getCacheManager_named_notDefault() {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        String name = "__default__1";
        Assert.assertNotSame((Object)CachingClassLoaderTest.getCacheManager(cl), (Object)CachingClassLoaderTest.getCacheManager(cl, name));
    }

    @Test
    public void getCacheManager_named_different() {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        String name1 = "__default__1";
        String name2 = "__default__2";
        Assert.assertNotSame((Object)CachingClassLoaderTest.getCacheManager(cl, name1), (Object)CachingClassLoaderTest.getCacheManager(cl, name2));
    }

    @Test
    public void shutdown_0_Empty() {
        CachingClassLoaderTest.shutdown();
    }

    @Test
    public void shutdown_0_Full() {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        String name = this.toString();
        MyClassLoader cl1 = new MyClassLoader(cl);
        MyClassLoader cl2 = new MyClassLoader(cl);
        MyClassLoader cl3 = new MyClassLoader(cl);
        CacheManager cacheManager1 = CachingClassLoaderTest.getCacheManager(cl1);
        CacheManager cacheManager2 = CachingClassLoaderTest.getCacheManager(cl2);
        CacheManager cacheManager3 = CachingClassLoaderTest.getCacheManager(cl3, name);
        CachingClassLoaderTest.shutdown();
        Assert.assertNotSame((Object)cacheManager1, (Object)CachingClassLoaderTest.getCacheManager(cl1));
        Assert.assertNotSame((Object)cacheManager2, (Object)CachingClassLoaderTest.getCacheManager(cl2));
        Assert.assertNotSame((Object)cacheManager3, (Object)CachingClassLoaderTest.getCacheManager(cl3, name));
    }

    @Test
    public void shutdown_1_hit() {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        String name = this.toString();
        MyClassLoader cl1 = new MyClassLoader(cl);
        MyClassLoader cl2 = new MyClassLoader(cl);
        MyClassLoader cl3 = new MyClassLoader(cl);
        CacheManager cacheManager1 = CachingClassLoaderTest.getCacheManager(cl1);
        CacheManager cacheManager2 = CachingClassLoaderTest.getCacheManager(cl2);
        CacheManager cacheManager3 = CachingClassLoaderTest.getCacheManager(cl3, name);
        Assert.assertTrue((boolean)CachingClassLoaderTest.shutdown(cl2));
        Assert.assertSame((Object)cacheManager1, (Object)CachingClassLoaderTest.getCacheManager(cl1));
        Assert.assertNotSame((Object)cacheManager2, (Object)CachingClassLoaderTest.getCacheManager(cl2));
        Assert.assertSame((Object)cacheManager3, (Object)CachingClassLoaderTest.getCacheManager(cl3, name));
    }

    @Test
    public void shutdown_1_miss() {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        String name = this.toString();
        MyClassLoader cl1 = new MyClassLoader(cl);
        MyClassLoader cl2 = new MyClassLoader(cl);
        MyClassLoader cl3 = new MyClassLoader(cl);
        CacheManager cacheManager1 = CachingClassLoaderTest.getCacheManager(cl1);
        CacheManager cacheManager2 = CachingClassLoaderTest.getCacheManager(cl2);
        CacheManager cacheManager3 = CachingClassLoaderTest.getCacheManager(cl3, name);
        Assert.assertFalse((boolean)CachingClassLoaderTest.shutdown(new MyClassLoader(cl)));
        Assert.assertSame((Object)cacheManager1, (Object)CachingClassLoaderTest.getCacheManager(cl1));
        Assert.assertSame((Object)cacheManager2, (Object)CachingClassLoaderTest.getCacheManager(cl2));
        Assert.assertSame((Object)cacheManager3, (Object)CachingClassLoaderTest.getCacheManager(cl3, name));
    }

    @Test
    public void shutdown_2_hit() {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        String name = this.toString();
        MyClassLoader cl1 = new MyClassLoader(cl);
        MyClassLoader cl2 = new MyClassLoader(cl);
        MyClassLoader cl3 = new MyClassLoader(cl);
        CacheManager cacheManager1 = CachingClassLoaderTest.getCacheManager(cl1);
        CacheManager cacheManager2 = CachingClassLoaderTest.getCacheManager(cl2);
        CacheManager cacheManager3 = CachingClassLoaderTest.getCacheManager(cl3, name);
        Assert.assertTrue((boolean)CachingClassLoaderTest.shutdown(cl3, name));
        Assert.assertSame((Object)cacheManager1, (Object)CachingClassLoaderTest.getCacheManager(cl1));
        Assert.assertSame((Object)cacheManager2, (Object)CachingClassLoaderTest.getCacheManager(cl2));
        Assert.assertNotSame((Object)cacheManager3, (Object)CachingClassLoaderTest.getCacheManager(cl3, name));
    }

    @Test
    public void shutdown_2_miss() {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        String name = this.toString();
        MyClassLoader cl1 = new MyClassLoader(cl);
        MyClassLoader cl2 = new MyClassLoader(cl);
        MyClassLoader cl3 = new MyClassLoader(cl);
        CacheManager cacheManager1 = CachingClassLoaderTest.getCacheManager(cl1);
        CacheManager cacheManager2 = CachingClassLoaderTest.getCacheManager(cl2);
        CacheManager cacheManager3 = CachingClassLoaderTest.getCacheManager(cl3, name);
        Assert.assertFalse((boolean)CachingClassLoaderTest.shutdown(cl3, name + "a"));
        Assert.assertSame((Object)cacheManager1, (Object)CachingClassLoaderTest.getCacheManager(cl1));
        Assert.assertSame((Object)cacheManager2, (Object)CachingClassLoaderTest.getCacheManager(cl2));
        Assert.assertSame((Object)cacheManager3, (Object)CachingClassLoaderTest.getCacheManager(cl3, name));
    }

    @Test
    public void classLoader() throws Exception {
        AppDomainHandler domainHandler1 = new AppDomainHandler();
        Class class1 = domainHandler1.getClassForDomainClass();
        Object storedInstance = class1.newInstance();
        Cache<Integer, Object> cache1 = domainHandler1.getCache();
        cache1.put((Object)1, storedInstance);
        Object o1_1 = cache1.get((Object)1);
        Assert.assertSame(storedInstance.getClass(), o1_1.getClass());
        Assert.assertSame((Object)class1, o1_1.getClass());
        AppDomainHandler domainHandler2 = new AppDomainHandler();
        Class class2 = domainHandler2.getClassForDomainClass();
        Cache<Integer, Object> cache2 = domainHandler2.getCache();
        cache2.put((Object)1, storedInstance);
        Object o2_1 = cache2.get((Object)1);
        Assert.assertNotSame(storedInstance.getClass(), o2_1.getClass());
        Assert.assertSame((Object)class2, o2_1.getClass());
    }

    private static CacheManager getCacheManager(ClassLoader classLoader) {
        return Caching.getCacheManager((ClassLoader)classLoader);
    }

    private static CacheManager getCacheManager(ClassLoader classLoader, String name) {
        return Caching.getCacheManager((ClassLoader)classLoader, (String)name);
    }

    private static void shutdown() {
        Caching.close();
    }

    private static boolean shutdown(ClassLoader classLoader) {
        return Caching.close((ClassLoader)classLoader);
    }

    private static boolean shutdown(ClassLoader classLoader, String name) {
        return Caching.close((ClassLoader)classLoader, (String)name);
    }

    private static class MyClassLoader
    extends ClassLoader {
        public MyClassLoader(ClassLoader parent) {
            super(parent);
        }
    }

    private static class AppDomainHandler {
        private static String TEST_CLASS_NAME = "domain.Zoo";
        private static final String DOMAINJAR = "domainJar";
        private static final String DEFAULT_DOMAINJAR = "jsr107tck/implementation-tester/target/domainlib/domain.jar";
        private final ClassLoader classLoader = this.createClassLoader();
        private final Cache<Integer, Object> cache = this.createCache();

        private ClassLoader createClassLoader() throws MalformedURLException {
            String domainJar = System.getProperty(DOMAINJAR, DEFAULT_DOMAINJAR);
            URL[] urls = new URL[]{new File(domainJar).toURI().toURL()};
            ClassLoader parent = Thread.currentThread().getContextClassLoader();
            return new URLClassLoader(urls, parent);
        }

        private Cache<Integer, Object> createCache() {
            return Caching.getCacheManager((ClassLoader)this.classLoader).createCacheBuilder("c1").build();
        }

        public Class getClassForDomainClass() throws ClassNotFoundException {
            return Class.forName(TEST_CLASS_NAME, false, this.classLoader);
        }

        public Cache<Integer, Object> getCache() {
            return this.cache;
        }
    }
}

