/*
 * Decompiled with CFR 0.152.
 */
package javax.cache;

import java.util.logging.Logger;
import javax.cache.CacheManager;
import javax.cache.Caching;
import javax.cache.OptionalFeature;
import javax.cache.util.ExcludeListExcluder;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;

public class CachingTest {
    @Rule
    public ExcludeListExcluder rule = new ExcludeListExcluder(this.getClass());

    @Test
    public void getCacheManager_singleton() {
        CacheManager defaultCacheManager = CachingTest.getCacheManager();
        Assert.assertNotNull((Object)defaultCacheManager);
        Assert.assertSame((Object)defaultCacheManager, (Object)CachingTest.getCacheManager());
    }

    @Test
    public void getCacheManager_name() {
        CacheManager defaultCacheManager = CachingTest.getCacheManager();
        Assert.assertSame((Object)"__default__", (Object)defaultCacheManager.getName());
    }

    @Test
    public void getCacheManager_named_default() {
        String name = "__default__";
        Assert.assertSame((Object)CachingTest.getCacheManager(), (Object)CachingTest.getCacheManager(name));
    }

    @Test
    public void getCacheManager_named() {
        String name = "__default__1";
        CacheManager cacheManager = CachingTest.getCacheManager(name);
        Assert.assertNotNull((Object)cacheManager);
        Assert.assertSame((Object)cacheManager, (Object)CachingTest.getCacheManager(name));
    }

    @Test
    public void getCacheManager_named_name() {
        String name = "__default__1";
        Assert.assertEquals((Object)name, (Object)CachingTest.getCacheManager(name).getName());
    }

    @Test
    public void getCacheManager_named_notDefault() {
        String name = "__default__1";
        Assert.assertNotSame((Object)CachingTest.getCacheManager(), (Object)CachingTest.getCacheManager(name));
    }

    @Test
    public void getCacheManager_named_different() {
        String name1 = "__default__1";
        String name2 = "__default__2";
        Assert.assertNotSame((Object)CachingTest.getCacheManager(name1), (Object)CachingTest.getCacheManager(name2));
    }

    @Test
    public void isSupported() {
        OptionalFeature[] features;
        for (OptionalFeature feature : features = OptionalFeature.values()) {
            boolean value = CachingTest.isSupported(feature);
            Logger.getLogger(this.getClass().getName()).info("Optional feature " + feature + " supported=" + value);
        }
    }

    @Test
    public void release() {
        CacheManager cacheManager = CachingTest.getCacheManager();
        Assert.assertSame((Object)cacheManager, (Object)CachingTest.getCacheManager());
        CachingTest.shutdown();
        Assert.assertNotSame((Object)cacheManager, (Object)CachingTest.getCacheManager());
    }

    @Test
    public void dummyTest() {
        Assert.fail();
    }

    private static CacheManager getCacheManager() {
        return Caching.getCacheManager();
    }

    private static CacheManager getCacheManager(String name) {
        return Caching.getCacheManager((String)name);
    }

    private static void shutdown() {
        Caching.close();
    }

    private static boolean isSupported(OptionalFeature optionalFeature) {
        return Caching.isSupported((OptionalFeature)optionalFeature);
    }
}

