/*
 * Decompiled with CFR 0.152.
 */
package javax.cache;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;
import javax.cache.CacheManager;
import javax.cache.Caching;

public class TestSupport {
    protected static final Logger LOG = Logger.getLogger(TestSupport.class.getName());
    private final Map<Class<?>, Class<?>> unwrapClasses = Collections.synchronizedMap(new HashMap());
    private Properties unwrapProperties;

    protected CacheManager getCacheManager() {
        return Caching.getCacheManager((String)this.getTestCacheManagerName());
    }

    protected String getTestCacheManagerName() {
        return this.getClass().getName();
    }

    protected String getTestCacheName() {
        return this.getClass().getName();
    }

    protected Class<?> getUnwrapClass(Class<?> unwrappableClass) {
        if (this.unwrapClasses.containsKey(unwrappableClass)) {
            return this.unwrapClasses.get(unwrappableClass);
        }
        Properties unwrapProperties = this.getUnwrapProperties();
        String unwrapClassName = unwrapProperties.getProperty(unwrappableClass.getName());
        if (unwrapClassName == null || unwrapClassName.trim().length() == 0) {
            this.unwrapClasses.put(unwrappableClass, null);
            return null;
        }
        try {
            Class<?> unwrapClass = Class.forName(unwrapClassName);
            this.unwrapClasses.put(unwrappableClass, unwrapClass);
            return unwrapClass;
        }
        catch (ClassNotFoundException e) {
            LOG.warning("Failed to load unwrap class " + unwrapClassName + " for unwrappable class: " + unwrappableClass);
            this.unwrapClasses.put(unwrappableClass, null);
            return null;
        }
    }

    private Properties getUnwrapProperties() {
        if (this.unwrapProperties != null) {
            return this.unwrapProperties;
        }
        Properties unwrapProperties = new Properties();
        try {
            unwrapProperties.load(this.getClass().getResourceAsStream("/unwrap.properties"));
        }
        catch (IOException e) {
            LOG.warning("Failed to load unwrap.properties from classpath");
        }
        this.unwrapProperties = unwrapProperties;
        return unwrapProperties;
    }
}

