/*
 * Decompiled with CFR 0.152.
 */
package javax.cache.statistics;

import java.lang.management.ManagementFactory;
import java.util.logging.Logger;
import javax.cache.Cache;
import javax.cache.CacheManager;
import javax.cache.Caching;
import javax.cache.statistics.MBeanServerRegistrationUtility;
import javax.cache.util.ExcludeListExcluder;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class JMXTest {
    private static final Logger LOG = Logger.getLogger(JMXTest.class.getName());
    private MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
    private CacheManager cacheManager;
    private MBeanServerRegistrationUtility mBeanServerRegistrationUtility;
    private Cache<Integer, String> cache1;
    private Cache<Integer, String> cache2;
    @Rule
    public ExcludeListExcluder rule = new ExcludeListExcluder(this.getClass());

    @Before
    public void setUp() throws Exception {
        this.cacheManager = Caching.getCacheManager((String)this.getClass().getName());
    }

    @After
    public void tearDown() throws MalformedObjectNameException {
        this.mBeanServerRegistrationUtility.dispose();
        this.cacheManager.shutdown();
    }

    @Test
    public void testCacheStatisticsWhereStatisticsTurnedOn() throws Exception {
        this.cacheManager.createCacheBuilder("cache1").setStatisticsEnabled(true).build();
        this.cacheManager.createCacheBuilder("cache2").setStatisticsEnabled(true).build();
        this.mBeanServerRegistrationUtility = new MBeanServerRegistrationUtility(this.cacheManager, this.mBeanServer);
        Assert.assertTrue((this.mBeanServer.queryNames(new ObjectName("javax.cache:*"), null).size() >= 2 ? 1 : 0) != 0);
    }
}

