/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cdi.interceptor;

import java.lang.reflect.Method;
import javax.cache.interceptor.CacheRemoveAll;
import javax.inject.Inject;
import javax.interceptor.AroundInvoke;
import javax.interceptor.Interceptor;
import javax.interceptor.InvocationContext;
import org.infinispan.Cache;
import org.infinispan.cdi.interceptor.CacheResolver;

@Interceptor
public class CacheRemoveAllInterceptor {
    private final CacheResolver cacheResolver;

    @Inject
    public CacheRemoveAllInterceptor(CacheResolver cacheResolver) {
        this.cacheResolver = cacheResolver;
    }

    @AroundInvoke
    public Object cacheRemoveAll(InvocationContext context) throws Exception {
        Method method = context.getMethod();
        CacheRemoveAll cacheRemoveAll = method.getAnnotation(CacheRemoveAll.class);
        String cacheName = cacheRemoveAll.cacheName();
        Cache cache = this.cacheResolver.resolveCache(cacheName, method);
        if (!cacheRemoveAll.afterInvocation()) {
            cache.clear();
        }
        Object result = context.proceed();
        if (cacheRemoveAll.afterInvocation()) {
            cache.clear();
        }
        return result;
    }
}

