/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cdi.interceptor;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import javax.cache.CacheException;
import javax.cache.interceptor.CacheRemoveAll;
import javax.cache.interceptor.CacheRemoveEntry;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Default;
import javax.enterprise.inject.Instance;
import javax.enterprise.util.AnnotationLiteral;
import javax.inject.Inject;
import org.infinispan.Cache;
import org.infinispan.cdi.interceptor.CacheResolver;
import org.infinispan.cdi.util.CacheHelper;
import org.infinispan.cdi.util.Contracts;
import org.infinispan.manager.EmbeddedCacheManager;

public class DefaultCacheResolver
implements CacheResolver {
    private final EmbeddedCacheManager defaultCacheManager;
    private final Instance<EmbeddedCacheManager> cacheManagers;

    @Inject
    public DefaultCacheResolver(@Any Instance<EmbeddedCacheManager> cacheManagers) {
        this.cacheManagers = cacheManagers;
        this.defaultCacheManager = (EmbeddedCacheManager)cacheManagers.select(new Annotation[]{new AnnotationLiteral<Default>(){}}).get();
    }

    @Override
    public <K, V> Cache<K, V> resolveCache(String cacheName, Method method) {
        Contracts.assertNotNull(cacheName, "cacheName parameter cannot be null");
        Contracts.assertNotNull(method, "method parameter cannot be null");
        if (cacheName.isEmpty() && (method.isAnnotationPresent(CacheRemoveAll.class) || method.isAnnotationPresent(CacheRemoveEntry.class))) {
            throw new CacheException("Method named '" + method.getName() + "' annotated with CacheRemoveAll or " + "CacheRemoveEntry doesn't specify a cache name");
        }
        String name = cacheName.isEmpty() ? CacheHelper.getDefaultMethodCacheName(method) : cacheName;
        for (EmbeddedCacheManager oneCacheManager : this.cacheManagers) {
            if (!oneCacheManager.getCacheNames().contains(name)) continue;
            return oneCacheManager.getCache(name);
        }
        return this.defaultCacheManager.getCache(name);
    }
}

