/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cdi.util;

import java.lang.reflect.Method;
import javax.cache.interceptor.CacheKey;
import javax.cache.interceptor.CacheKeyGenerator;
import javax.interceptor.InvocationContext;
import org.infinispan.CacheException;
import org.infinispan.cdi.util.Contracts;

public final class CacheHelper {
    private CacheHelper() {
    }

    public static String getDefaultMethodCacheName(Method method) {
        Contracts.assertNotNull(method, "method parameter cannot be null");
        int i = 0;
        int nbParameters = method.getParameterTypes().length;
        StringBuilder cacheName = new StringBuilder().append(method.getDeclaringClass().getName()).append(".").append(method.getName()).append("(");
        for (Class<?> oneParameterType : method.getParameterTypes()) {
            cacheName.append(oneParameterType.getName());
            if (i < nbParameters - 1) {
                cacheName.append(",");
            }
            ++i;
        }
        return cacheName.append(")").toString();
    }

    public static CacheKey generateCacheKey(Class<? extends CacheKeyGenerator> cacheKeyGeneratorClass, InvocationContext context) {
        Contracts.assertNotNull(cacheKeyGeneratorClass, "cacheKeyGeneratorClass parameter cannot be null");
        Contracts.assertNotNull(context, "context parameter cannot be null");
        try {
            CacheKeyGenerator cacheKeyGenerator = cacheKeyGeneratorClass.newInstance();
            return cacheKeyGenerator.generateCacheKey(context);
        }
        catch (InstantiationException e) {
            throw new CacheException("Cannot instantiate CacheKeyGenerator named '" + cacheKeyGeneratorClass + "'", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new CacheException("Cannot instantiate CacheKeyGenerator named '" + cacheKeyGeneratorClass + "'", (Throwable)e);
        }
    }
}

