/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cdi;

import java.lang.annotation.Annotation;
import java.util.HashSet;
import java.util.Set;
import javax.cache.interceptor.CachePut;
import javax.cache.interceptor.CacheRemoveAll;
import javax.cache.interceptor.CacheRemoveEntry;
import javax.cache.interceptor.CacheResult;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Default;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.spi.AfterDeploymentValidation;
import javax.enterprise.inject.spi.AnnotatedMember;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.BeforeBeanDiscovery;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import javax.enterprise.inject.spi.ProcessProducer;
import javax.enterprise.inject.spi.Producer;
import javax.enterprise.util.AnnotationLiteral;
import org.infinispan.cdi.ConfigureCache;
import org.infinispan.cdi.event.cachemanager.CacheManagerEventBridge;
import org.infinispan.cdi.interceptor.CachePutInterceptor;
import org.infinispan.cdi.interceptor.CacheRemoveAllInterceptor;
import org.infinispan.cdi.interceptor.CacheRemoveEntryInterceptor;
import org.infinispan.cdi.interceptor.CacheResultInterceptor;
import org.infinispan.cdi.interceptor.literal.CachePutLiteral;
import org.infinispan.cdi.interceptor.literal.CacheRemoveAllLiteral;
import org.infinispan.cdi.interceptor.literal.CacheRemoveEntryLiteral;
import org.infinispan.cdi.interceptor.literal.CacheResultLiteral;
import org.infinispan.config.Configuration;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.notifications.Listenable;
import org.jboss.seam.solder.bean.Beans;
import org.jboss.seam.solder.reflection.annotated.AnnotatedTypeBuilder;

public class InfinispanExtension
implements Extension {
    private final Set<ConfigurationHolder> configurations = new HashSet<ConfigurationHolder>();

    InfinispanExtension() {
    }

    void registerInterceptorBindings(@Observes BeforeBeanDiscovery event) {
        event.addInterceptorBinding(CacheResult.class, new Annotation[0]);
        event.addInterceptorBinding(CachePut.class, new Annotation[0]);
        event.addInterceptorBinding(CacheRemoveEntry.class, new Annotation[0]);
        event.addInterceptorBinding(CacheRemoveAll.class, new Annotation[0]);
    }

    void registerCacheResultInterceptor(@Observes ProcessAnnotatedType<CacheResultInterceptor> event) {
        event.setAnnotatedType(new AnnotatedTypeBuilder().readFromType(event.getAnnotatedType()).addToClass((Annotation)((Object)CacheResultLiteral.INSTANCE)).create());
    }

    void registerCachePutInterceptor(@Observes ProcessAnnotatedType<CachePutInterceptor> event) {
        event.setAnnotatedType(new AnnotatedTypeBuilder().readFromType(event.getAnnotatedType()).addToClass((Annotation)((Object)CachePutLiteral.INSTANCE)).create());
    }

    void registerCacheRemoveEntryInterceptor(@Observes ProcessAnnotatedType<CacheRemoveEntryInterceptor> event) {
        event.setAnnotatedType(new AnnotatedTypeBuilder().readFromType(event.getAnnotatedType()).addToClass((Annotation)((Object)CacheRemoveEntryLiteral.INSTANCE)).create());
    }

    void registerCacheRemoveAllInterceptor(@Observes ProcessAnnotatedType<CacheRemoveAllInterceptor> event) {
        event.setAnnotatedType(new AnnotatedTypeBuilder().readFromType(event.getAnnotatedType()).addToClass((Annotation)((Object)CacheRemoveAllLiteral.INSTANCE)).create());
    }

    void saveCacheConfigurations(@Observes ProcessProducer<?, Configuration> event, BeanManager beanManager) {
        ConfigureCache annotation = (ConfigureCache)event.getAnnotatedMember().getAnnotation(ConfigureCache.class);
        if (annotation != null) {
            String name = annotation.value();
            this.configurations.add(new ConfigurationHolder((Producer<Configuration>)event.getProducer(), name, event.getAnnotatedMember(), beanManager));
        }
    }

    void registerCacheConfigurations(@Observes AfterDeploymentValidation event, CacheManagerEventBridge eventBridge, @Any Instance<EmbeddedCacheManager> cacheManagers, BeanManager beanManager) {
        CreationalContext ctx = beanManager.createCreationalContext(null);
        EmbeddedCacheManager defaultCacheManager = (EmbeddedCacheManager)cacheManagers.select(new Annotation[]{new AnnotationLiteral<Default>(){}}).get();
        for (ConfigurationHolder oneConfigurationHolder : this.configurations) {
            EmbeddedCacheManager cacheManager;
            String cacheName = oneConfigurationHolder.getName();
            Configuration cacheConfiguration = (Configuration)oneConfigurationHolder.getProducer().produce(ctx);
            Set<Annotation> cacheQualifiers = oneConfigurationHolder.getQualifiers();
            Instance specificCacheManager = cacheManagers.select(cacheQualifiers.toArray(new Annotation[cacheQualifiers.size()]));
            EmbeddedCacheManager embeddedCacheManager = cacheManager = specificCacheManager.isUnsatisfied() ? defaultCacheManager : (EmbeddedCacheManager)specificCacheManager.get();
            if (!cacheName.trim().isEmpty()) {
                if (cacheConfiguration != null) {
                    cacheManager.defineConfiguration(cacheName, cacheConfiguration);
                } else if (!cacheManager.getCacheNames().contains(cacheName)) {
                    cacheManager.defineConfiguration(cacheName, cacheManager.getDefaultConfiguration().clone());
                }
            }
            eventBridge.registerObservers(cacheQualifiers, cacheName, (Listenable)cacheManager);
        }
    }

    static class ConfigurationHolder {
        private final Producer<Configuration> producer;
        private final Set<Annotation> qualifiers;
        private final String name;

        ConfigurationHolder(Producer<Configuration> producer, String name, AnnotatedMember<?> annotatedMember, BeanManager beanManager) {
            this.producer = producer;
            this.name = name;
            this.qualifiers = Beans.getQualifiers((BeanManager)beanManager, (Iterable)annotatedMember.getAnnotations());
        }

        Producer<Configuration> getProducer() {
            return this.producer;
        }

        String getName() {
            return this.name;
        }

        public Set<Annotation> getQualifiers() {
            return this.qualifiers;
        }
    }
}

