/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cdi.interceptor;

import java.lang.annotation.Annotation;
import javax.cache.interceptor.CacheInvocationContext;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Default;
import javax.enterprise.inject.Instance;
import javax.enterprise.util.AnnotationLiteral;
import javax.inject.Inject;
import org.infinispan.Cache;
import org.infinispan.cdi.interceptor.CacheResolver;
import org.infinispan.cdi.util.Contracts;
import org.infinispan.manager.EmbeddedCacheManager;

public class DefaultCacheResolver
implements CacheResolver {
    private final EmbeddedCacheManager defaultCacheManager;
    private final Instance<EmbeddedCacheManager> cacheManagers;

    @Inject
    public DefaultCacheResolver(@Any Instance<EmbeddedCacheManager> cacheManagers) {
        this.cacheManagers = cacheManagers;
        this.defaultCacheManager = (EmbeddedCacheManager)cacheManagers.select(new Annotation[]{new AnnotationLiteral<Default>(){}}).get();
    }

    @Override
    public <K, V> Cache<K, V> resolveCache(CacheInvocationContext<? extends Annotation> cacheInvocationContext) {
        Contracts.assertNotNull(cacheInvocationContext, "cacheInvocationContext parameter cannot be null");
        String cacheName = cacheInvocationContext.getCacheName();
        if (cacheName.trim().isEmpty()) {
            return this.defaultCacheManager.getCache();
        }
        for (EmbeddedCacheManager oneCacheManager : this.cacheManagers) {
            if (!oneCacheManager.getCacheNames().contains(cacheName)) continue;
            return oneCacheManager.getCache(cacheName);
        }
        return this.defaultCacheManager.getCache(cacheName);
    }
}

