/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cdi.interceptor;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import javax.cache.annotation.CacheInvocationContext;
import javax.cache.annotation.CacheKey;
import javax.cache.annotation.CacheKeyGenerator;
import javax.cache.annotation.CacheKeyInvocationContext;
import javax.cache.annotation.CachePut;
import javax.inject.Inject;
import javax.interceptor.AroundInvoke;
import javax.interceptor.Interceptor;
import javax.interceptor.InvocationContext;
import org.infinispan.Cache;
import org.infinispan.cdi.interceptor.CacheResolver;
import org.infinispan.cdi.interceptor.context.CacheKeyInvocationContextFactory;
import org.infinispan.cdi.interceptor.context.CacheKeyInvocationContextImpl;

@Interceptor
public class CachePutInterceptor
implements Serializable {
    private static final long serialVersionUID = 270924196162168618L;
    private final CacheResolver cacheResolver;
    private final CacheKeyInvocationContextFactory contextFactory;

    @Inject
    public CachePutInterceptor(CacheResolver cacheResolver, CacheKeyInvocationContextFactory contextFactory) {
        this.cacheResolver = cacheResolver;
        this.contextFactory = contextFactory;
    }

    @AroundInvoke
    public Object cacheResult(InvocationContext invocationContext) throws Exception {
        CacheKeyInvocationContext cacheKeyInvocationContext = this.contextFactory.getCacheKeyInvocationContext(invocationContext);
        CacheKeyGenerator cacheKeyGenerator = ((CacheKeyInvocationContextImpl)cacheKeyInvocationContext.unwrap(CacheKeyInvocationContextImpl.class)).getCacheKeyGenerator();
        CachePut cacheResult = (CachePut)cacheKeyInvocationContext.getCacheAnnotation();
        CacheKey cacheKey = cacheKeyGenerator.generateCacheKey(cacheKeyInvocationContext);
        Cache cache = this.cacheResolver.resolveCache((CacheInvocationContext<? extends Annotation>)cacheKeyInvocationContext);
        Object valueToCache = cacheKeyInvocationContext.getValueParameter().getValue();
        if (!cacheResult.afterInvocation() && valueToCache != null) {
            cache.put((Object)cacheKey, valueToCache);
        }
        Object result = invocationContext.proceed();
        if (cacheResult.afterInvocation() && valueToCache != null) {
            cache.put((Object)cacheKey, valueToCache);
        }
        return result;
    }
}

