/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cdi.interceptor;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import javax.cache.annotation.CacheInvocationContext;
import javax.cache.annotation.CacheKey;
import javax.cache.annotation.CacheKeyGenerator;
import javax.cache.annotation.CacheKeyInvocationContext;
import javax.cache.annotation.CacheRemoveEntry;
import javax.inject.Inject;
import javax.interceptor.AroundInvoke;
import javax.interceptor.Interceptor;
import javax.interceptor.InvocationContext;
import org.infinispan.Cache;
import org.infinispan.cdi.interceptor.CacheResolver;
import org.infinispan.cdi.interceptor.context.CacheKeyInvocationContextFactory;
import org.infinispan.cdi.interceptor.context.CacheKeyInvocationContextImpl;

@Interceptor
public class CacheRemoveEntryInterceptor
implements Serializable {
    private static final long serialVersionUID = -9079291622309963969L;
    private final CacheResolver cacheResolver;
    private final CacheKeyInvocationContextFactory contextFactory;

    @Inject
    public CacheRemoveEntryInterceptor(CacheResolver cacheResolver, CacheKeyInvocationContextFactory contextFactory) {
        this.cacheResolver = cacheResolver;
        this.contextFactory = contextFactory;
    }

    @AroundInvoke
    public Object cacheRemoveEntry(InvocationContext invocationContext) throws Exception {
        CacheKeyInvocationContext cacheKeyInvocationContext = this.contextFactory.getCacheKeyInvocationContext(invocationContext);
        CacheKeyGenerator cacheKeyGenerator = ((CacheKeyInvocationContextImpl)cacheKeyInvocationContext.unwrap(CacheKeyInvocationContextImpl.class)).getCacheKeyGenerator();
        Cache cache = this.cacheResolver.resolveCache((CacheInvocationContext<? extends Annotation>)cacheKeyInvocationContext);
        CacheRemoveEntry cacheRemoveEntry = (CacheRemoveEntry)cacheKeyInvocationContext.getCacheAnnotation();
        CacheKey cacheKey = cacheKeyGenerator.generateCacheKey(cacheKeyInvocationContext);
        if (!cacheRemoveEntry.afterInvocation()) {
            cache.remove((Object)cacheKey);
        }
        Object result = invocationContext.proceed();
        if (cacheRemoveEntry.afterInvocation()) {
            cache.remove((Object)cacheKey);
        }
        return result;
    }
}

