/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cdi.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Set;
import javax.cache.annotation.CacheDefaults;
import javax.cache.annotation.CacheKeyGenerator;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import org.infinispan.CacheException;
import org.infinispan.cdi.interceptor.DefaultCacheKeyGenerator;
import org.infinispan.cdi.util.Contracts;

public final class CacheLookupHelper {
    private CacheLookupHelper() {
    }

    public static String getCacheName(Method method, String methodCacheName, CacheDefaults cacheDefaultsAnnotation, boolean generate) {
        Contracts.assertNotNull(method, "method parameter cannot be null");
        Contracts.assertNotNull(methodCacheName, "methodCacheName parameter cannot be null");
        String cacheName = methodCacheName.trim();
        if (cacheName.isEmpty() && cacheDefaultsAnnotation != null) {
            cacheName = cacheDefaultsAnnotation.cacheName().trim();
        }
        if (cacheName.isEmpty() && generate) {
            cacheName = CacheLookupHelper.getDefaultMethodCacheName(method);
        }
        return cacheName;
    }

    public static CacheKeyGenerator getCacheKeyGenerator(BeanManager beanManager, Class<? extends CacheKeyGenerator> methodCacheKeyGeneratorClass, CacheDefaults cacheDefaultsAnnotation) {
        Contracts.assertNotNull(beanManager, "beanManager parameter cannot be null");
        Class cacheKeyGeneratorClass = DefaultCacheKeyGenerator.class;
        if (!CacheKeyGenerator.class.equals(methodCacheKeyGeneratorClass)) {
            cacheKeyGeneratorClass = methodCacheKeyGeneratorClass;
        } else if (cacheDefaultsAnnotation != null && !CacheKeyGenerator.class.equals((Object)cacheDefaultsAnnotation.cacheKeyGenerator())) {
            cacheKeyGeneratorClass = cacheDefaultsAnnotation.cacheKeyGenerator();
        }
        CreationalContext creationalContext = beanManager.createCreationalContext(null);
        Set beans = beanManager.getBeans((Type)cacheKeyGeneratorClass, new Annotation[0]);
        if (!beans.isEmpty()) {
            Bean bean = beanManager.resolve(beans);
            return (CacheKeyGenerator)beanManager.getReference(bean, CacheKeyGenerator.class, creationalContext);
        }
        try {
            return (CacheKeyGenerator)cacheKeyGeneratorClass.newInstance();
        }
        catch (InstantiationException e) {
            throw new CacheException("Unable to instantiate the CacheKeyGenerator with type '" + cacheKeyGeneratorClass + "'", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new CacheException("Unable to instantiate the CacheKeyGenerator with type '" + cacheKeyGeneratorClass + "'", (Throwable)e);
        }
    }

    private static String getDefaultMethodCacheName(Method method) {
        int i = 0;
        int nbParameters = method.getParameterTypes().length;
        StringBuilder cacheName = new StringBuilder().append(method.getDeclaringClass().getName()).append(".").append(method.getName()).append("(");
        for (Class<?> oneParameterType : method.getParameterTypes()) {
            cacheName.append(oneParameterType.getName());
            if (i < nbParameters - 1) {
                cacheName.append(",");
            }
            ++i;
        }
        return cacheName.append(")").toString();
    }
}

