/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cdi;

import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Default;
import javax.enterprise.inject.Disposes;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.Produces;
import org.infinispan.cdi.OverrideDefault;
import org.infinispan.cdi.util.logging.Log;
import org.infinispan.config.Configuration;
import org.infinispan.manager.DefaultCacheManager;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.util.logging.LogFactory;

public class DefaultCacheManagerProducer {
    private static final Log log = (Log)LogFactory.getLog(DefaultCacheManagerProducer.class, Log.class);

    @Produces
    @Default
    @ApplicationScoped
    public EmbeddedCacheManager getDefaultCacheManager(@OverrideDefault Instance<EmbeddedCacheManager> providedDefaultCacheManager, @Default Configuration defaultConfiguration) {
        if (!providedDefaultCacheManager.isUnsatisfied()) {
            log.tracef("Default cache manager overridden by '%s'", providedDefaultCacheManager);
            return (EmbeddedCacheManager)providedDefaultCacheManager.get();
        }
        return new DefaultCacheManager(defaultConfiguration);
    }

    private void stopCacheManager(@Disposes @Default EmbeddedCacheManager defaultCacheManager) {
        defaultCacheManager.stop();
    }
}

