/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cdi;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.enterprise.inject.spi.BeanManager;
import org.jboss.solder.beanManager.BeanManagerAware;

public class BeanManagerController
extends BeanManagerAware {
    private Map<ClassLoader, BeanManager> beanManagers = new ConcurrentHashMap<ClassLoader, BeanManager>();

    public BeanManager getRegisteredBeanManager() {
        ClassLoader classLoader = this.getClassLoader(null);
        BeanManager bm = this.resolveBeanManager(classLoader);
        if (bm == null) {
            bm = this.getBeanManager();
            if (bm == null) {
                throw new IllegalStateException("Can not find BeanManager. Check CDI setup in your execution environment!");
            }
            this.registerBeanManager(classLoader, bm);
        }
        return bm;
    }

    public void registerBeanManager(ClassLoader cl, BeanManager bm) {
        this.beanManagers.put(cl, bm);
    }

    public void registerBeanManager(BeanManager bm) {
        this.beanManagers.put(this.getClassLoader(null), bm);
    }

    public void deregisterBeanManager(ClassLoader cl) {
        this.beanManagers.remove(cl);
    }

    public void deregisterBeanManager() {
        this.beanManagers.remove(this.getClassLoader(null));
    }

    public BeanManager resolveBeanManager(ClassLoader cl) {
        return this.beanManagers.get(cl);
    }

    public ClassLoader getClassLoader(Object o) {
        ClassLoader loader = AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                try {
                    return Thread.currentThread().getContextClassLoader();
                }
                catch (Exception e) {
                    return null;
                }
            }
        });
        if (loader == null && o != null) {
            loader = o.getClass().getClassLoader();
        }
        if (loader == null) {
            loader = BeanManagerController.class.getClassLoader();
        }
        return loader;
    }
}

