/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cli.commands;

import java.util.Collections;
import org.aesh.command.CommandDefinition;
import org.aesh.command.CommandResult;
import org.aesh.command.GroupCommandDefinition;
import org.aesh.command.impl.completer.FileOptionCompleter;
import org.aesh.command.option.Argument;
import org.aesh.command.option.Option;
import org.aesh.io.Resource;
import org.infinispan.cli.activators.ConnectionActivator;
import org.infinispan.cli.commands.CliCommand;
import org.infinispan.cli.commands.CommandInputLine;
import org.infinispan.cli.completers.CacheConfigurationCompleter;
import org.infinispan.cli.impl.ContextAwareCommandInvocation;
import org.infinispan.cli.logging.Messages;

@GroupCommandDefinition(name="create", description="Creates a cache or a counter", activator=ConnectionActivator.class, groupCommands={Cache.class, Counter.class})
public class Create
extends CliCommand {
    @Override
    public CommandResult exec(ContextAwareCommandInvocation commandInvocation) {
        if (this.help) {
            commandInvocation.println(commandInvocation.getHelpInfo());
        }
        return CommandResult.SUCCESS;
    }

    @CommandDefinition(name="counter", description="Create a counter", activator=ConnectionActivator.class)
    public static class Counter
    extends CliCommand {
        @Argument(required=true)
        String name;

        @Override
        public CommandResult exec(ContextAwareCommandInvocation invocation) {
            CommandInputLine cmd = new CommandInputLine("create").arg("type", "counter").arg("name", this.name);
            return invocation.execute(Collections.singletonList(cmd));
        }
    }

    @CommandDefinition(name="cache", description="Create a cache", activator=ConnectionActivator.class)
    public static class Cache
    extends CliCommand {
        @Argument(required=true)
        String name;
        @Option(completer=CacheConfigurationCompleter.class)
        String template;
        @Option(completer=FileOptionCompleter.class)
        Resource file;
        @Option(defaultValue={"true"})
        boolean permanent;

        @Override
        public CommandResult exec(ContextAwareCommandInvocation invocation) {
            if (this.template != null && this.file != null) {
                throw Messages.MSG.mutuallyExclusiveOptions("template", "file");
            }
            if (this.template == null && this.file == null) {
                throw Messages.MSG.requiresOneOf("template", "file");
            }
            CommandInputLine cmd = new CommandInputLine("create").arg("type", "cache").arg("name", this.name).optionalArg("template", this.template).optionalArg("file", this.file != null ? this.file.getAbsolutePath() : null).option("permanent", this.permanent);
            return invocation.execute(cmd);
        }
    }
}

