/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cli.commands;

import java.util.List;
import org.aesh.command.CommandDefinition;
import org.aesh.command.CommandResult;
import org.aesh.command.impl.completer.FileOptionCompleter;
import org.aesh.command.option.Arguments;
import org.aesh.command.option.Option;
import org.aesh.io.Resource;
import org.infinispan.cli.activators.ConnectionActivator;
import org.infinispan.cli.commands.CliCommand;
import org.infinispan.cli.commands.CommandInputLine;
import org.infinispan.cli.completers.CacheCompleter;
import org.infinispan.cli.completers.EncodingCompleter;
import org.infinispan.cli.impl.ContextAwareCommandInvocation;
import org.infinispan.cli.logging.Messages;

@CommandDefinition(name="put", description="Puts an entry into the cache", activator=ConnectionActivator.class)
public class Put
extends CliCommand {
    @Arguments(required=true)
    List<String> args;
    @Option(completer=EncodingCompleter.class)
    String encoding;
    @Option(completer=CacheCompleter.class)
    String cache;
    @Option(completer=FileOptionCompleter.class)
    Resource file;

    @Override
    public CommandResult exec(ContextAwareCommandInvocation invocation) {
        if (this.file != null && this.args.size() != 1) {
            throw Messages.MSG.illegalCommandArguments();
        }
        if (this.file == null && this.args.size() != 2) {
            throw Messages.MSG.illegalCommandArguments();
        }
        CommandInputLine cmd = new CommandInputLine("put").arg("key", this.args.get(0)).optionalArg("value", this.args.size() > 1 ? this.args.get(1) : null).optionalArg("file", this.file != null ? this.file.getAbsolutePath() : null).optionalArg("encoding", this.encoding).optionalArg("cache", this.cache);
        return invocation.execute(cmd);
    }
}

