/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cli.connection.rest;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;
import org.infinispan.cli.commands.CommandInputLine;
import org.infinispan.cli.connection.Connection;
import org.infinispan.cli.logging.Messages;
import org.infinispan.cli.resources.AbstractResource;
import org.infinispan.cli.resources.CacheResource;
import org.infinispan.cli.resources.ContainerResource;
import org.infinispan.cli.resources.Resource;
import org.infinispan.cli.resources.RootResource;
import org.infinispan.cli.util.IterableJsonReader;
import org.infinispan.client.rest.RestCacheClient;
import org.infinispan.client.rest.RestClient;
import org.infinispan.client.rest.RestEntity;
import org.infinispan.client.rest.RestResponse;
import org.infinispan.client.rest.configuration.RestClientConfiguration;
import org.infinispan.client.rest.configuration.RestClientConfigurationBuilder;
import org.infinispan.client.rest.configuration.ServerConfiguration;
import org.infinispan.commons.api.CacheContainerAdmin;
import org.infinispan.commons.dataconversion.MediaType;

public class RestConnection
implements Connection,
Closeable {
    private final RestClientConfigurationBuilder builder;
    private final ObjectMapper mapper;
    private Resource activeResource;
    private MediaType encoding = MediaType.TEXT_PLAIN;
    private Collection<String> availableConfigurations;
    private Collection<String> availableContainers;
    private Collection<String> availableCaches;
    private Collection<String> availableCounters;
    private Collection<String> clusterMembers;
    private RestClient client;
    private boolean connected;
    private String serverVersion;
    private String serverInfo;

    public RestConnection(RestClientConfigurationBuilder builder) {
        this.builder = builder;
        this.mapper = new ObjectMapper();
    }

    @Override
    public void close() throws IOException {
        this.client.close();
    }

    @Override
    public void connect() throws IOException {
        this.client = RestClient.forConfiguration((RestClientConfiguration)this.builder.build());
        this.connectInternal();
    }

    @Override
    public void connect(String username, String password) throws IOException {
        this.builder.security().authentication().enable().username(username).password(password);
        this.client = RestClient.forConfiguration((RestClientConfiguration)this.builder.build());
        this.connectInternal();
    }

    private void connectInternal() throws IOException {
        this.serverVersion = (String)this.parseResponse(() -> this.client.server().info(), Map.class).get("version");
        this.connected = true;
        this.availableContainers = this.parseResponse(() -> this.client.cacheManagers(), List.class);
        this.activeResource = Resource.getRootResource(this).getChild("containers", this.availableContainers.iterator().next());
        this.refreshServerInfo();
    }

    private <T> T parseResponse(Supplier<CompletionStage<RestResponse>> responseSupplier, Class<T> returnClass) throws IOException {
        return this.parseResponse(responseSupplier.get(), returnClass);
    }

    private <T> T parseResponse(CompletionStage<RestResponse> responseFuture, Class<T> returnClass) throws IOException {
        try {
            RestResponse response = responseFuture.toCompletableFuture().get(10L, TimeUnit.SECONDS);
            switch (response.getStatus()) {
                case 200: {
                    if (returnClass == InputStream.class) {
                        return (T)response.getBodyAsStream();
                    }
                    if (returnClass == String.class) {
                        if (MediaType.APPLICATION_JSON.equals((Object)response.contentType())) {
                            Object object = this.mapper.readValue(response.getBody(), Object.class);
                            return (T)this.mapper.writerWithDefaultPrettyPrinter().writeValueAsString(object);
                        }
                        return (T)response.getBody();
                    }
                    return (T)this.mapper.readValue(response.getBody(), returnClass);
                }
                case 204: {
                    return null;
                }
                case 401: {
                    throw Messages.MSG.unauthorized(response.getBody());
                }
                case 403: {
                    throw Messages.MSG.forbidden(response.getBody());
                }
                case 404: {
                    throw Messages.MSG.notFound(response.getBody());
                }
            }
            throw Messages.MSG.error(response.getBody());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IOException(e);
        }
        catch (ExecutionException e) {
            throw Messages.MSG.connectionFailed(e.getMessage());
        }
        catch (TimeoutException e) {
            throw new IOException(e);
        }
    }

    private Resource pathToResource(String path) {
        if (".".equals(path)) {
            return this.activeResource;
        }
        if ("..".equals(path)) {
            return this.activeResource.getParent();
        }
        String[] parts = path.split("/");
        if (parts.length == 0) {
            return this.activeResource.findAncestor(RootResource.class);
        }
        Resource resource = this.activeResource;
        for (String part : parts) {
            resource = part.isEmpty() ? resource.findAncestor(RootResource.class) : resource.getChild(part);
        }
        return resource;
    }

    @Override
    public String execute(List<CommandInputLine> commands) throws IOException {
        StringBuilder sb = new StringBuilder();
        for (CommandInputLine command : commands) {
            String s;
            CompletionStage response = null;
            switch (command.name()) {
                case "cache": {
                    this.activeResource = this.activeResource.findAncestor(ContainerResource.class).getChild("caches", command.arg("name"));
                    break;
                }
                case "cd": {
                    String path = command.arg("name");
                    this.activeResource = this.pathToResource(path);
                    break;
                }
                case "clearcache": {
                    this.activeResource.findAncestor(ContainerResource.class).getChild("caches").getChild(command.arg("name"));
                    if (command.hasArg("name")) {
                        response = this.client.cache(command.arg("name")).clear();
                        break;
                    }
                    Object resource = this.activeResource.findAncestor(CacheResource.class);
                    if (resource == null) break;
                    response = this.client.cache(((AbstractResource)resource).getName()).clear();
                    break;
                }
                case "container": {
                    this.activeResource = this.activeResource.findAncestor(RootResource.class).getChild("containers", command.arg("name"));
                    break;
                }
                case "counter": {
                    this.activeResource = this.activeResource.findAncestor(ContainerResource.class).getChild("counters", command.arg("name"));
                    break;
                }
                case "create": {
                    switch (command.arg("type")) {
                        case "cache": {
                            CacheContainerAdmin.AdminFlag flags;
                            RestCacheClient cache = this.client.cache(command.arg("name"));
                            boolean permanent = Boolean.parseBoolean(command.option("permanent"));
                            Object object = flags = permanent ? CacheContainerAdmin.AdminFlag.PERMANENT : null;
                            if (command.hasArg("template")) {
                                response = cache.createWithTemplate(command.arg("template"), new CacheContainerAdmin.AdminFlag[]{flags});
                                break;
                            }
                            RestEntity entity = this.entityFromFile(new File(command.arg("file")));
                            response = cache.createWithConfiguration(entity, new CacheContainerAdmin.AdminFlag[]{flags});
                            break;
                        }
                        case "counter": {
                            response = this.client.counter(command.arg("name")).create();
                        }
                    }
                    break;
                }
                case "describe": {
                    Object resource = this.activeResource;
                    if (command.hasArg("name")) {
                        resource = this.pathToResource(command.arg("name"));
                    }
                    return resource.describe();
                }
                case "drop": {
                    switch (command.arg("type")) {
                        case "cache": {
                            response = this.client.cache(command.arg("name")).delete();
                            break;
                        }
                        case "counter": {
                            response = this.client.counter(command.arg("name")).delete();
                        }
                    }
                    break;
                }
                case "encoding": {
                    if (command.hasArg("type")) {
                        this.encoding = MediaType.fromString((String)command.arg("type"));
                        break;
                    }
                    sb.append(this.encoding);
                    break;
                }
                case "get": {
                    RestCacheClient cache = command.hasArg("cache") ? this.client.cache(command.arg("cache")) : this.client.cache(this.activeResource.findAncestor(CacheResource.class).getName());
                    response = cache.get(command.arg("key"));
                    break;
                }
                case "ls": {
                    StringJoiner j = new StringJoiner("\n");
                    for (String item : this.activeResource.getChildrenNames()) {
                        j.add(item);
                    }
                    return j.toString();
                }
                case "query": {
                    RestCacheClient cache = command.hasArg("cache") ? this.client.cache(command.arg("cache")) : this.client.cache(this.activeResource.findAncestor(CacheResource.class).getName());
                    response = cache.query(command.arg("query"));
                    break;
                }
                case "remove": {
                    RestCacheClient cache = command.hasArg("cache") ? this.client.cache(command.arg("cache")) : this.client.cache(this.activeResource.findAncestor(CacheResource.class).getName());
                    response = cache.remove(command.arg("key"));
                    break;
                }
                case "put": {
                    RestCacheClient cache = command.hasArg("cache") ? this.client.cache(command.arg("cache")) : this.client.cache(this.activeResource.findAncestor(CacheResource.class).getName());
                    MediaType putEncoding = command.hasArg("encoding") ? MediaType.fromString((String)command.arg("encoding")) : this.encoding;
                    RestEntity value = command.hasArg("file") ? RestEntity.create((MediaType)putEncoding, (File)new File(command.arg("file"))) : RestEntity.create((MediaType)putEncoding, (String)command.arg("value"));
                    response = cache.put(command.arg("key"), value);
                    break;
                }
                case "shutdown": {
                    response = this.client.server().stop().thenApply(f -> {
                        try {
                            this.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        return f;
                    });
                    break;
                }
            }
            if (response == null || (s = this.parseResponse(response, String.class)) == null) continue;
            sb.append(s);
        }
        this.refreshServerInfo();
        return sb.toString();
    }

    @Override
    public Resource getActiveResource() {
        return this.activeResource;
    }

    @Override
    public ContainerResource getActiveContainer() {
        return this.activeResource.findAncestor(ContainerResource.class);
    }

    @Override
    public Collection<String> getAvailableCaches(String container) {
        return this.availableCaches;
    }

    @Override
    public Collection<String> getAvailableContainers() {
        return this.availableContainers;
    }

    @Override
    public Collection<String> getAvailableCounters(String container) {
        return this.availableCounters;
    }

    @Override
    public Collection<String> getAvailableCacheConfigurations(String container) {
        return this.availableConfigurations;
    }

    @Override
    public Iterable<String> getCacheKeys(String container, String cache) throws IOException {
        CompletionStage response = this.client.cache(cache).keys();
        return new IterableJsonReader(this.parseResponse(response, InputStream.class), s -> s == null || "_value".equals(s));
    }

    @Override
    public boolean isConnected() {
        return this.connected;
    }

    @Override
    public String describeContainer(String container) throws IOException {
        return this.parseResponse(this.client.cacheManager(container).info(), String.class);
    }

    @Override
    public String describeCache(String container, String cache) throws IOException {
        return this.parseResponse(this.client.cache(cache).configuration(), String.class);
    }

    @Override
    public String describeConfiguration(String container, String counter) {
        return null;
    }

    @Override
    public String describeCounter(String container, String counter) throws IOException {
        return this.parseResponse(this.client.counter(counter).configuration(), String.class);
    }

    @Override
    public Collection<String> getClusterNodes() {
        return this.clusterMembers;
    }

    @Override
    public String getConnectionInfo() {
        return this.serverInfo;
    }

    @Override
    public String getServerVersion() {
        return this.serverVersion;
    }

    private void refreshServerInfo() throws IOException {
        try {
            ContainerResource container = this.getActiveContainer();
            String containerName = container.getName();
            Map cacheManagerInfo = this.parseResponse(() -> this.client.cacheManager(containerName).info(), Map.class);
            List definedCaches = (List)cacheManagerInfo.get("defined_caches");
            this.availableCaches = new ArrayList<String>();
            definedCaches.forEach(m -> this.availableCaches.add((String)m.get("name")));
            List configurationList = this.parseResponse(() -> this.client.cacheManager(containerName).cacheConfigurations(), List.class);
            this.availableConfigurations = new ArrayList<String>(configurationList.size());
            for (Object item : configurationList) {
                this.availableConfigurations.add((String)((Map)item).get("name"));
            }
            this.availableCounters = new ArrayList<String>();
            String nodeAddress = (String)cacheManagerInfo.get("node_address");
            String clusterName = (String)cacheManagerInfo.get("cluster_name");
            this.clusterMembers = (Collection)cacheManagerInfo.get("cluster_members");
            if (nodeAddress != null) {
                this.serverInfo = nodeAddress + "@" + clusterName;
            } else {
                ServerConfiguration serverConfiguration = (ServerConfiguration)this.client.getConfiguration().servers().get(0);
                this.serverInfo = serverConfiguration.host() + ":" + serverConfiguration.port();
            }
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    private RestEntity entityFromFile(File f) throws IOException {
        try (FileInputStream is = new FileInputStream(f);){
            int b;
            while ((b = ((InputStream)is).read()) > -1) {
                if (b == 123) {
                    RestEntity restEntity = RestEntity.create((MediaType)MediaType.APPLICATION_JSON, (File)f);
                    return restEntity;
                }
                if (b != 60) continue;
                RestEntity restEntity = RestEntity.create((MediaType)MediaType.APPLICATION_XML, (File)f);
                return restEntity;
            }
        }
        return RestEntity.create((MediaType)MediaType.APPLICATION_OCTET_STREAM, (File)f);
    }

    RestClientConfigurationBuilder getBuilder() {
        return this.builder;
    }

    public String toString() {
        return this.serverInfo;
    }
}

