/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cli.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.aesh.command.AeshCommandRuntimeBuilder;
import org.aesh.command.Command;
import org.aesh.command.CommandException;
import org.aesh.command.CommandNotFoundException;
import org.aesh.command.CommandRuntime;
import org.aesh.command.impl.registry.AeshCommandRegistryBuilder;
import org.aesh.command.parser.CommandLineParserException;
import org.aesh.command.registry.CommandRegistryException;
import org.aesh.command.validator.CommandValidatorException;
import org.aesh.command.validator.OptionValidatorException;

public class CliRuntimeRunner {
    private Class<? extends Command> command;
    private List<Class<? extends Command>> subCommands = new ArrayList<Class<? extends Command>>();
    private CommandRuntime runtime;
    private String[] args;

    private CliRuntimeRunner() {
    }

    public static CliRuntimeRunner builder() {
        return new CliRuntimeRunner();
    }

    public CliRuntimeRunner command(Class<? extends Command> command) {
        this.command = command;
        return this;
    }

    public CliRuntimeRunner subCommand(Class<? extends Command> command) {
        this.subCommands.add(command);
        return this;
    }

    public CliRuntimeRunner commandRuntime(CommandRuntime runtime) {
        this.runtime = runtime;
        return this;
    }

    public CliRuntimeRunner args(String[] args) {
        this.args = args;
        return this;
    }

    public void execute() {
        if (this.command == null && this.runtime == null) {
            throw new RuntimeException("Command needs to be added");
        }
        try {
            String commandName = null;
            if (this.runtime == null) {
                if (this.subCommands.isEmpty()) {
                    this.runtime = AeshCommandRuntimeBuilder.builder().commandRegistry(AeshCommandRegistryBuilder.builder().command(this.command).create()).build();
                } else {
                    commandName = (String)AeshCommandRegistryBuilder.builder().command(this.command).create().getAllCommandNames().iterator().next();
                    AeshCommandRegistryBuilder registryBuilder = AeshCommandRegistryBuilder.builder();
                    registryBuilder.command(this.command);
                    registryBuilder.commands(this.subCommands);
                    this.runtime = AeshCommandRuntimeBuilder.builder().commandRegistry(registryBuilder.create()).build();
                }
            }
            if (commandName == null) {
                commandName = "batch";
            }
            StringBuilder sb = new StringBuilder(commandName);
            if (this.args.length > 0) {
                sb.append(" ");
                if (this.args.length == 1) {
                    sb.append(this.args[0]);
                } else {
                    for (String arg : this.args) {
                        if (arg.indexOf(32) >= 0) {
                            sb.append('\"').append(arg).append("\" ");
                            continue;
                        }
                        sb.append(arg).append(' ');
                    }
                }
            }
            try {
                this.runtime.executeCommand(sb.toString());
            }
            catch (CommandNotFoundException e) {
                System.err.println("Command not found: " + sb.toString());
            }
            catch (CommandException | CommandLineParserException | CommandValidatorException | OptionValidatorException e) {
                CliRuntimeRunner.showHelpIfNeeded(this.runtime, commandName, (Exception)e);
            }
            catch (IOException | InterruptedException e) {
                System.err.println(e.getMessage());
            }
        }
        catch (CommandRegistryException e) {
            throw new RuntimeException("Exception while executing command: " + e.getMessage());
        }
    }

    private static void showHelpIfNeeded(CommandRuntime runtime, String commandName, Exception e) {
        if (e != null) {
            System.err.println(e.getMessage());
        }
        System.err.println(runtime.commandInfo(commandName));
    }
}

