/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cli.commands;

import java.util.List;
import org.aesh.command.CommandDefinition;
import org.aesh.command.CommandResult;
import org.aesh.command.GroupCommandDefinition;
import org.aesh.command.option.Arguments;
import org.infinispan.cli.activators.ConnectionActivator;
import org.infinispan.cli.commands.CliCommand;
import org.infinispan.cli.commands.CommandInputLine;
import org.infinispan.cli.completers.ServerCompleter;
import org.infinispan.cli.impl.ContextAwareCommandInvocation;

@GroupCommandDefinition(name="shutdown", description="Shuts down individual servers or the whole cluster", activator=ConnectionActivator.class, groupCommands={Server.class, Cluster.class})
public class Shutdown
extends CliCommand {
    public static final String CMD = "shutdown";
    public static final String SERVERS = "servers";

    @Override
    public CommandResult exec(ContextAwareCommandInvocation commandInvocation) {
        if (this.help) {
            commandInvocation.println(commandInvocation.getHelpInfo());
        }
        return CommandResult.SUCCESS;
    }

    @CommandDefinition(name="cluster", description="Shuts down the whole cluster", activator=ConnectionActivator.class)
    public static class Cluster
    extends CliCommand {
        public static final String CMD = "cluster";

        @Override
        public CommandResult exec(ContextAwareCommandInvocation invocation) {
            if (this.help) {
                invocation.println(invocation.getHelpInfo());
            }
            CommandInputLine cmd = new CommandInputLine(Shutdown.CMD).arg("type", CMD);
            return invocation.execute(cmd);
        }
    }

    @CommandDefinition(name="server", description="Shuts down one or more individual servers", activator=ConnectionActivator.class)
    public static class Server
    extends CliCommand {
        public static final String CMD = "server";
        @Arguments(completer=ServerCompleter.class)
        List<String> servers;

        @Override
        public CommandResult exec(ContextAwareCommandInvocation invocation) {
            if (this.help) {
                invocation.println(invocation.getHelpInfo());
            }
            CommandInputLine cmd = new CommandInputLine(Shutdown.CMD).arg("type", CMD).arg(Shutdown.SERVERS, this.servers);
            return invocation.execute(cmd);
        }
    }
}

