package org.infinispan.cli.commands;

import org.aesh.command.Command;
import org.aesh.command.CommandDefinition;
import org.aesh.command.CommandResult;
import org.aesh.command.option.Argument;
import org.infinispan.cli.completers.EncodingCompleter;
import org.infinispan.cli.impl.ContextAwareCommandInvocation;
import org.kohsuke.MetaInfServices;

/**
 * @author Tristan Tarrant &lt;tristan@infinispan.org&gt;
 * @since 10.0
 **/
@MetaInfServices(Command.class)
@CommandDefinition(name = Encoding.CMD, description = "Gets/sets the current encoding")
public class Encoding extends CliCommand {
   public static final String CMD = "encoding";

   @Argument(completer = EncodingCompleter.class)
   String encoding;

   @Override
   public CommandResult exec(ContextAwareCommandInvocation invocation) {
      CommandInputLine cmd = new CommandInputLine(CMD);
      if (encoding != null) {
         cmd.arg(TYPE, encoding);
      }
      return invocation.execute(cmd);
   }
}
