/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cli.commands;

import java.util.List;
import org.aesh.command.CommandDefinition;
import org.aesh.command.CommandResult;
import org.aesh.command.impl.completer.FileOptionCompleter;
import org.aesh.command.option.Arguments;
import org.aesh.command.option.Option;
import org.aesh.io.Resource;
import org.infinispan.cli.activators.ConnectionActivator;
import org.infinispan.cli.commands.CliCommand;
import org.infinispan.cli.commands.CommandInputLine;
import org.infinispan.cli.completers.CacheCompleter;
import org.infinispan.cli.completers.EncodingCompleter;
import org.infinispan.cli.impl.ContextAwareCommandInvocation;
import org.infinispan.cli.logging.Messages;

@CommandDefinition(name="put", description="Puts an entry into the cache", activator=ConnectionActivator.class)
public class Put
extends CliCommand {
    public static final String CMD = "put";
    public static final String ENCODING = "encoding";
    public static final String TTL = "ttl";
    public static final String MAX_IDLE = "max-idle";
    public static final String IF_ABSENT = "if-absent";
    @Arguments(required=true)
    List<String> args;
    @Option(completer=EncodingCompleter.class, shortName=101)
    String encoding;
    @Option(completer=CacheCompleter.class, shortName=99)
    String cache;
    @Option(completer=FileOptionCompleter.class, shortName=102)
    Resource file;
    @Option(shortName=108, defaultValue={"0"})
    long ttl;
    @Option(name="max-idle", shortName=105, defaultValue={"0"})
    long maxIdle;
    @Option(name="if-absent", shortName=97)
    boolean ifAbsent;

    @Override
    public CommandResult exec(ContextAwareCommandInvocation invocation) {
        if (this.file != null && this.args.size() != 1) {
            throw Messages.MSG.illegalCommandArguments();
        }
        if (this.file == null && this.args.size() != 2) {
            throw Messages.MSG.illegalCommandArguments();
        }
        CommandInputLine cmd = new CommandInputLine(CMD).arg("key", this.args.get(0)).optionalArg("value", this.args.size() > 1 ? this.args.get(1) : null).option("file", this.file != null ? this.file.getAbsolutePath() : null).option(ENCODING, this.encoding).option("cache", this.cache).option(TTL, this.ttl).option(MAX_IDLE, this.maxIdle).option(IF_ABSENT, this.ifAbsent);
        return invocation.execute(cmd);
    }
}

