/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cli.impl;

import java.io.Console;
import java.io.IOException;
import java.nio.file.AccessDeniedException;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.aesh.command.CommandResult;
import org.aesh.command.invocation.CommandInvocation;
import org.aesh.command.registry.CommandRegistry;
import org.aesh.command.shell.Shell;
import org.aesh.io.FileResource;
import org.aesh.io.Resource;
import org.aesh.readline.AeshContext;
import org.aesh.readline.Prompt;
import org.aesh.readline.ReadlineConsole;
import org.aesh.readline.terminal.formatting.Color;
import org.aesh.readline.terminal.formatting.TerminalColor;
import org.aesh.readline.terminal.formatting.TerminalString;
import org.infinispan.cli.Context;
import org.infinispan.cli.commands.CommandInputLine;
import org.infinispan.cli.connection.Connection;
import org.infinispan.cli.connection.ConnectionFactory;
import org.infinispan.cli.impl.ConfigImpl;
import org.infinispan.cli.impl.SSLContextSettings;
import org.infinispan.cli.logging.Messages;
import org.infinispan.cli.util.SystemUtils;
import org.infinispan.commons.util.Util;
import org.infinispan.commons.util.Version;

public class ContextImpl
implements Context,
AeshContext {
    private final ConfigImpl config;
    private Connection connection;
    private final Properties properties;
    private Resource cwd;
    private ReadlineConsole console;
    private SSLContextSettings sslContext;
    private CommandRegistry<? extends CommandInvocation> registry;

    public ContextImpl(Properties properties) {
        this.properties = properties;
        String userDir = properties.getProperty("user.dir");
        this.cwd = userDir != null ? new FileResource(userDir) : null;
        this.config = new ConfigImpl(SystemUtils.getAppConfigFolder(Version.getBrandName().toLowerCase().replace(' ', '_')));
        this.config.load();
    }

    @Override
    public boolean isConnected() {
        return this.connection != null && this.connection.isConnected();
    }

    @Override
    public void setProperty(String key, String value) {
        this.properties.setProperty(key, value);
    }

    @Override
    public String getProperty(String key) {
        return this.properties.getProperty(key);
    }

    @Override
    public void setSslContext(SSLContextSettings sslContext) {
        this.sslContext = sslContext;
    }

    @Override
    public Connection connect(Shell shell, String connectionString) {
        this.disconnect();
        this.connection = ConnectionFactory.getConnection(connectionString, this.sslContext);
        try {
            this.connection.connect();
        }
        catch (AccessDeniedException accessDenied) {
            try {
                Util.close((AutoCloseable)this.connection);
                String username = null;
                String password = null;
                if (shell != null) {
                    username = shell.readLine(Messages.MSG.username());
                    password = username.isEmpty() ? null : shell.readLine(new Prompt(Messages.MSG.password(), Character.valueOf('*')));
                } else {
                    Console sysConsole = System.console();
                    if (sysConsole != null) {
                        username = sysConsole.readLine(Messages.MSG.username(), new Object[0]);
                        password = username.isEmpty() ? null : new String(sysConsole.readPassword(Messages.MSG.password(), new Object[0]));
                    }
                }
                this.connection.connect(username, password);
            }
            catch (Exception e) {
                this.disconnect();
                this.showError(shell, e);
            }
        }
        catch (IOException e) {
            this.disconnect();
            this.showError(shell, e);
        }
        this.refreshPrompt();
        return this.connection;
    }

    private void showError(Shell shell, Throwable t) {
        if (shell != null) {
            shell.writeln(t.getMessage());
        } else {
            System.err.println(t.getMessage());
        }
    }

    @Override
    public Connection connect(Shell shell, String connectionString, String username, String password) {
        this.disconnect();
        this.connection = ConnectionFactory.getConnection(connectionString, this.sslContext);
        try {
            this.connection.connect(username, password);
        }
        catch (IOException e) {
            if (shell != null) {
                shell.writeln("\u001b[0;31m" + e.getMessage() + "\u001b[0;39m");
            }
            System.err.println(e.getMessage());
        }
        this.refreshPrompt();
        return this.connection;
    }

    private void buildPrompt(org.infinispan.cli.resources.Resource resource, StringBuilder builder) {
        if (resource != null) {
            if (resource.getParent() != null) {
                this.buildPrompt(resource.getParent(), builder);
            }
            builder.append("/").append(resource.getName());
        }
    }

    private void refreshPrompt() {
        if (this.console != null) {
            if (this.connection != null) {
                StringBuilder prompt = new StringBuilder();
                prompt.append("[").append("\u001b[0;32m").append(this.connection.getConnectionInfo()).append("\u001b[0;39m");
                this.buildPrompt(this.connection.getActiveResource(), prompt);
                prompt.append("]> ");
                this.console.setPrompt(prompt.toString());
            } else {
                this.console.setPrompt("[\u001b[0;33mdisconnected\u001b[0;39m]> ");
            }
        }
    }

    @Override
    public void disconnect() {
        if (this.connection != null) {
            Util.close((AutoCloseable)this.connection);
            this.connection = null;
        }
        this.refreshPrompt();
    }

    @Override
    public CommandResult execute(Shell shell, List<CommandInputLine> commands) {
        try {
            String response = this.connection.execute(commands);
            if (response != null && !response.isEmpty()) {
                shell.writeln(response);
            }
            this.refreshPrompt();
            return CommandResult.SUCCESS;
        }
        catch (Exception e) {
            TerminalString error = new TerminalString(e.getMessage(), new TerminalColor(Color.RED, Color.DEFAULT, Color.Intensity.BRIGHT));
            shell.writeln(error.toString());
            this.refreshPrompt();
            return CommandResult.FAILURE;
        }
    }

    @Override
    public void setConsole(ReadlineConsole console) {
        this.console = console;
        this.refreshPrompt();
    }

    @Override
    public CommandRegistry<? extends CommandInvocation> getRegistry() {
        return this.registry;
    }

    @Override
    public void setRegistry(CommandRegistry<? extends CommandInvocation> registry) {
        this.registry = registry;
    }

    @Override
    public Connection getConnection() {
        return this.connection;
    }

    public Resource getCurrentWorkingDirectory() {
        return this.cwd;
    }

    public void setCurrentWorkingDirectory(Resource cwd) {
        this.cwd = cwd;
    }

    public Set<String> exportedVariableNames() {
        return Collections.emptySet();
    }

    public String exportedVariable(String key) {
        return null;
    }
}

