/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cli.logging;

import java.io.IOException;
import java.io.Serializable;
import java.net.ConnectException;
import java.nio.file.AccessDeniedException;
import java.util.Arrays;
import java.util.Locale;
import org.infinispan.cli.logging.Messages;

public class Messages_$bundle
implements Messages,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final Messages_$bundle INSTANCE = new Messages_$bundle();
    private static final Locale LOCALE = Locale.ROOT;
    private static final String unknownArgument = "ISPN090001: Unrecognized command-line argument `%s`.";
    private static final String invalidArgument = "ISPN090002: Invalid argument `%s`. Arguments must be prefixed with either - or --.";
    private static final String invalidShortArgument = "ISPN090003: Invalid argument `%s`. The - prefix must be used only for single-character arguments.";
    private static final String username = "Username: ";
    private static final String password = "Password: ";
    private static final String cliHelpHelp = "Displays usage information and exits.";
    private static final String cliHelpVersion = "Displays version information and exits.";
    private static final String fileNotExists = "File '%s' doesn't exist or is not a file";
    private static final String cliHelpConnect = "Connects to a remote %s instance\n";
    private static final String cliHelpConnectHTTP = "Server HTTP http://[username[:password]]@host:port";
    private static final String cliHelpFile = "Reads input from the specified file instead of using interactive mode. If FILE is '-', then commands will be read from stdin.";
    private static final String cliHelpTruststorePassword = "The password of an optional truststore to be used for SSL/TLS connections.";
    private static final String cliHelpTruststore = "The path of an optional truststore to be used for SSL/TLS connections.";
    private static final String cliHelpTrustAll = "Trusts all certificates in SSL/TLS connections.";
    private static final String notFound = "Not Found %s";
    private static final String unauthorized = "The supplied credentials are invalid %s";
    private static final String error = "Error: %s";
    private static final String forbidden = "The user is not allowed to access the server resource: %s";
    private static final String keyStoreError = "Error while loading trust store '%s'";
    private static final String noSuchResource = "No such resource '%s'";
    private static final String illegalContext = "Command invoked from the wrong context";
    private static final String illegalCommandArguments = "Illegal arguments for command";
    private static final String mutuallyExclusiveOptions = "The options '%s' and '%s' are mutually exclusive";
    private static final String requiresOneOf = "One of the '%s' and '%s' options are required";
    private static final String connectionFailed = "Could not connect to server: %s";

    protected Messages_$bundle() {
    }

    protected Object readResolve() {
        return INSTANCE;
    }

    protected Locale getLoggingLocale() {
        return LOCALE;
    }

    protected String unknownArgument$str() {
        return unknownArgument;
    }

    @Override
    public final String unknownArgument(String argument) {
        return String.format(this.getLoggingLocale(), this.unknownArgument$str(), argument);
    }

    protected String invalidArgument$str() {
        return invalidArgument;
    }

    @Override
    public final String invalidArgument(String argument) {
        return String.format(this.getLoggingLocale(), this.invalidArgument$str(), argument);
    }

    protected String invalidShortArgument$str() {
        return invalidShortArgument;
    }

    @Override
    public final String invalidShortArgument(String command) {
        return String.format(this.getLoggingLocale(), this.invalidShortArgument$str(), command);
    }

    protected String username$str() {
        return username;
    }

    @Override
    public final String username() {
        return String.format(this.getLoggingLocale(), this.username$str(), new Object[0]);
    }

    protected String password$str() {
        return password;
    }

    @Override
    public final String password() {
        return String.format(this.getLoggingLocale(), this.password$str(), new Object[0]);
    }

    protected String cliHelpHelp$str() {
        return cliHelpHelp;
    }

    @Override
    public final String cliHelpHelp() {
        return String.format(this.getLoggingLocale(), this.cliHelpHelp$str(), new Object[0]);
    }

    protected String cliHelpVersion$str() {
        return cliHelpVersion;
    }

    @Override
    public final String cliHelpVersion() {
        return String.format(this.getLoggingLocale(), this.cliHelpVersion$str(), new Object[0]);
    }

    protected String fileNotExists$str() {
        return fileNotExists;
    }

    @Override
    public final String fileNotExists(String inputFile) {
        return String.format(this.getLoggingLocale(), this.fileNotExists$str(), inputFile);
    }

    protected String cliHelpConnect$str() {
        return cliHelpConnect;
    }

    @Override
    public final String cliHelpConnect(String brandName) {
        return String.format(this.getLoggingLocale(), this.cliHelpConnect$str(), brandName);
    }

    protected String cliHelpConnectHTTP$str() {
        return cliHelpConnectHTTP;
    }

    @Override
    public final String cliHelpConnectHTTP() {
        return String.format(this.getLoggingLocale(), this.cliHelpConnectHTTP$str(), new Object[0]);
    }

    protected String cliHelpFile$str() {
        return cliHelpFile;
    }

    @Override
    public final String cliHelpFile() {
        return String.format(this.getLoggingLocale(), this.cliHelpFile$str(), new Object[0]);
    }

    protected String cliHelpTruststorePassword$str() {
        return cliHelpTruststorePassword;
    }

    @Override
    public final String cliHelpTruststorePassword() {
        return String.format(this.getLoggingLocale(), this.cliHelpTruststorePassword$str(), new Object[0]);
    }

    protected String cliHelpTruststore$str() {
        return cliHelpTruststore;
    }

    @Override
    public final String cliHelpTruststore() {
        return String.format(this.getLoggingLocale(), this.cliHelpTruststore$str(), new Object[0]);
    }

    protected String cliHelpTrustAll$str() {
        return cliHelpTrustAll;
    }

    @Override
    public final String cliHelpTrustAll() {
        return String.format(this.getLoggingLocale(), this.cliHelpTrustAll$str(), new Object[0]);
    }

    protected String notFound$str() {
        return notFound;
    }

    @Override
    public final IOException notFound(String s) {
        IOException result = new IOException(String.format(this.getLoggingLocale(), this.notFound$str(), s));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unauthorized$str() {
        return unauthorized;
    }

    @Override
    public final AccessDeniedException unauthorized(String s) {
        AccessDeniedException result = new AccessDeniedException(String.format(this.getLoggingLocale(), this.unauthorized$str(), s));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String error$str() {
        return error;
    }

    @Override
    public final IOException error(String s) {
        IOException result = new IOException(String.format(this.getLoggingLocale(), this.error$str(), s));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String forbidden$str() {
        return forbidden;
    }

    @Override
    public final AccessDeniedException forbidden(String s) {
        AccessDeniedException result = new AccessDeniedException(String.format(this.getLoggingLocale(), this.forbidden$str(), s));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String keyStoreError$str() {
        return keyStoreError;
    }

    @Override
    public final String keyStoreError(String trustStorePath, Exception e) {
        return String.format(this.getLoggingLocale(), this.keyStoreError$str(), trustStorePath);
    }

    protected String noSuchResource$str() {
        return noSuchResource;
    }

    @Override
    public final IllegalArgumentException noSuchResource(String name) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.noSuchResource$str(), name));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String illegalContext$str() {
        return illegalContext;
    }

    @Override
    public final IllegalStateException illegalContext() {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.illegalContext$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String illegalCommandArguments$str() {
        return illegalCommandArguments;
    }

    @Override
    public final IllegalArgumentException illegalCommandArguments() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.illegalCommandArguments$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String mutuallyExclusiveOptions$str() {
        return mutuallyExclusiveOptions;
    }

    @Override
    public final IllegalArgumentException mutuallyExclusiveOptions(String arg1, String arg2) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.mutuallyExclusiveOptions$str(), arg1, arg2));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String requiresOneOf$str() {
        return requiresOneOf;
    }

    @Override
    public final IllegalArgumentException requiresOneOf(String arg1, String arg2) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.requiresOneOf$str(), arg1, arg2));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String connectionFailed$str() {
        return connectionFailed;
    }

    @Override
    public final ConnectException connectionFailed(String message) {
        ConnectException result = new ConnectException(String.format(this.getLoggingLocale(), this.connectionFailed$str(), message));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
}

