/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cli.logging;

import java.io.IOException;
import java.net.ConnectException;
import java.nio.file.AccessDeniedException;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageBundle;

@MessageBundle(projectCode="ISPN")
public interface Messages {
    public static final Messages MSG = (Messages)org.jboss.logging.Messages.getBundle(Messages.class);

    @Message(value="Unrecognized command-line argument `%s`.", id=90001)
    public String unknownArgument(String var1);

    @Message(value="Invalid argument `%s`. Arguments must be prefixed with either - or --.", id=90002)
    public String invalidArgument(String var1);

    @Message(value="Invalid argument `%s`. The - prefix must be used only for single-character arguments.", id=90003)
    public String invalidShortArgument(String var1);

    @Message(value="Username: ")
    public String username();

    @Message(value="Password: ")
    public String password();

    @Message(value="Displays usage information and exits.")
    public String cliHelpHelp();

    @Message(value="Displays version information and exits.")
    public String cliHelpVersion();

    @Message(value="File '%s' doesn't exist or is not a file")
    public String fileNotExists(String var1);

    @Message(value="Connects to a remote %s instance\n")
    public String cliHelpConnect(String var1);

    @Message(value="Server HTTP http://[username[:password]]@host:port")
    public String cliHelpConnectHTTP();

    @Message(value="Reads input from the specified file instead of using interactive mode. If FILE is '-', then commands will be read from stdin.")
    public String cliHelpFile();

    @Message(value="The password of an optional truststore to be used for SSL/TLS connections.")
    public String cliHelpTruststorePassword();

    @Message(value="The path of an optional truststore to be used for SSL/TLS connections.")
    public String cliHelpTruststore();

    @Message(value="Trusts all certificates in SSL/TLS connections.")
    public String cliHelpTrustAll();

    @Message(value="Not Found %s")
    public IOException notFound(String var1);

    @Message(value="The supplied credentials are invalid %s")
    public AccessDeniedException unauthorized(String var1);

    @Message(value="Error: %s")
    public IOException error(String var1);

    @Message(value="The user is not allowed to access the server resource: %s")
    public AccessDeniedException forbidden(String var1);

    @Message(value="Error while loading trust store '%s'")
    public String keyStoreError(String var1, @Cause Exception var2);

    @Message(value="No such resource '%s'")
    public IllegalArgumentException noSuchResource(String var1);

    @Message(value="Command invoked from the wrong context")
    public IllegalStateException illegalContext();

    @Message(value="Illegal arguments for command")
    public IllegalArgumentException illegalCommandArguments();

    @Message(value="The options '%s' and '%s' are mutually exclusive")
    public IllegalArgumentException mutuallyExclusiveOptions(String var1, String var2);

    @Message(value="One of the '%s' and '%s' options are required")
    public IllegalArgumentException requiresOneOf(String var1, String var2);

    @Message(value="Could not connect to server: %s")
    public ConnectException connectionFailed(String var1);

    @Message(value="Invalid resource '%s'")
    public IllegalArgumentException invalidResource(String var1);
}

