package org.infinispan.cli.logging;

import java.util.Locale;
import java.nio.file.Path;
import java.lang.IllegalStateException;
import java.io.Serializable;
import java.nio.file.AccessDeniedException;
import java.nio.file.FileAlreadyExistsException;
import javax.annotation.Generated;
import org.infinispan.cli.patching.PatchInfo;
import java.lang.String;
import java.io.IOException;
import java.lang.Exception;
import java.lang.RuntimeException;
import org.infinispan.cli.patching.PatchOperation;
import java.util.Arrays;
import java.lang.IllegalArgumentException;
import java.net.ConnectException;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageBundleImplementor", date = "2020-05-07T09:15:05-0400")
public class Messages_$bundle implements Messages, Serializable {
    private static final long serialVersionUID = 1L;
    protected Messages_$bundle() {}
    public static final Messages_$bundle INSTANCE = new Messages_$bundle();
    protected Object readResolve() {
        return INSTANCE;
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    private static final String unknownArgument = "ISPN090001: Unrecognized command-line argument `%s`.";
    protected String unknownArgument$str() {
        return unknownArgument;
    }
    @Override
    public final String unknownArgument(final String argument) {
        return String.format(getLoggingLocale(), unknownArgument$str(), argument);
    }
    private static final String invalidArgument = "ISPN090002: Invalid argument `%s`. Arguments must be prefixed with either - or --.";
    protected String invalidArgument$str() {
        return invalidArgument;
    }
    @Override
    public final String invalidArgument(final String argument) {
        return String.format(getLoggingLocale(), invalidArgument$str(), argument);
    }
    private static final String invalidShortArgument = "ISPN090003: Invalid argument `%s`. The - prefix must be used only for single-character arguments.";
    protected String invalidShortArgument$str() {
        return invalidShortArgument;
    }
    @Override
    public final String invalidShortArgument(final String command) {
        return String.format(getLoggingLocale(), invalidShortArgument$str(), command);
    }
    private static final String username = "Username: ";
    protected String username$str() {
        return username;
    }
    @Override
    public final String username() {
        return String.format(getLoggingLocale(), username$str());
    }
    private static final String password = "Password: ";
    protected String password$str() {
        return password;
    }
    @Override
    public final String password() {
        return String.format(getLoggingLocale(), password$str());
    }
    private static final String cliHelpHelp = "Displays usage information and exits.";
    protected String cliHelpHelp$str() {
        return cliHelpHelp;
    }
    @Override
    public final String cliHelpHelp() {
        return String.format(getLoggingLocale(), cliHelpHelp$str());
    }
    private static final String cliHelpVersion = "Displays version information and exits.";
    protected String cliHelpVersion$str() {
        return cliHelpVersion;
    }
    @Override
    public final String cliHelpVersion() {
        return String.format(getLoggingLocale(), cliHelpVersion$str());
    }
    private static final String fileNotExists = "File '%s' doesn't exist or is not a file";
    protected String fileNotExists$str() {
        return fileNotExists;
    }
    @Override
    public final String fileNotExists(final String inputFile) {
        return String.format(getLoggingLocale(), fileNotExists$str(), inputFile);
    }
    private static final String cliHelpConnect = "Connects to a remote %s instance\n";
    protected String cliHelpConnect$str() {
        return cliHelpConnect;
    }
    @Override
    public final String cliHelpConnect(final String brandName) {
        return String.format(getLoggingLocale(), cliHelpConnect$str(), brandName);
    }
    private static final String cliHelpConnectHTTP = "Server HTTP http://[username[:password]]@host:port";
    protected String cliHelpConnectHTTP$str() {
        return cliHelpConnectHTTP;
    }
    @Override
    public final String cliHelpConnectHTTP() {
        return String.format(getLoggingLocale(), cliHelpConnectHTTP$str());
    }
    private static final String cliHelpFile = "Reads input from the specified file instead of using interactive mode. If FILE is '-', then commands will be read from stdin.";
    protected String cliHelpFile$str() {
        return cliHelpFile;
    }
    @Override
    public final String cliHelpFile() {
        return String.format(getLoggingLocale(), cliHelpFile$str());
    }
    private static final String cliHelpTruststorePassword = "The password of an optional truststore to be used for SSL/TLS connections.";
    protected String cliHelpTruststorePassword$str() {
        return cliHelpTruststorePassword;
    }
    @Override
    public final String cliHelpTruststorePassword() {
        return String.format(getLoggingLocale(), cliHelpTruststorePassword$str());
    }
    private static final String cliHelpTruststore = "The path of an optional truststore to be used for SSL/TLS connections.";
    protected String cliHelpTruststore$str() {
        return cliHelpTruststore;
    }
    @Override
    public final String cliHelpTruststore() {
        return String.format(getLoggingLocale(), cliHelpTruststore$str());
    }
    private static final String cliHelpTrustAll = "Trusts all certificates in SSL/TLS connections.";
    protected String cliHelpTrustAll$str() {
        return cliHelpTrustAll;
    }
    @Override
    public final String cliHelpTrustAll() {
        return String.format(getLoggingLocale(), cliHelpTrustAll$str());
    }
    private static final String notFound = "Not Found %s";
    protected String notFound$str() {
        return notFound;
    }
    @Override
    public final IOException notFound(final String s) {
        final IOException result = new IOException(String.format(getLoggingLocale(), notFound$str(), s));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unauthorized = "The supplied credentials are invalid %s";
    protected String unauthorized$str() {
        return unauthorized;
    }
    @Override
    public final AccessDeniedException unauthorized(final String s) {
        final AccessDeniedException result = new AccessDeniedException(String.format(getLoggingLocale(), unauthorized$str(), s));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String error = "Error: %s";
    protected String error$str() {
        return error;
    }
    @Override
    public final IOException error(final String s) {
        final IOException result = new IOException(String.format(getLoggingLocale(), error$str(), s));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String forbidden = "The user is not allowed to access the server resource: %s";
    protected String forbidden$str() {
        return forbidden;
    }
    @Override
    public final AccessDeniedException forbidden(final String s) {
        final AccessDeniedException result = new AccessDeniedException(String.format(getLoggingLocale(), forbidden$str(), s));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String keyStoreError = "Error while loading trust store '%s'";
    protected String keyStoreError$str() {
        return keyStoreError;
    }
    @Override
    public final String keyStoreError(final String trustStorePath, final Exception e) {
        return String.format(getLoggingLocale(), keyStoreError$str(), trustStorePath);
    }
    private static final String noSuchResource = "No such resource '%s'";
    protected String noSuchResource$str() {
        return noSuchResource;
    }
    @Override
    public final IllegalArgumentException noSuchResource(final String name) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), noSuchResource$str(), name));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String illegalContext = "Command invoked from the wrong context";
    protected String illegalContext$str() {
        return illegalContext;
    }
    @Override
    public final IllegalStateException illegalContext() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), illegalContext$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String illegalCommandArguments = "Illegal arguments for command";
    protected String illegalCommandArguments$str() {
        return illegalCommandArguments;
    }
    @Override
    public final IllegalArgumentException illegalCommandArguments() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), illegalCommandArguments$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mutuallyExclusiveOptions = "The options '%s' and '%s' are mutually exclusive";
    protected String mutuallyExclusiveOptions$str() {
        return mutuallyExclusiveOptions;
    }
    @Override
    public final IllegalArgumentException mutuallyExclusiveOptions(final String arg1, final String arg2) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), mutuallyExclusiveOptions$str(), arg1, arg2));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String requiresOneOf = "One of the '%s' and '%s' options are required";
    protected String requiresOneOf$str() {
        return requiresOneOf;
    }
    @Override
    public final IllegalArgumentException requiresOneOf(final String arg1, final String arg2) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), requiresOneOf$str(), arg1, arg2));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String connectionFailed = "Could not connect to server: %s";
    protected String connectionFailed$str() {
        return connectionFailed;
    }
    @Override
    public final ConnectException connectionFailed(final String message) {
        final ConnectException result = new ConnectException(String.format(getLoggingLocale(), connectionFailed$str(), message));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidResource = "Invalid resource '%s'";
    protected String invalidResource$str() {
        return invalidResource;
    }
    @Override
    public final IllegalArgumentException invalidResource(final String name) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), invalidResource$str(), name));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String patchNoPatchesInstalled = "No patches installed";
    protected String patchNoPatchesInstalled$str() {
        return patchNoPatchesInstalled;
    }
    @Override
    public final String patchNoPatchesInstalled() {
        return String.format(getLoggingLocale(), patchNoPatchesInstalled$str());
    }
    private static final String patchInfo = "%s";
    protected String patchInfo$str() {
        return patchInfo;
    }
    @Override
    public final String patchInfo(final PatchInfo patchInfo) {
        return String.format(getLoggingLocale(), patchInfo$str(), patchInfo);
    }
    private static final String patchCannotApply = "The supplied patch cannot be applied to %s %s";
    protected String patchCannotApply$str() {
        return patchCannotApply;
    }
    @Override
    public final IllegalStateException patchCannotApply(final String brandName, final String version) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), patchCannotApply$str(), brandName, version));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String patchShaMismatch = "File %s SHA mismatch. Expected = %s, Actual = %s";
    protected String patchShaMismatch$str() {
        return patchShaMismatch;
    }
    @Override
    public final String patchShaMismatch(final Path path, final String digest, final String sha256) {
        return String.format(getLoggingLocale(), patchShaMismatch$str(), path, digest, sha256);
    }
    private static final String patchValidationErrors = "The following errors were encountered while validating the installation:%n%s";
    protected String patchValidationErrors$str() {
        return patchValidationErrors;
    }
    @Override
    public final IllegalStateException patchValidationErrors(final String errors) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), patchValidationErrors$str(), errors));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String patchNoPatchesInstalledToRollback = "No installed patches to roll back";
    protected String patchNoPatchesInstalledToRollback$str() {
        return patchNoPatchesInstalledToRollback;
    }
    @Override
    public final IllegalStateException patchNoPatchesInstalledToRollback() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), patchNoPatchesInstalledToRollback$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String patchCannotFindCommons = "Cannot find the infinispan-commons jar under %s";
    protected String patchCannotFindCommons$str() {
        return patchCannotFindCommons;
    }
    @Override
    public final IllegalStateException patchCannotFindCommons(final Path lib) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), patchCannotFindCommons$str(), lib));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String patchIncompatibleProduct = "Cannot create patch %s with patches for %s";
    protected String patchIncompatibleProduct$str() {
        return patchIncompatibleProduct;
    }
    @Override
    public final IllegalStateException patchIncompatibleProduct(final String localBrand, final String patchBrand) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), patchIncompatibleProduct$str(), localBrand, patchBrand));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String patchCannotWritePatchesFile = "Could not write patches file";
    protected String patchCannotWritePatchesFile$str() {
        return patchCannotWritePatchesFile;
    }
    @Override
    public final IllegalStateException patchCannotWritePatchesFile(final IOException e) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), patchCannotWritePatchesFile$str()), e);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String patchRollback = "Rolled back patch %s";
    protected String patchRollback$str() {
        return patchRollback;
    }
    @Override
    public final String patchRollback(final PatchInfo patchInfo) {
        return String.format(getLoggingLocale(), patchRollback$str(), patchInfo);
    }
    private static final String patchDryRun = "[Dry run] ";
    protected String patchDryRun$str() {
        return patchDryRun;
    }
    @Override
    public final String patchDryRun() {
        return String.format(getLoggingLocale(), patchDryRun$str());
    }
    private static final String patchBackup = "Backing up '%s' to '%s'";
    protected String patchBackup$str() {
        return patchBackup;
    }
    @Override
    public final String patchBackup(final Path from, final Path to) {
        return String.format(getLoggingLocale(), patchBackup$str(), from, to);
    }
    private static final String patchCreateError = "Error while creating patch";
    protected String patchCreateError$str() {
        return patchCreateError;
    }
    @Override
    public final RuntimeException patchCreateError(final IOException e) {
        final RuntimeException result = new RuntimeException(String.format(getLoggingLocale(), patchCreateError$str()), e);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String patchCreateAdd = "Adding file '%s'";
    protected String patchCreateAdd$str() {
        return patchCreateAdd;
    }
    @Override
    public final String patchCreateAdd(final Path target) {
        return String.format(getLoggingLocale(), patchCreateAdd$str(), target);
    }
    private static final String patchRollbackFile = "Rolling back file '%s'";
    protected String patchRollbackFile$str() {
        return patchRollbackFile;
    }
    @Override
    public final String patchRollbackFile(final Path file) {
        return String.format(getLoggingLocale(), patchRollbackFile$str(), file);
    }
    private static final String patchCannotRead = "Could not read %s";
    protected String patchCannotRead$str() {
        return patchCannotRead;
    }
    @Override
    public final IllegalStateException patchCannotRead(final Path patchesFile, final IOException e) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), patchCannotRead$str(), patchesFile), e);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String patchFileAlreadyExists = "File '%s' already exists";
    protected String patchFileAlreadyExists$str() {
        return patchFileAlreadyExists;
    }
    @Override
    public final FileAlreadyExistsException patchFileAlreadyExists(final Path patch) {
        final FileAlreadyExistsException result = new FileAlreadyExistsException(String.format(getLoggingLocale(), patchFileAlreadyExists$str(), patch));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String patchCreateArgumentsRequired = "At least three arguments are required: the patch file, the target server path and one or more source server paths";
    protected String patchCreateArgumentsRequired$str() {
        return patchCreateArgumentsRequired;
    }
    @Override
    public final IllegalArgumentException patchCreateArgumentsRequired() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), patchCreateArgumentsRequired$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String patchArchiveArgumentRequired = "You must specify the path to a patch archive";
    protected String patchArchiveArgumentRequired$str() {
        return patchArchiveArgumentRequired;
    }
    @Override
    public final IllegalArgumentException patchArchiveArgumentRequired() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), patchArchiveArgumentRequired$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String patchServerAndTargetMustBeDifferent = "Cannot create a patch from identical source and target server versions: %s";
    protected String patchServerAndTargetMustBeDifferent$str() {
        return patchServerAndTargetMustBeDifferent;
    }
    @Override
    public final IllegalArgumentException patchServerAndTargetMustBeDifferent(final String version) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), patchServerAndTargetMustBeDifferent$str(), version));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String patchCorruptArchive = "The patch archive appears to have a corrupt entry for: %s";
    protected String patchCorruptArchive$str() {
        return patchCorruptArchive;
    }
    @Override
    public final String patchCorruptArchive(final PatchOperation operation) {
        return String.format(getLoggingLocale(), patchCorruptArchive$str(), operation);
    }
}
