/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cli.commands;

import java.util.Collections;
import java.util.Map;
import org.aesh.command.CommandDefinition;
import org.aesh.command.CommandResult;
import org.aesh.command.GroupCommandDefinition;
import org.aesh.command.impl.completer.FileOptionCompleter;
import org.aesh.command.option.Argument;
import org.aesh.command.option.Option;
import org.aesh.command.option.OptionGroup;
import org.aesh.io.Resource;
import org.infinispan.cli.activators.ConnectionActivator;
import org.infinispan.cli.commands.CliCommand;
import org.infinispan.cli.commands.CommandInputLine;
import org.infinispan.cli.completers.TaskCompleter;
import org.infinispan.cli.impl.ContextAwareCommandInvocation;

@GroupCommandDefinition(name="task", description="Executes or manipulates server-side tasks", activator=ConnectionActivator.class, groupCommands={Exec.class, Upload.class})
public class Task
extends CliCommand {
    public static final String CMD = "task";

    @Override
    public CommandResult exec(ContextAwareCommandInvocation commandInvocation) {
        if (this.help) {
            commandInvocation.println(commandInvocation.getHelpInfo());
        }
        return CommandResult.SUCCESS;
    }

    @CommandDefinition(name="upload", description="Uploads a new script task to the server", activator=ConnectionActivator.class)
    public static class Upload
    extends CliCommand {
        public static final String CMD = "upload";
        @Argument(description="The task name")
        String taskName;
        @Option(completer=FileOptionCompleter.class, shortName=102, required=true)
        Resource file;

        @Override
        public CommandResult exec(ContextAwareCommandInvocation invocation) {
            if (this.help) {
                invocation.println(invocation.getHelpInfo());
            }
            CommandInputLine cmd = new CommandInputLine(Task.CMD).arg("type", CMD).arg("name", this.taskName).option("file", this.file.getAbsolutePath());
            return invocation.execute(cmd);
        }
    }

    @CommandDefinition(name="exec", description="Executes a server-side task", activator=ConnectionActivator.class)
    public static class Exec
    extends CliCommand {
        public static final String CMD = "exec";
        public static final String PARAMETERS = "parameters";
        @Argument(completer=TaskCompleter.class)
        String taskName;
        @OptionGroup(shortName=80, description="Task parameters")
        Map<String, String> parameters;

        @Override
        public CommandResult exec(ContextAwareCommandInvocation invocation) {
            if (this.help) {
                invocation.println(invocation.getHelpInfo());
            }
            CommandInputLine cmd = new CommandInputLine(Task.CMD).arg("type", CMD).arg("name", this.taskName).arg(PARAMETERS, this.parameters == null ? Collections.emptyMap() : this.parameters);
            return invocation.execute(cmd);
        }
    }
}

