package org.infinispan.cli.logging;

import java.util.Locale;
import java.lang.IllegalStateException;
import java.io.Serializable;
import java.nio.file.AccessDeniedException;
import javax.annotation.Generated;
import java.lang.String;
import java.io.IOException;
import java.util.Arrays;
import java.lang.Exception;
import java.lang.IllegalArgumentException;
import java.net.ConnectException;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageBundleImplementor", date = "2020-02-11T10:08:06+0000")
public class Messages_$bundle implements Messages, Serializable {
    private static final long serialVersionUID = 1L;
    protected Messages_$bundle() {}
    public static final Messages_$bundle INSTANCE = new Messages_$bundle();
    protected Object readResolve() {
        return INSTANCE;
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    private static final String unknownArgument = "ISPN090001: Unrecognized command-line argument `%s`.";
    protected String unknownArgument$str() {
        return unknownArgument;
    }
    @Override
    public final String unknownArgument(final String argument) {
        return String.format(getLoggingLocale(), unknownArgument$str(), argument);
    }
    private static final String invalidArgument = "ISPN090002: Invalid argument `%s`. Arguments must be prefixed with either - or --.";
    protected String invalidArgument$str() {
        return invalidArgument;
    }
    @Override
    public final String invalidArgument(final String argument) {
        return String.format(getLoggingLocale(), invalidArgument$str(), argument);
    }
    private static final String invalidShortArgument = "ISPN090003: Invalid argument `%s`. The - prefix must be used only for single-character arguments.";
    protected String invalidShortArgument$str() {
        return invalidShortArgument;
    }
    @Override
    public final String invalidShortArgument(final String command) {
        return String.format(getLoggingLocale(), invalidShortArgument$str(), command);
    }
    private static final String username = "Username: ";
    protected String username$str() {
        return username;
    }
    @Override
    public final String username() {
        return String.format(getLoggingLocale(), username$str());
    }
    private static final String password = "Password: ";
    protected String password$str() {
        return password;
    }
    @Override
    public final String password() {
        return String.format(getLoggingLocale(), password$str());
    }
    private static final String cliHelpHelp = "Displays usage information and exits.";
    protected String cliHelpHelp$str() {
        return cliHelpHelp;
    }
    @Override
    public final String cliHelpHelp() {
        return String.format(getLoggingLocale(), cliHelpHelp$str());
    }
    private static final String cliHelpVersion = "Displays version information and exits.";
    protected String cliHelpVersion$str() {
        return cliHelpVersion;
    }
    @Override
    public final String cliHelpVersion() {
        return String.format(getLoggingLocale(), cliHelpVersion$str());
    }
    private static final String fileNotExists = "File '%s' doesn't exist or is not a file";
    protected String fileNotExists$str() {
        return fileNotExists;
    }
    @Override
    public final String fileNotExists(final String inputFile) {
        return String.format(getLoggingLocale(), fileNotExists$str(), inputFile);
    }
    private static final String cliHelpConnect = "Connects to a remote %s instance\n";
    protected String cliHelpConnect$str() {
        return cliHelpConnect;
    }
    @Override
    public final String cliHelpConnect(final String brandName) {
        return String.format(getLoggingLocale(), cliHelpConnect$str(), brandName);
    }
    private static final String cliHelpConnectHTTP = "Server HTTP http://[username[:password]]@host:port";
    protected String cliHelpConnectHTTP$str() {
        return cliHelpConnectHTTP;
    }
    @Override
    public final String cliHelpConnectHTTP() {
        return String.format(getLoggingLocale(), cliHelpConnectHTTP$str());
    }
    private static final String cliHelpFile = "Reads input from the specified file instead of using interactive mode. If FILE is '-', then commands will be read from stdin.";
    protected String cliHelpFile$str() {
        return cliHelpFile;
    }
    @Override
    public final String cliHelpFile() {
        return String.format(getLoggingLocale(), cliHelpFile$str());
    }
    private static final String cliHelpTruststorePassword = "The password of an optional truststore to be used for SSL/TLS connections.";
    protected String cliHelpTruststorePassword$str() {
        return cliHelpTruststorePassword;
    }
    @Override
    public final String cliHelpTruststorePassword() {
        return String.format(getLoggingLocale(), cliHelpTruststorePassword$str());
    }
    private static final String cliHelpTruststore = "The path of an optional truststore to be used for SSL/TLS connections.";
    protected String cliHelpTruststore$str() {
        return cliHelpTruststore;
    }
    @Override
    public final String cliHelpTruststore() {
        return String.format(getLoggingLocale(), cliHelpTruststore$str());
    }
    private static final String cliHelpTrustAll = "Trusts all certificates in SSL/TLS connections.";
    protected String cliHelpTrustAll$str() {
        return cliHelpTrustAll;
    }
    @Override
    public final String cliHelpTrustAll() {
        return String.format(getLoggingLocale(), cliHelpTrustAll$str());
    }
    private static final String notFound = "Not Found %s";
    protected String notFound$str() {
        return notFound;
    }
    @Override
    public final IOException notFound(final String s) {
        final IOException result = new IOException(String.format(getLoggingLocale(), notFound$str(), s));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unauthorized = "The supplied credentials are invalid %s";
    protected String unauthorized$str() {
        return unauthorized;
    }
    @Override
    public final AccessDeniedException unauthorized(final String s) {
        final AccessDeniedException result = new AccessDeniedException(String.format(getLoggingLocale(), unauthorized$str(), s));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String error = "Error: %s";
    protected String error$str() {
        return error;
    }
    @Override
    public final IOException error(final String s) {
        final IOException result = new IOException(String.format(getLoggingLocale(), error$str(), s));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String forbidden = "The user is not allowed to access the server resource: %s";
    protected String forbidden$str() {
        return forbidden;
    }
    @Override
    public final AccessDeniedException forbidden(final String s) {
        final AccessDeniedException result = new AccessDeniedException(String.format(getLoggingLocale(), forbidden$str(), s));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String keyStoreError = "Error while loading trust store '%s'";
    protected String keyStoreError$str() {
        return keyStoreError;
    }
    @Override
    public final String keyStoreError(final String trustStorePath, final Exception e) {
        return String.format(getLoggingLocale(), keyStoreError$str(), trustStorePath);
    }
    private static final String noSuchResource = "No such resource '%s'";
    protected String noSuchResource$str() {
        return noSuchResource;
    }
    @Override
    public final IllegalArgumentException noSuchResource(final String name) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), noSuchResource$str(), name));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String illegalContext = "Command invoked from the wrong context";
    protected String illegalContext$str() {
        return illegalContext;
    }
    @Override
    public final IllegalStateException illegalContext() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), illegalContext$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String illegalCommandArguments = "Illegal arguments for command";
    protected String illegalCommandArguments$str() {
        return illegalCommandArguments;
    }
    @Override
    public final IllegalArgumentException illegalCommandArguments() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), illegalCommandArguments$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mutuallyExclusiveOptions = "The options '%s' and '%s' are mutually exclusive";
    protected String mutuallyExclusiveOptions$str() {
        return mutuallyExclusiveOptions;
    }
    @Override
    public final IllegalArgumentException mutuallyExclusiveOptions(final String arg1, final String arg2) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), mutuallyExclusiveOptions$str(), arg1, arg2));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String requiresOneOf = "One of the '%s' and '%s' options are required";
    protected String requiresOneOf$str() {
        return requiresOneOf;
    }
    @Override
    public final IllegalArgumentException requiresOneOf(final String arg1, final String arg2) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), requiresOneOf$str(), arg1, arg2));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String connectionFailed = "Could not connect to server: %s";
    protected String connectionFailed$str() {
        return connectionFailed;
    }
    @Override
    public final ConnectException connectionFailed(final String message) {
        final ConnectException result = new ConnectException(String.format(getLoggingLocale(), connectionFailed$str(), message));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
}
