package org.infinispan.cli.completers;

import java.util.Collection;

import org.infinispan.cli.Context;
import org.infinispan.cli.connection.Connection;

/**
 * @author Tristan Tarrant &lt;tristan@infinispan.org&gt;
 * @since 10.0
 **/
public class CacheCompleter extends ListCompleter {
   @Override
   Collection<String> getAvailableItems(Context context) {
      Connection connection = context.getConnection();
      return context.getConnection().getAvailableCaches(connection.getActiveContainer().getName());
   }
}
