/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cli.commands;

import java.util.Collections;
import org.aesh.command.CommandDefinition;
import org.aesh.command.CommandResult;
import org.aesh.command.GroupCommandDefinition;
import org.aesh.command.impl.completer.FileOptionCompleter;
import org.aesh.command.option.Argument;
import org.aesh.command.option.Option;
import org.aesh.io.Resource;
import org.infinispan.cli.activators.ConnectionActivator;
import org.infinispan.cli.commands.CliCommand;
import org.infinispan.cli.commands.CommandInputLine;
import org.infinispan.cli.completers.CacheConfigurationCompleter;
import org.infinispan.cli.completers.CounterStorageCompleter;
import org.infinispan.cli.completers.CounterTypeCompleter;
import org.infinispan.cli.impl.ContextAwareCommandInvocation;
import org.infinispan.cli.logging.Messages;

@GroupCommandDefinition(name="create", description="Creates a cache or a counter", activator=ConnectionActivator.class, groupCommands={Cache.class, Counter.class})
public class Create
extends CliCommand {
    public static final String CMD = "create";
    public static final String TYPE = "type";
    public static final String NAME = "name";

    @Override
    public CommandResult exec(ContextAwareCommandInvocation commandInvocation) {
        if (this.help) {
            commandInvocation.println(commandInvocation.getHelpInfo());
        }
        return CommandResult.SUCCESS;
    }

    @CommandDefinition(name="counter", description="Create a counter", activator=ConnectionActivator.class)
    public static class Counter
    extends CliCommand {
        public static final String CMD = "counter";
        public static final String COUNTER_TYPE = "counter-type";
        public static final String INITIAL_VALUE = "initial-value";
        public static final String STORAGE = "storage";
        public static final String UPPER_BOUND = "upper-bound";
        public static final String LOWER_BOUND = "lower-bound";
        public static final String CONCURRENCY_LEVEL = "concurrency-level";
        @Argument(required=true)
        String name;
        @Option(shortName=116, defaultValue={""}, completer=CounterTypeCompleter.class)
        String type;
        @Option(shortName=105, name="initial-value", defaultValue={"0"})
        Long initialValue;
        @Option(shortName=115, defaultValue={"VOLATILE"}, completer=CounterStorageCompleter.class)
        String storage;
        @Option(shortName=117, name="upper-bound")
        Long upperBound;
        @Option(shortName=108, name="lower-bound")
        Long lowerBound;
        @Option(shortName=99, name="concurrency-level", defaultValue={"16"})
        Integer concurrencyLevel;

        @Override
        public CommandResult exec(ContextAwareCommandInvocation invocation) {
            CommandInputLine cmd = new CommandInputLine(Create.CMD).arg(Create.TYPE, CMD).arg(Create.NAME, this.name).option(COUNTER_TYPE, this.type).option(INITIAL_VALUE, this.initialValue).option(STORAGE, this.storage).option(UPPER_BOUND, this.upperBound).option(LOWER_BOUND, this.lowerBound).option(CONCURRENCY_LEVEL, this.concurrencyLevel);
            return invocation.execute(Collections.singletonList(cmd));
        }
    }

    @CommandDefinition(name="cache", description="Create a cache", activator=ConnectionActivator.class)
    public static class Cache
    extends CliCommand {
        public static final String CMD = "cache";
        public static final String TEMPLATE = "template";
        public static final String FILE = "file";
        public static final String VOLATILE = "volatile";
        @Argument(required=true)
        String name;
        @Option(completer=CacheConfigurationCompleter.class, shortName=116)
        String template;
        @Option(completer=FileOptionCompleter.class, shortName=102)
        Resource file;
        @Option(defaultValue={"false"}, name="volatile", shortName=118)
        boolean volatileCache;

        @Override
        public CommandResult exec(ContextAwareCommandInvocation invocation) {
            if (this.template != null && this.file != null) {
                throw Messages.MSG.mutuallyExclusiveOptions(TEMPLATE, FILE);
            }
            if (this.template == null && this.file == null) {
                throw Messages.MSG.requiresOneOf(TEMPLATE, FILE);
            }
            CommandInputLine cmd = new CommandInputLine(Create.CMD).arg(Create.TYPE, CMD).arg(Create.NAME, this.name).optionalArg(TEMPLATE, this.template).optionalArg(FILE, this.file != null ? this.file.getAbsolutePath() : null).option(VOLATILE, this.volatileCache);
            return invocation.execute(cmd);
        }
    }
}

