/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cli;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Properties;
import java.util.function.Supplier;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.aesh.command.AeshCommandRuntimeBuilder;
import org.aesh.command.Command;
import org.aesh.command.CommandNotFoundHandler;
import org.aesh.command.activator.CommandActivatorProvider;
import org.aesh.command.completer.CompleterInvocationProvider;
import org.aesh.command.impl.registry.AeshCommandRegistryBuilder;
import org.aesh.command.invocation.CommandInvocation;
import org.aesh.command.invocation.CommandInvocationProvider;
import org.aesh.command.registry.CommandRegistry;
import org.aesh.command.registry.CommandRegistryException;
import org.aesh.command.settings.QuitHandler;
import org.aesh.command.settings.SettingsBuilder;
import org.aesh.command.shell.Shell;
import org.aesh.readline.AeshContext;
import org.aesh.readline.ReadlineConsole;
import org.aesh.terminal.Connection;
import org.infinispan.cli.Context;
import org.infinispan.cli.activators.ContextAwareCommandActivatorProvider;
import org.infinispan.cli.commands.Batch;
import org.infinispan.cli.completers.ContextAwareCompleterInvocationProvider;
import org.infinispan.cli.impl.CliCommandNotFoundHandler;
import org.infinispan.cli.impl.CliMode;
import org.infinispan.cli.impl.CliRuntimeRunner;
import org.infinispan.cli.impl.ContextAwareCommandInvocationProvider;
import org.infinispan.cli.impl.ContextAwareQuitHandler;
import org.infinispan.cli.impl.ContextImpl;
import org.infinispan.cli.impl.SSLContextSettings;
import org.infinispan.cli.logging.Messages;
import org.infinispan.cli.util.ZeroSecurityHostnameVerifier;
import org.infinispan.cli.util.ZeroSecurityTrustManager;
import org.infinispan.commons.util.ServiceFinder;
import org.infinispan.commons.util.Version;
import org.wildfly.security.keystore.KeyStoreUtil;
import org.wildfly.security.provider.util.ProviderUtil;

public class CLI {
    private final PrintStream stdOut;
    private final PrintStream stdErr;
    private ReadlineConsole console;
    private Context context;
    private CliMode mode = CliMode.INTERACTIVE;
    private String inputFile;
    private Connection terminalConnection;
    private Shell shell;

    public CLI() {
        this(System.out, System.err, System.getProperties());
    }

    public CLI(PrintStream stdOut, PrintStream stdErr, Properties properties) {
        this.stdOut = stdOut;
        this.stdErr = stdErr;
        this.context = new ContextImpl(properties);
    }

    public final void run(String[] args) {
        String connectionString;
        block55: {
            connectionString = null;
            String trustStorePath = null;
            String trustStorePassword = null;
            boolean trustAll = false;
            Iterator iterator = Arrays.stream(args).iterator();
            block41: while (iterator.hasNext()) {
                String command = (String)iterator.next();
                String parameter = null;
                if (command.startsWith("--")) {
                    int equals = command.indexOf(61);
                    if (equals > 0) {
                        parameter = command.substring(equals + 1);
                        command = command.substring(0, equals);
                    }
                } else if (command.startsWith("-D")) {
                    if (command.length() < 3) {
                        this.stdErr.println(Messages.MSG.invalidArgument(command));
                        this.exit(1);
                        return;
                    }
                    parameter = command.substring(2);
                    command = command.substring(0, 2);
                } else if (command.startsWith("-")) {
                    if (command.length() != 2) {
                        this.stdErr.println(Messages.MSG.invalidShortArgument(command));
                        this.exit(1);
                        return;
                    }
                } else {
                    this.stdErr.println(Messages.MSG.invalidArgument(command));
                    this.exit(1);
                    return;
                }
                switch (command) {
                    case "-c": {
                        parameter = (String)iterator.next();
                    }
                    case "--connect": {
                        connectionString = parameter;
                        continue block41;
                    }
                    case "-f": {
                        parameter = (String)iterator.next();
                    }
                    case "--file": {
                        this.inputFile = parameter;
                        if ("-".equals(this.inputFile) || new File(this.inputFile).isFile()) {
                            this.mode = CliMode.BATCH;
                            continue block41;
                        }
                        this.stdErr.println(Messages.MSG.fileNotExists(this.inputFile));
                        this.exit(1);
                        continue block41;
                    }
                    case "-t": {
                        parameter = (String)iterator.next();
                    }
                    case "--truststore": {
                        trustStorePath = parameter;
                        continue block41;
                    }
                    case "-s": {
                        parameter = (String)iterator.next();
                    }
                    case "--truststore-password": {
                        trustStorePassword = parameter;
                        continue block41;
                    }
                    case "--trustall": {
                        trustAll = true;
                        continue block41;
                    }
                    case "-h": 
                    case "--help": {
                        this.version(this.stdOut);
                        this.help(this.stdOut);
                        this.exit(0);
                        return;
                    }
                    case "-D": {
                        int equals = parameter.indexOf(61);
                        this.context.setProperty(parameter.substring(0, equals), parameter.substring(equals + 1));
                        continue block41;
                    }
                    case "-v": 
                    case "--version": {
                        this.version(this.stdOut);
                        this.exit(0);
                        return;
                    }
                }
                this.stdErr.println(Messages.MSG.unknownArgument(command));
                this.exit(1);
                return;
            }
            if (trustStorePath != null) {
                try (FileInputStream f = new FileInputStream(trustStorePath);){
                    KeyStore keyStore = KeyStoreUtil.loadKeyStore((Supplier)ProviderUtil.INSTALLED_PROVIDERS, null, (FileInputStream)f, trustStorePath, (char[])trustStorePassword.toCharArray());
                    TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                    trustManagerFactory.init(keyStore);
                    SSLContextSettings sslContext = SSLContextSettings.getInstance("TLS", null, trustManagerFactory.getTrustManagers(), null, null);
                    this.context.setSslContext(sslContext);
                    break block55;
                }
                catch (Exception e) {
                    this.stdErr.println(Messages.MSG.keyStoreError(trustStorePath, e));
                    this.exit(1);
                    return;
                }
            }
            if (trustAll) {
                SSLContextSettings sslContext = SSLContextSettings.getInstance("TLS", null, new TrustManager[]{new ZeroSecurityTrustManager()}, null, new ZeroSecurityHostnameVerifier());
                this.context.setSslContext(sslContext);
            }
        }
        if (connectionString != null) {
            this.context.connect(null, connectionString);
        }
        switch (this.mode) {
            case BATCH: {
                this.batchRun();
                break;
            }
            case INTERACTIVE: {
                this.interactiveRun();
            }
        }
    }

    private void batchRun() {
        AeshCommandRegistryBuilder registryBuilder = AeshCommandRegistryBuilder.builder();
        try {
            registryBuilder.command(Batch.class);
            ArrayList commands = new ArrayList();
            for (Command command : ServiceFinder.load(Command.class, (ClassLoader[])new ClassLoader[]{this.getClass().getClassLoader()})) {
                commands.add(command.getClass());
            }
            registryBuilder.commands(commands);
        }
        catch (CommandRegistryException e) {
            throw new RuntimeException(e);
        }
        AeshCommandRuntimeBuilder runtimeBuilder = AeshCommandRuntimeBuilder.builder();
        runtimeBuilder.commandActivatorProvider((CommandActivatorProvider)new ContextAwareCommandActivatorProvider(this.context)).commandInvocationProvider((CommandInvocationProvider)new ContextAwareCommandInvocationProvider(this.context)).commandNotFoundHandler((CommandNotFoundHandler)new CliCommandNotFoundHandler()).completerInvocationProvider((CompleterInvocationProvider)new ContextAwareCompleterInvocationProvider(this.context)).aeshContext((AeshContext)this.context).commandRegistry(registryBuilder.create());
        if (this.shell != null) {
            runtimeBuilder.shell(this.shell);
        }
        CliRuntimeRunner cliRunner = CliRuntimeRunner.builder("batch", runtimeBuilder.build());
        cliRunner.args(new String[]{"run", this.inputFile}).execute();
        this.context.disconnect();
    }

    private void interactiveRun() {
        CommandRegistry commandRegistry = this.initializeCommands();
        this.context.setRegistry((CommandRegistry<? extends CommandInvocation>)commandRegistry);
        SettingsBuilder settings = SettingsBuilder.builder();
        settings.enableAlias(true).outputStream(System.out).outputStreamError(System.err).inputStream(System.in).commandActivatorProvider((CommandActivatorProvider)new ContextAwareCommandActivatorProvider(this.context)).commandInvocationProvider((CommandInvocationProvider)new ContextAwareCommandInvocationProvider(this.context)).commandNotFoundHandler((CommandNotFoundHandler)new CliCommandNotFoundHandler()).completerInvocationProvider((CompleterInvocationProvider)new ContextAwareCompleterInvocationProvider(this.context)).commandRegistry(commandRegistry).aeshContext((AeshContext)this.context).quitHandler((QuitHandler)new ContextAwareQuitHandler(this.context));
        if (this.terminalConnection != null) {
            settings.connection(this.terminalConnection);
        }
        this.console = new ReadlineConsole(settings.build());
        this.context.setConsole(this.console);
        try {
            this.console.start();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private CommandRegistry initializeCommands() {
        AeshCommandRegistryBuilder registryBuilder = AeshCommandRegistryBuilder.builder();
        Collection commands = ServiceFinder.load(Command.class, (ClassLoader[])new ClassLoader[]{this.getClass().getClassLoader()});
        try {
            for (Command command : commands) {
                registryBuilder.command(command);
            }
        }
        catch (CommandRegistryException e) {
            throw new RuntimeException(e);
        }
        return registryBuilder.create();
    }

    public Context getContext() {
        return this.context;
    }

    public void exit(int exitCode) {
        System.exit(exitCode);
    }

    private void help(PrintStream out) {
        out.printf("Usage: cli [OPTION]...\n", new Object[0]);
        out.printf("  -c, --connect=URL         %s\n", Messages.MSG.cliHelpConnect(Version.getBrandName()));
        out.printf("                            %s\n", Messages.MSG.cliHelpConnectHTTP());
        out.printf("  -f, --file=FILE           %s\n", Messages.MSG.cliHelpFile());
        out.printf("  -h, --help                %s\n", Messages.MSG.cliHelpHelp());
        out.printf("  --trustall                %s\n", Messages.MSG.cliHelpTrustAll());
        out.printf("  -s, --truststore-password %s\n", Messages.MSG.cliHelpTruststorePassword());
        out.printf("  -t, --truststore          %s\n", Messages.MSG.cliHelpTruststore());
        out.printf("  -h, --help                %s\n", Messages.MSG.cliHelpHelp());
        out.printf("  -v, --version             %s\n", Messages.MSG.cliHelpVersion());
    }

    private void version(PrintStream out) {
        out.printf("%s CLI %s\n", Version.getBrandName(), Version.getVersion());
        out.printf("Copyright (C) Red Hat Inc. and/or its affiliates and other contributors\n", new Object[0]);
        out.printf("License Apache License, v. 2.0. http://www.apache.org/licenses/LICENSE-2.0\n", new Object[0]);
    }

    public static void main(String[] args) {
        CLI cli = new CLI();
        cli.run(args);
    }

    public void setTerminalConnection(Connection terminalConnection) {
        this.terminalConnection = terminalConnection;
    }

    public void setShell(Shell shell) {
        this.shell = shell;
    }

    public void stop() {
        this.context.disconnect();
        if (this.console != null) {
            this.console.stop();
        }
    }
}

