/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cli.commands;

import java.util.Collections;
import java.util.List;
import org.aesh.command.CommandDefinition;
import org.aesh.command.CommandResult;
import org.aesh.command.GroupCommandDefinition;
import org.aesh.command.option.Argument;
import org.aesh.command.option.Option;
import org.aesh.command.option.OptionList;
import org.infinispan.cli.activators.ConnectionActivator;
import org.infinispan.cli.commands.CliCommand;
import org.infinispan.cli.commands.CommandInputLine;
import org.infinispan.cli.completers.LogAppenderCompleter;
import org.infinispan.cli.completers.LogLevelCompleter;
import org.infinispan.cli.completers.LoggersCompleter;
import org.infinispan.cli.impl.ContextAwareCommandInvocation;

@GroupCommandDefinition(name="logging", description="Inspects/Manipulates the server logging configuration", activator=ConnectionActivator.class, groupCommands={Loggers.class, Appenders.class, Set.class, Remove.class})
public class Logging
extends CliCommand {
    public static final String CMD = "logging";
    public static final String TYPE = "type";
    public static final String NAME = "name";

    @Override
    public CommandResult exec(ContextAwareCommandInvocation commandInvocation) {
        if (this.help) {
            commandInvocation.println(commandInvocation.getHelpInfo());
        }
        return CommandResult.SUCCESS;
    }

    @CommandDefinition(name="set", description="Sets a logger", activator=ConnectionActivator.class)
    public static class Set
    extends CliCommand {
        public static final String CMD = "set";
        public static final String LEVEL = "level";
        public static final String APPENDERS = "appenders";
        @Argument(completer=LoggersCompleter.class)
        String name;
        @Option(shortName=108, description="One of OFF, TRACE, DEBUG, INFO, WARN, ERROR, FATAL, ALL", completer=LogLevelCompleter.class)
        String level;
        @OptionList(shortName=97, description="One or more appender names", completer=LogAppenderCompleter.class)
        List<String> appenders;

        @Override
        public CommandResult exec(ContextAwareCommandInvocation invocation) {
            CommandInputLine cmd = new CommandInputLine(Logging.CMD).arg(Logging.TYPE, CMD).arg(Logging.NAME, this.name).option(LEVEL, this.level).optionalArg(APPENDERS, this.appenders);
            return invocation.execute(Collections.singletonList(cmd));
        }
    }

    @CommandDefinition(name="remove", description="Removes a logger", activator=ConnectionActivator.class)
    public static class Remove
    extends CliCommand {
        public static final String CMD = "remove";
        @Argument(required=true, completer=LoggersCompleter.class)
        String name;

        @Override
        public CommandResult exec(ContextAwareCommandInvocation invocation) {
            CommandInputLine cmd = new CommandInputLine(Logging.CMD).arg(Logging.TYPE, CMD).arg(Logging.NAME, this.name);
            return invocation.execute(Collections.singletonList(cmd));
        }
    }

    @CommandDefinition(name="list-appenders", description="Lists available appenders", activator=ConnectionActivator.class)
    public static class Appenders
    extends CliCommand {
        public static final String CMD = "list-appenders";

        @Override
        public CommandResult exec(ContextAwareCommandInvocation invocation) {
            CommandInputLine cmd = new CommandInputLine(Logging.CMD).arg(Logging.TYPE, CMD);
            return invocation.execute(cmd);
        }
    }

    @CommandDefinition(name="list-loggers", description="Lists available loggers", activator=ConnectionActivator.class)
    public static class Loggers
    extends CliCommand {
        public static final String CMD = "list-loggers";

        @Override
        public CommandResult exec(ContextAwareCommandInvocation invocation) {
            CommandInputLine cmd = new CommandInputLine(Logging.CMD).arg(Logging.TYPE, CMD);
            return invocation.execute(cmd);
        }
    }
}

