/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cli.connection.rest;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.infinispan.cli.commands.CommandInputLine;
import org.infinispan.cli.connection.Connection;
import org.infinispan.cli.logging.Messages;
import org.infinispan.cli.resources.AbstractResource;
import org.infinispan.cli.resources.CacheKeyResource;
import org.infinispan.cli.resources.CacheResource;
import org.infinispan.cli.resources.ContainerResource;
import org.infinispan.cli.resources.CounterResource;
import org.infinispan.cli.resources.Resource;
import org.infinispan.cli.resources.RootResource;
import org.infinispan.cli.util.IterableJsonReader;
import org.infinispan.client.rest.RestCacheClient;
import org.infinispan.client.rest.RestClient;
import org.infinispan.client.rest.RestCounterClient;
import org.infinispan.client.rest.RestEntity;
import org.infinispan.client.rest.RestQueryMode;
import org.infinispan.client.rest.RestResponse;
import org.infinispan.client.rest.RestTaskClient;
import org.infinispan.client.rest.configuration.RestClientConfiguration;
import org.infinispan.client.rest.configuration.RestClientConfigurationBuilder;
import org.infinispan.client.rest.configuration.ServerConfiguration;
import org.infinispan.commons.api.CacheContainerAdmin;
import org.infinispan.commons.dataconversion.MediaType;

public class RestConnection
implements Connection,
Closeable {
    public static String PROTOBUF_METADATA_CACHE_NAME = "___protobuf_metadata";
    private final RestClientConfigurationBuilder builder;
    private final ObjectMapper mapper;
    private Resource activeResource;
    private MediaType encoding = MediaType.TEXT_PLAIN;
    private Collection<String> availableConfigurations;
    private Collection<String> availableContainers;
    private Collection<String> availableCaches;
    private Collection<String> clusterMembers;
    private RestClient client;
    private boolean connected;
    private String serverVersion;
    private String serverInfo;

    public RestConnection(RestClientConfigurationBuilder builder) {
        this.builder = builder;
        this.mapper = new ObjectMapper();
    }

    @Override
    public void close() throws IOException {
        this.client.close();
    }

    @Override
    public void connect() throws IOException {
        this.client = RestClient.forConfiguration((RestClientConfiguration)this.builder.build());
        this.connectInternal();
    }

    @Override
    public void connect(String username, String password) throws IOException {
        this.builder.security().authentication().enable().username(username).password(password);
        this.client = RestClient.forConfiguration((RestClientConfiguration)this.builder.build());
        this.connectInternal();
    }

    private void connectInternal() throws IOException {
        this.serverVersion = (String)this.parseBody(this.fetch(() -> this.client.server().info()), Map.class).get("version");
        this.connected = true;
        this.availableContainers = this.parseBody(this.fetch(() -> this.client.cacheManagers()), List.class);
        this.activeResource = Resource.getRootResource(this).getChild("containers", this.availableContainers.iterator().next());
        this.refreshServerInfo();
    }

    private RestResponse fetch(Supplier<CompletionStage<RestResponse>> responseFutureSupplier) throws IOException {
        return this.fetch(responseFutureSupplier.get());
    }

    private RestResponse fetch(CompletionStage<RestResponse> responseFuture) throws IOException {
        try {
            return responseFuture.toCompletableFuture().get(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IOException(e);
        }
        catch (ExecutionException e) {
            throw Messages.MSG.connectionFailed(e.getMessage());
        }
        catch (TimeoutException e) {
            throw new IOException(e);
        }
    }

    private Map<String, List<String>> parseHeaders(RestResponse response) throws IOException {
        if ((response = this.handleResponseStatus(response)) != null) {
            return response.headers();
        }
        return Collections.emptyMap();
    }

    private <T> T parseBody(RestResponse response, Class<T> returnClass) throws IOException {
        if ((response = this.handleResponseStatus(response)) != null) {
            if (returnClass == InputStream.class) {
                return (T)response.getBodyAsStream();
            }
            if (returnClass == String.class) {
                if (MediaType.APPLICATION_JSON.equals((Object)response.contentType())) {
                    Object object = this.mapper.readValue(response.getBody(), Object.class);
                    return (T)this.mapper.writerWithDefaultPrettyPrinter().writeValueAsString(object);
                }
                return (T)response.getBody();
            }
            return (T)this.mapper.readValue(response.getBody(), returnClass);
        }
        return null;
    }

    private RestResponse handleResponseStatus(RestResponse response) throws IOException {
        switch (response.getStatus()) {
            case 200: {
                return response;
            }
            case 204: {
                return null;
            }
            case 401: {
                throw Messages.MSG.unauthorized(response.getBody());
            }
            case 403: {
                throw Messages.MSG.forbidden(response.getBody());
            }
            case 404: {
                throw Messages.MSG.notFound(response.getBody());
            }
        }
        throw Messages.MSG.error(response.getBody());
    }

    private Resource pathToResource(String path) throws IOException {
        if (".".equals(path)) {
            return this.activeResource;
        }
        if ("..".equals(path)) {
            return this.activeResource.getParent();
        }
        String[] parts = path.split("/");
        if (parts.length == 0) {
            return this.activeResource.findAncestor(RootResource.class);
        }
        Resource resource = this.activeResource;
        for (String part : parts) {
            resource = part.isEmpty() ? resource.findAncestor(RootResource.class) : resource.getChild(part);
        }
        return resource;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public String execute(List<CommandInputLine> commands) throws IOException {
        StringBuilder sb = new StringBuilder();
        ResponseMode responseMode = ResponseMode.BODY;
        block164: for (CommandInputLine command : commands) {
            CompletionStage response = null;
            block39 : switch (command.name()) {
                case "add": {
                    RestCounterClient counter = command.hasArg("counter") ? this.client.counter(command.arg("counter")) : this.client.counter(this.activeResource.findAncestor(CounterResource.class).getName());
                    response = counter.add(command.longOption("delta").longValue());
                    if (!command.boolOption("quiet").booleanValue()) break;
                    responseMode = ResponseMode.QUIET;
                    break;
                }
                case "cache": {
                    this.activeResource = this.activeResource.findAncestor(ContainerResource.class).getChild("caches", command.arg("name"));
                    break;
                }
                case "cas": {
                    RestCounterClient counter = command.hasArg("counter") ? this.client.counter(command.arg("counter")) : this.client.counter(this.activeResource.findAncestor(CounterResource.class).getName());
                    if (command.boolOption("quiet").booleanValue()) {
                        response = counter.compareAndSet(command.longOption("expect").longValue(), command.longOption("value").longValue());
                        break;
                    }
                    response = counter.compareAndSwap(command.longOption("expect").longValue(), command.longOption("value").longValue());
                    break;
                }
                case "cd": {
                    String path = command.arg("path");
                    Resource rPath = this.pathToResource(path);
                    if (rPath instanceof CacheKeyResource) break;
                    this.activeResource = rPath;
                    break;
                }
                case "clearcache": {
                    if (command.hasArg("name")) {
                        this.activeResource.findAncestor(ContainerResource.class).getChild("caches").getChild(command.arg("name"));
                        response = this.client.cache(command.arg("name")).clear();
                        break;
                    }
                    Object resource = this.activeResource.findAncestor(CacheResource.class);
                    if (resource == null) break;
                    response = this.client.cache(((AbstractResource)resource).getName()).clear();
                    break;
                }
                case "container": {
                    this.activeResource = this.activeResource.findAncestor(RootResource.class).getChild("containers", command.arg("name"));
                    break;
                }
                case "counter": {
                    this.activeResource = this.activeResource.findAncestor(ContainerResource.class).getChild("counters", command.arg("name"));
                    break;
                }
                case "create": {
                    switch (command.arg("type")) {
                        case "cache": {
                            CacheContainerAdmin.AdminFlag[] flags;
                            CacheContainerAdmin.AdminFlag[] adminFlagArray;
                            RestCacheClient cache = this.client.cache(command.arg("name"));
                            boolean vltl = command.boolOption("volatile");
                            if (vltl) {
                                CacheContainerAdmin.AdminFlag[] adminFlagArray2 = new CacheContainerAdmin.AdminFlag[1];
                                adminFlagArray = adminFlagArray2;
                                adminFlagArray2[0] = CacheContainerAdmin.AdminFlag.VOLATILE;
                            } else {
                                adminFlagArray = flags = new CacheContainerAdmin.AdminFlag[]{};
                            }
                            if (command.hasArg("template")) {
                                response = cache.createWithTemplate(command.arg("template"), flags);
                                break block39;
                            }
                            RestEntity entity = this.entityFromFile(new File(command.arg("file")));
                            response = cache.createWithConfiguration(entity, flags);
                            break block39;
                        }
                        case "counter": {
                            ObjectNode counter = this.mapper.createObjectNode();
                            ObjectNode node = counter.putObject(command.option("counter-type") + "-counter").put("initial-value", command.longOption("initial-value")).put("concurrency-level", command.intOption("concurrency-level")).put("storage", command.option("storage"));
                            if (command.hasOption("upper-bound")) {
                                node.put("upper-bound", command.longOption("upper-bound"));
                            }
                            if (command.hasOption("lower-bound")) {
                                node.put("lower-bound", command.longOption("lower-bound"));
                            }
                            response = this.client.counter(command.arg("name")).create(RestEntity.create((MediaType)MediaType.APPLICATION_JSON, (String)counter.toString()));
                            break block39;
                        }
                    }
                    break;
                }
                case "describe": {
                    Object resource = this.activeResource;
                    if (!command.hasArg("name")) return resource.describe();
                    resource = this.pathToResource(command.arg("name"));
                    return resource.describe();
                }
                case "drop": {
                    switch (command.arg("type")) {
                        case "cache": {
                            response = this.client.cache(command.arg("name")).delete();
                            break;
                        }
                        case "counter": {
                            response = this.client.counter(command.arg("name")).delete();
                        }
                    }
                    break;
                }
                case "encoding": {
                    if (command.hasArg("type")) {
                        this.encoding = MediaType.fromString((String)command.arg("type"));
                        break;
                    }
                    sb.append(this.encoding);
                    break;
                }
                case "get": {
                    String cache = this.getRestCacheClient(command.arg("cache"));
                    response = cache.get(command.arg("key"));
                    break;
                }
                case "ls": {
                    Object resource = this.activeResource;
                    if (command.hasArg("path")) {
                        resource = this.pathToResource(command.arg("path"));
                    }
                    StringJoiner j = new StringJoiner("\n");
                    for (String item : resource.getChildrenNames()) {
                        j.add(item);
                    }
                    return j.toString();
                }
                case "query": {
                    String cache = this.getRestCacheClient(command.arg("cache"));
                    response = cache.query(command.arg("query"), command.intOption("max-results").intValue(), command.intOption("offset").intValue(), RestQueryMode.valueOf((String)command.option("query-mode")));
                    break;
                }
                case "put": {
                    String cache = this.getRestCacheClient(command.option("cache"));
                    MediaType putEncoding = command.hasOption("encoding") ? MediaType.fromString((String)command.option("encoding")) : this.encoding;
                    RestEntity value = command.hasOption("file") ? RestEntity.create((MediaType)putEncoding, (File)new File(command.option("file"))) : RestEntity.create((MediaType)putEncoding, (String)command.arg("value"));
                    if (command.boolOption("if-absent").booleanValue()) {
                        response = cache.post(command.arg("key"), value, command.longOption("ttl").longValue(), command.longOption("max-idle").longValue());
                        break;
                    }
                    response = cache.put(command.arg("key"), value, command.longOption("ttl").longValue(), command.longOption("max-idle").longValue());
                    break;
                }
                case "remove": {
                    String cache = this.getRestCacheClient(command.arg("cache"));
                    response = cache.remove(command.arg("key"));
                    break;
                }
                case "reset": {
                    RestCounterClient counter = command.hasArg("counter") ? this.client.counter(command.arg("counter")) : this.client.counter(this.activeResource.findAncestor(CounterResource.class).getName());
                    response = counter.reset();
                    break;
                }
                case "schema": {
                    String cache = this.client.cache(PROTOBUF_METADATA_CACHE_NAME);
                    if (command.hasArg("file")) {
                        RestEntity value = RestEntity.create((MediaType)MediaType.TEXT_PLAIN, (File)new File(command.arg("file")));
                        response = cache.put(command.arg("key"), value);
                        break;
                    }
                    response = cache.get(command.arg("key"));
                    break;
                }
                case "shutdown": {
                    switch (command.arg("type")) {
                        case "server": {
                            if (command.hasArg("servers")) {
                                response = this.client.cluster().stop((List)command.argAs("servers"));
                                break;
                            }
                            response = this.client.server().stop();
                            break;
                        }
                        case "cluster": {
                            response = this.client.cluster().stop();
                        }
                    }
                    break;
                }
                case "site": {
                    String cache = this.client.cache(command.arg("cache"));
                    switch (command.arg("op")) {
                        case "status": {
                            if (command.hasArg("site")) {
                                response = cache.backupStatus(command.arg("site"));
                                break;
                            }
                            response = cache.xsiteBackups();
                            break;
                        }
                        case "bring-online": {
                            response = cache.bringSiteOnline(command.arg("site"));
                            break;
                        }
                        case "take-offline": {
                            response = cache.takeSiteOffline(command.arg("site"));
                            break;
                        }
                        case "push-site-state": {
                            response = cache.pushSiteState(command.arg("site"));
                            break;
                        }
                        case "cancel-push-state": {
                            response = cache.cancelPushState(command.arg("site"));
                            break;
                        }
                        case "cancel-receive-state": {
                            response = cache.cancelReceiveState(command.arg("site"));
                            break;
                        }
                        case "push-site-status": {
                            response = cache.pushStateStatus();
                            break;
                        }
                        case "clear-push-state-status": {
                            response = cache.clearPushStateStatus();
                        }
                    }
                    break;
                }
                case "task": {
                    switch (command.arg("type")) {
                        case "exec": {
                            response = this.client.tasks().exec(command.arg("name"), (Map)command.argAs("parameters"));
                            break block39;
                        }
                        case "upload": {
                            RestEntity value = RestEntity.create((MediaType)MediaType.TEXT_PLAIN, (File)new File(command.option("file")));
                            response = this.client.tasks().uploadScript(command.arg("name"), value);
                            break block39;
                        }
                    }
                    break;
                }
                case "stats": {
                    Object resource = this.activeResource;
                    if (command.hasArg("name")) {
                        resource = this.pathToResource(command.arg("name"));
                    }
                    if (resource instanceof CacheResource) {
                        response = this.client.cache(resource.getName()).stats();
                    } else {
                        String name = resource.getName();
                        if (!(resource instanceof ContainerResource)) throw Messages.MSG.invalidResource(name.isEmpty() ? "/" : name);
                        response = this.client.cacheManager(resource.getName()).stats();
                    }
                }
                case "logging": {
                    switch (command.arg("type")) {
                        case "list-loggers": {
                            response = this.client.server().logging().listLoggers();
                            break;
                        }
                        case "list-appenders": {
                            response = this.client.server().logging().listAppenders();
                            break;
                        }
                        case "set": {
                            if (command.hasArg("appenders")) {
                                List appenders = (List)command.argAs("appenders");
                                response = this.client.server().logging().setLogger(command.arg("name"), command.option("level"), appenders.toArray(new String[0]));
                                break;
                            }
                            response = this.client.server().logging().setLogger(command.arg("name"), command.option("level"), new String[0]);
                            break;
                        }
                        case "remove": {
                            response = this.client.server().logging().removeLogger(command.arg("name"));
                        }
                    }
                    break;
                }
                case "server": {
                    switch (command.arg("type")) {
                        case "report": {
                            responseMode = ResponseMode.FILE;
                            response = this.client.server().report();
                        }
                    }
                    break;
                }
                case "migrate": {
                    String cache = this.getRestCacheClient(command.option("cache"));
                    block139 : switch (command.arg("type")) {
                        case "cluster": {
                            switch (command.arg("subtype")) {
                                case "connect": {
                                    break block139;
                                }
                                case "synchronize": {
                                    response = cache.synchronizeData(command.intOption("read-batch"), command.intOption("threads"));
                                    break block139;
                                }
                                case "disconnect": {
                                    response = cache.disconnectSource();
                                }
                            }
                        }
                    }
                    break;
                }
            }
            if (response == null) continue;
            RestResponse r = this.fetch(response);
            switch (responseMode) {
                case BODY: {
                    String body = this.parseBody(r, String.class);
                    if (body == null) break;
                    sb.append(body);
                    break;
                }
                case FILE: {
                    String contentDisposition = (String)((List)r.headers().get("Content-Disposition")).get(0);
                    String filename = contentDisposition.substring(contentDisposition.indexOf(34) + 1, contentDisposition.lastIndexOf(34));
                    FileOutputStream os = new FileOutputStream(filename);
                    try {
                        InputStream is = this.parseBody(r, InputStream.class);
                        try {
                            int bytesRead;
                            byte[] buffer = new byte[8192];
                            while ((bytesRead = is.read(buffer)) != -1) {
                                ((OutputStream)os).write(buffer, 0, bytesRead);
                            }
                            sb.append(Messages.MSG.downloadedReport(filename));
                            continue block164;
                        }
                        finally {
                            if (is == null) continue block164;
                            is.close();
                            continue block164;
                        }
                    }
                    finally {
                        ((OutputStream)os).close();
                        continue block164;
                    }
                }
                case QUIET: {
                    break;
                }
                case HEADERS: {
                    sb.append(this.mapper.writerWithDefaultPrettyPrinter().writeValueAsString(this.parseHeaders(r)));
                }
            }
        }
        this.refreshServerInfo();
        return sb.toString();
    }

    private RestCacheClient getRestCacheClient(String name) {
        if (name != null) {
            return this.client.cache(name);
        }
        return this.client.cache(this.activeResource.findAncestor(CacheResource.class).getName());
    }

    @Override
    public Resource getActiveResource() {
        return this.activeResource;
    }

    @Override
    public ContainerResource getActiveContainer() {
        return this.activeResource.findAncestor(ContainerResource.class);
    }

    @Override
    public Collection<String> getAvailableCaches(String container) {
        return this.availableCaches;
    }

    @Override
    public Collection<String> getAvailableContainers() {
        return this.availableContainers;
    }

    @Override
    public Collection<String> getAvailableCounters(String container) throws IOException {
        return this.parseBody(this.fetch(() -> this.client.counters()), List.class);
    }

    @Override
    public Collection<String> getAvailableCacheConfigurations(String container) {
        return this.availableConfigurations;
    }

    @Override
    public Collection<String> getAvailableSchemas(String container) throws IOException {
        ArrayList<String> schemas = new ArrayList<String>();
        this.getCacheKeys(container, PROTOBUF_METADATA_CACHE_NAME).forEach(s -> schemas.add((String)s));
        return schemas;
    }

    @Override
    public Collection<String> getAvailableServers(String container) throws IOException {
        return (List)this.parseBody(this.fetch(() -> this.client.cacheManager(container).info()), Map.class).get("cluster_members");
    }

    @Override
    public Collection<String> getAvailableTasks(String container) throws IOException {
        List list = this.parseBody(this.fetch(() -> this.client.tasks().list(RestTaskClient.ResultType.ALL)), List.class);
        return list.stream().map(i -> (String)i.get("name")).collect(Collectors.toList());
    }

    @Override
    public Collection<String> getAvailableSites(String container, String cache) throws IOException {
        CompletionStage response = this.client.cache(cache).xsiteBackups();
        return null;
    }

    @Override
    public Iterable<String> getCacheKeys(String container, String cache) throws IOException {
        return new IterableJsonReader(this.parseBody(this.fetch(() -> this.client.cache(cache).keys()), InputStream.class), s -> s == null || "_value".equals(s));
    }

    @Override
    public Iterable<String> getCounterValue(String container, String counter) throws IOException {
        return Collections.singletonList(this.parseBody(this.fetch(() -> this.client.counter(counter).get()), String.class));
    }

    @Override
    public boolean isConnected() {
        return this.connected;
    }

    @Override
    public String describeContainer(String container) throws IOException {
        return this.parseBody(this.fetch(() -> this.client.cacheManager(container).info()), String.class);
    }

    @Override
    public String describeCache(String container, String cache) throws IOException {
        return this.parseBody(this.fetch(() -> this.client.cache(cache).configuration()), String.class);
    }

    @Override
    public String describeKey(String container, String cache, String key) throws IOException {
        Map<String, List<String>> headers = this.parseHeaders(this.fetch(() -> this.client.cache(cache).head(key)));
        return this.mapper.writerWithDefaultPrettyPrinter().writeValueAsString(headers);
    }

    @Override
    public String describeConfiguration(String container, String counter) {
        return null;
    }

    @Override
    public String describeCounter(String container, String counter) throws IOException {
        return this.parseBody(this.fetch(() -> this.client.counter(counter).configuration()), String.class);
    }

    @Override
    public String describeTask(String container, String taskName) throws IOException {
        List list = this.parseBody(this.fetch(() -> this.client.tasks().list(RestTaskClient.ResultType.ALL)), List.class);
        Optional<Map> task = list.stream().filter(i -> taskName.equals(i.get("name"))).findFirst();
        return task.map(Object::toString).orElseThrow(() -> Messages.MSG.noSuchResource(taskName));
    }

    @Override
    public Collection<String> getAvailableLogAppenders() throws IOException {
        Map map = this.parseBody(this.fetch(() -> this.client.server().logging().listAppenders()), Map.class);
        return map.keySet();
    }

    @Override
    public Collection<String> getAvailableLoggers() throws IOException {
        List list = this.parseBody(this.fetch(() -> this.client.server().logging().listLoggers()), List.class);
        return list.stream().map(i -> i.get("name").toString()).collect(Collectors.toList());
    }

    @Override
    public Collection<String> getClusterNodes() {
        return this.clusterMembers;
    }

    @Override
    public String getConnectionInfo() {
        return this.serverInfo;
    }

    @Override
    public String getServerVersion() {
        return this.serverVersion;
    }

    private void refreshServerInfo() throws IOException {
        try {
            ContainerResource container = this.getActiveContainer();
            String containerName = container.getName();
            Map cacheManagerInfo = this.parseBody(this.fetch(() -> this.client.cacheManager(containerName).info()), Map.class);
            List definedCaches = (List)cacheManagerInfo.get("defined_caches");
            this.availableCaches = new ArrayList<String>();
            definedCaches.forEach(m -> this.availableCaches.add((String)m.get("name")));
            definedCaches.remove(PROTOBUF_METADATA_CACHE_NAME);
            List configurationList = this.parseBody(this.fetch(() -> this.client.cacheManager(containerName).cacheConfigurations()), List.class);
            this.availableConfigurations = new ArrayList<String>(configurationList.size());
            for (Object item : configurationList) {
                this.availableConfigurations.add((String)((Map)item).get("name"));
            }
            String nodeAddress = (String)cacheManagerInfo.get("node_address");
            String clusterName = (String)cacheManagerInfo.get("cluster_name");
            this.clusterMembers = (Collection)cacheManagerInfo.get("cluster_members");
            if (nodeAddress != null) {
                this.serverInfo = nodeAddress + "@" + clusterName;
            } else {
                ServerConfiguration serverConfiguration = (ServerConfiguration)this.client.getConfiguration().servers().get(0);
                this.serverInfo = serverConfiguration.host() + ":" + serverConfiguration.port();
            }
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    private RestEntity entityFromFile(File f) throws IOException {
        try (FileInputStream is = new FileInputStream(f);){
            int b;
            while ((b = ((InputStream)is).read()) > -1) {
                if (b == 123) {
                    RestEntity restEntity = RestEntity.create((MediaType)MediaType.APPLICATION_JSON, (File)f);
                    return restEntity;
                }
                if (b != 60) continue;
                RestEntity restEntity = RestEntity.create((MediaType)MediaType.APPLICATION_XML, (File)f);
                return restEntity;
            }
        }
        return RestEntity.create((MediaType)MediaType.APPLICATION_OCTET_STREAM, (File)f);
    }

    RestClientConfigurationBuilder getBuilder() {
        return this.builder;
    }

    public String toString() {
        return this.serverInfo;
    }

    static enum ResponseMode {
        QUIET,
        BODY,
        FILE,
        HEADERS;

    }
}

