/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cli.patching;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.infinispan.cli.patching.PatchOperation;

@JsonNaming(value=PropertyNamingStrategy.KebabCaseStrategy.class)
public class PatchInfo {
    private final Date creationDate;
    private Date installationDate;
    private final String brandName;
    private final String sourceVersion;
    private final String targetVersion;
    private final String qualifier;
    private final List<PatchOperation> operations;

    public PatchInfo(String brandName, String sourceVersion, String targetVersion, String qualifier) {
        this(brandName, sourceVersion, targetVersion, qualifier, new Date(), null, new ArrayList<PatchOperation>());
    }

    @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
    PatchInfo(@JsonProperty(value="brandName") String brandName, @JsonProperty(value="sourceVersion") String sourceVersion, @JsonProperty(value="targetVersion") String targetVersion, @JsonProperty(value="qualifier") String qualifier, @JsonProperty(value="creationDate") Date creationDate, @JsonProperty(value="installationDate") Date installationDate, @JsonProperty(value="operations") List<PatchOperation> operations) {
        this.brandName = brandName;
        this.sourceVersion = sourceVersion;
        this.targetVersion = targetVersion;
        this.qualifier = qualifier;
        this.creationDate = creationDate;
        this.installationDate = installationDate;
        this.operations = operations;
    }

    public String getQualifier() {
        return this.qualifier;
    }

    public String getBrandName() {
        return this.brandName;
    }

    public String getSourceVersion() {
        return this.sourceVersion;
    }

    public String getTargetVersion() {
        return this.targetVersion;
    }

    public List<PatchOperation> getOperations() {
        return this.operations;
    }

    public Date getCreationDate() {
        return this.creationDate;
    }

    public Date getInstallationDate() {
        return this.installationDate;
    }

    public void setInstallationDate(Date installationDate) {
        this.installationDate = installationDate;
    }

    public String toString() {
        return this.brandName + " patch target=" + this.targetVersion + (this.qualifier.isEmpty() ? "" : "(" + this.qualifier + ")") + " source=" + this.sourceVersion + " created=" + this.creationDate + (this.installationDate != null ? " installed=" + this.installationDate : "");
    }
}

