/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cli.commands;

import java.util.Collections;
import org.aesh.command.CommandDefinition;
import org.aesh.command.CommandResult;
import org.aesh.command.GroupCommandDefinition;
import org.aesh.command.option.Option;
import org.infinispan.cli.activators.ConnectionActivator;
import org.infinispan.cli.commands.CliCommand;
import org.infinispan.cli.commands.CommandInputLine;
import org.infinispan.cli.completers.CacheCompleter;
import org.infinispan.cli.impl.ContextAwareCommandInvocation;

@GroupCommandDefinition(name="site", description="Manages backup sites", activator=ConnectionActivator.class, groupCommands={Status.class, BringOnline.class, TakeOffline.class, PushSiteState.class, CancelPushState.class, CancelReceiveState.class, PushSiteStatus.class, ClearPushStateStatus.class})
public class Site
extends CliCommand {
    public static final String CLEAR_PUSH_STATE_STATUS = "clear-push-state-status";
    public static final String PUSH_SITE_STATUS = "push-site-status";
    public static final String CANCEL_RECEIVE_STATE = "cancel-receive-state";
    public static final String CANCEL_PUSH_STATE = "cancel-push-state";
    public static final String PUSH_SITE_STATE = "push-site-state";
    public static final String TAKE_OFFLINE = "take-offline";
    public static final String BRING_ONLINE = "bring-online";
    public static final String STATUS = "status";
    public static final String CMD = "site";
    public static final String SITE_NAME = "site";
    public static final String OP = "op";
    public static final String CACHE = "cache";
    @Option(shortName=104, hasValue=false, overrideRequired=true)
    protected boolean help;

    @Override
    public boolean isHelp() {
        return this.help;
    }

    @Override
    public CommandResult exec(ContextAwareCommandInvocation invocation) {
        invocation.println(invocation.getHelpInfo());
        return CommandResult.FAILURE;
    }

    @CommandDefinition(name="clear-push-state-status", description="Clears the push state status", activator=ConnectionActivator.class)
    public static class ClearPushStateStatus
    extends CliCommand {
        @Option(required=true, completer=CacheCompleter.class)
        String cache;
        @Option(shortName=104, hasValue=false, overrideRequired=true)
        protected boolean help;

        @Override
        public boolean isHelp() {
            return this.help;
        }

        @Override
        public CommandResult exec(ContextAwareCommandInvocation invocation) {
            CommandInputLine cmd = new CommandInputLine("site").arg(Site.OP, Site.CLEAR_PUSH_STATE_STATUS).arg(Site.CACHE, this.cache);
            return invocation.execute(Collections.singletonList(cmd));
        }
    }

    @CommandDefinition(name="push-site-status", description="Shows the status of pushing to a site", activator=ConnectionActivator.class)
    public static class PushSiteStatus
    extends CliCommand {
        @Option(required=true, completer=CacheCompleter.class)
        String cache;
        @Option(shortName=104, hasValue=false, overrideRequired=true)
        protected boolean help;

        @Override
        public boolean isHelp() {
            return this.help;
        }

        @Override
        public CommandResult exec(ContextAwareCommandInvocation invocation) {
            CommandInputLine cmd = new CommandInputLine("site").arg(Site.OP, Site.PUSH_SITE_STATUS).arg(Site.CACHE, this.cache);
            return invocation.execute(Collections.singletonList(cmd));
        }
    }

    @CommandDefinition(name="cancel-receive-state", description="Cancels receiving state to a site", activator=ConnectionActivator.class)
    public static class CancelReceiveState
    extends CliCommand {
        @Option(required=true, completer=CacheCompleter.class)
        String cache;
        @Option(required=true)
        String site;
        @Option(shortName=104, hasValue=false, overrideRequired=true)
        protected boolean help;

        @Override
        public boolean isHelp() {
            return this.help;
        }

        @Override
        public CommandResult exec(ContextAwareCommandInvocation invocation) {
            CommandInputLine cmd = new CommandInputLine("site").arg(Site.OP, Site.CANCEL_RECEIVE_STATE).arg(Site.CACHE, this.cache).arg("site", this.site);
            return invocation.execute(Collections.singletonList(cmd));
        }
    }

    @CommandDefinition(name="cancel-push-state", description="Cacncels pushing state to a site", activator=ConnectionActivator.class)
    public static class CancelPushState
    extends CliCommand {
        @Option(required=true, completer=CacheCompleter.class)
        String cache;
        @Option(required=true)
        String site;
        @Option(shortName=104, hasValue=false, overrideRequired=true)
        protected boolean help;

        @Override
        public boolean isHelp() {
            return this.help;
        }

        @Override
        public CommandResult exec(ContextAwareCommandInvocation invocation) {
            CommandInputLine cmd = new CommandInputLine("site").arg(Site.OP, Site.CANCEL_PUSH_STATE).arg(Site.CACHE, this.cache).arg("site", this.site);
            return invocation.execute(Collections.singletonList(cmd));
        }
    }

    @CommandDefinition(name="push-site-state", description="Starts pushing state to a site", activator=ConnectionActivator.class)
    public static class PushSiteState
    extends CliCommand {
        @Option(required=true, completer=CacheCompleter.class)
        String cache;
        @Option(required=true)
        String site;
        @Option(shortName=104, hasValue=false, overrideRequired=true)
        protected boolean help;

        @Override
        public boolean isHelp() {
            return this.help;
        }

        @Override
        public CommandResult exec(ContextAwareCommandInvocation invocation) {
            CommandInputLine cmd = new CommandInputLine("site").arg(Site.OP, Site.PUSH_SITE_STATE).arg(Site.CACHE, this.cache).arg("site", this.site);
            return invocation.execute(Collections.singletonList(cmd));
        }
    }

    @CommandDefinition(name="take-offline", description="Takes a site offline", activator=ConnectionActivator.class)
    public static class TakeOffline
    extends CliCommand {
        @Option(required=true, completer=CacheCompleter.class)
        String cache;
        @Option(required=true)
        String site;
        @Option(shortName=104, hasValue=false, overrideRequired=true)
        protected boolean help;

        @Override
        public boolean isHelp() {
            return this.help;
        }

        @Override
        public CommandResult exec(ContextAwareCommandInvocation invocation) {
            CommandInputLine cmd = new CommandInputLine("site").arg(Site.OP, Site.TAKE_OFFLINE).arg(Site.CACHE, this.cache).arg("site", this.site);
            return invocation.execute(Collections.singletonList(cmd));
        }
    }

    @CommandDefinition(name="bring-online", description="Brings a site online", activator=ConnectionActivator.class)
    public static class BringOnline
    extends CliCommand {
        @Option(required=true, completer=CacheCompleter.class)
        String cache;
        @Option(required=true)
        String site;
        @Option(shortName=104, hasValue=false, overrideRequired=true)
        protected boolean help;

        @Override
        public boolean isHelp() {
            return this.help;
        }

        @Override
        public CommandResult exec(ContextAwareCommandInvocation invocation) {
            CommandInputLine cmd = new CommandInputLine("site").arg(Site.OP, Site.BRING_ONLINE).arg(Site.CACHE, this.cache).arg("site", this.site);
            return invocation.execute(cmd);
        }
    }

    @CommandDefinition(name="status", description="Shows site status", activator=ConnectionActivator.class)
    public static class Status
    extends CliCommand {
        @Option(required=true, completer=CacheCompleter.class)
        String cache;
        @Option
        String site;
        @Option(shortName=104, hasValue=false, overrideRequired=true)
        protected boolean help;

        @Override
        public boolean isHelp() {
            return this.help;
        }

        @Override
        public CommandResult exec(ContextAwareCommandInvocation invocation) {
            CommandInputLine cmd = new CommandInputLine("site").arg(Site.OP, Site.STATUS).arg(Site.CACHE, this.cache).optionalArg("site", this.site);
            return invocation.execute(Collections.singletonList(cmd));
        }
    }
}

