/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cli.patching;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;

public class PatchOperation {
    public static final String ACTION = "action";
    public static final String PATH = "path";
    public static final String DIGEST = "digest";
    public static final String PERMISSIONS = "permissions";
    public static final String NEW_PATH = "new-path";
    public static final String NEW_DIGEST = "new-digest";
    public static final String NEW_PERMISSIONS = "new-permissions";
    private final Action action;
    private final Path path;
    private final String digest;
    private final String permissions;
    private final Path newPath;
    private final String newDigest;
    private final String newPermissions;

    public static PatchOperation add(Path path, String digest, String permissions) {
        return new PatchOperation(Action.ADD, null, null, null, path, digest, permissions);
    }

    public static PatchOperation remove(Path path, String digest, String permissions) {
        return new PatchOperation(Action.REMOVE, path, digest, permissions, null, null, null);
    }

    public static PatchOperation upgrade(Path path, String digest, String permissions, Path newPath, String newDigest, String newPermissions) {
        return new PatchOperation(Action.UPGRADE, path, digest, permissions, newPath, newDigest, newPermissions);
    }

    public static PatchOperation replace(boolean soft, Path path, String digest, String permissions, String newDigest, String newPermissions) {
        return new PatchOperation(soft ? Action.SOFT_REPLACE : Action.HARD_REPLACE, path, digest, permissions, path, newDigest, newPermissions);
    }

    private PatchOperation(Action action, Path path, String digest, String permissions, Path newPath, String newDigest, String newPermissions) {
        this.action = action;
        this.path = path;
        this.digest = digest;
        this.permissions = permissions;
        this.newPath = newPath;
        this.newDigest = newDigest;
        this.newPermissions = newPermissions;
    }

    public Action getAction() {
        return this.action;
    }

    public Path getPath() {
        return this.path;
    }

    public String getDigest() {
        return this.digest;
    }

    public String getPermissions() {
        return this.permissions;
    }

    public Path getNewPath() {
        return this.newPath;
    }

    public String getNewDigest() {
        return this.newDigest;
    }

    public String getNewPermissions() {
        return this.newPermissions;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.action.name());
        if (this.path != null) {
            sb.append(" ").append(this.path).append(" [").append(this.digest).append("] ").append(this.permissions);
        }
        if (this.newPath != null) {
            sb.append(" -> ").append(this.newPath).append(" [").append(this.newDigest).append("] ").append(this.newPermissions);
        }
        return sb.toString();
    }

    public static class PatchOperationDeserializer
    extends JsonDeserializer<PatchOperation> {
        public PatchOperation deserialize(JsonParser parser, DeserializationContext ctx) throws IOException {
            JsonNode node = (JsonNode)parser.getCodec().readTree(parser);
            Action action = Action.valueOf(node.get(PatchOperation.ACTION).asText());
            switch (action) {
                case ADD: {
                    return PatchOperation.add(Paths.get(node.get(PatchOperation.NEW_PATH).asText(), new String[0]), node.get(PatchOperation.NEW_DIGEST).asText(), node.get(PatchOperation.NEW_PERMISSIONS).asText());
                }
                case REMOVE: {
                    return PatchOperation.remove(Paths.get(node.get(PatchOperation.PATH).asText(), new String[0]), node.get(PatchOperation.DIGEST).asText(), node.get(PatchOperation.PERMISSIONS).asText());
                }
                case HARD_REPLACE: {
                    return PatchOperation.replace(false, Paths.get(node.get(PatchOperation.PATH).asText(), new String[0]), node.get(PatchOperation.DIGEST).asText(), node.get(PatchOperation.PERMISSIONS).asText(), node.get(PatchOperation.NEW_DIGEST).asText(), node.get(PatchOperation.NEW_PERMISSIONS).asText());
                }
                case SOFT_REPLACE: {
                    return PatchOperation.replace(true, Paths.get(node.get(PatchOperation.PATH).asText(), new String[0]), node.get(PatchOperation.DIGEST).asText(), node.get(PatchOperation.PERMISSIONS).asText(), node.get(PatchOperation.NEW_DIGEST).asText(), node.get(PatchOperation.NEW_PERMISSIONS).asText());
                }
                case UPGRADE: {
                    return PatchOperation.upgrade(Paths.get(node.get(PatchOperation.PATH).asText(), new String[0]), node.get(PatchOperation.DIGEST).asText(), node.get(PatchOperation.PERMISSIONS).asText(), Paths.get(node.get(PatchOperation.NEW_PATH).asText(), new String[0]), node.get(PatchOperation.NEW_DIGEST).asText(), node.get(PatchOperation.NEW_PERMISSIONS).asText());
                }
            }
            throw new IllegalArgumentException(action.name());
        }
    }

    public static class PatchOperationSerializer
    extends StdSerializer<PatchOperation> {
        public PatchOperationSerializer() {
            this(null);
        }

        public PatchOperationSerializer(Class<PatchOperation> t) {
            super(t);
        }

        public void serialize(PatchOperation operation, JsonGenerator json, SerializerProvider serializerProvider) throws IOException {
            json.writeStartObject();
            json.writeStringField(PatchOperation.ACTION, operation.action.name());
            if (operation.path != null) {
                json.writeStringField(PatchOperation.PATH, operation.path.toString());
                json.writeStringField(PatchOperation.DIGEST, operation.digest);
                json.writeStringField(PatchOperation.PERMISSIONS, operation.permissions);
            }
            if (operation.newPath != null) {
                json.writeStringField(PatchOperation.NEW_PATH, operation.newPath.toString());
            }
            if (operation.newDigest != null) {
                json.writeStringField(PatchOperation.NEW_DIGEST, operation.newDigest);
            }
            if (operation.newPermissions != null) {
                json.writeStringField(PatchOperation.NEW_PERMISSIONS, operation.newPermissions);
            }
            json.writeEndObject();
        }
    }

    static enum Action {
        ADD,
        REMOVE,
        UPGRADE,
        HARD_REPLACE,
        SOFT_REPLACE;

    }
}

