/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cli.commands;

import java.io.FileInputStream;
import java.io.IOException;
import java.security.KeyStore;
import java.util.Properties;
import java.util.function.Supplier;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.aesh.AeshRuntimeRunner;
import org.aesh.command.AeshCommandRuntimeBuilder;
import org.aesh.command.Command;
import org.aesh.command.CommandNotFoundHandler;
import org.aesh.command.CommandResult;
import org.aesh.command.GroupCommandDefinition;
import org.aesh.command.activator.CommandActivatorProvider;
import org.aesh.command.completer.CompleterInvocationProvider;
import org.aesh.command.impl.completer.FileOptionCompleter;
import org.aesh.command.impl.registry.AeshCommandRegistryBuilder;
import org.aesh.command.invocation.CommandInvocation;
import org.aesh.command.invocation.CommandInvocationProvider;
import org.aesh.command.option.Option;
import org.aesh.command.registry.CommandRegistry;
import org.aesh.command.registry.CommandRegistryException;
import org.aesh.command.settings.QuitHandler;
import org.aesh.command.settings.SettingsBuilder;
import org.aesh.command.shell.Shell;
import org.aesh.io.Resource;
import org.aesh.readline.AeshContext;
import org.aesh.readline.ReadlineConsole;
import org.infinispan.cli.Context;
import org.infinispan.cli.activators.ContextAwareCommandActivatorProvider;
import org.infinispan.cli.commands.Add;
import org.infinispan.cli.commands.Batch;
import org.infinispan.cli.commands.Cache;
import org.infinispan.cli.commands.Cas;
import org.infinispan.cli.commands.Cd;
import org.infinispan.cli.commands.Clear;
import org.infinispan.cli.commands.ClearCache;
import org.infinispan.cli.commands.CliCommand;
import org.infinispan.cli.commands.Config;
import org.infinispan.cli.commands.Connect;
import org.infinispan.cli.commands.Container;
import org.infinispan.cli.commands.Counter;
import org.infinispan.cli.commands.Create;
import org.infinispan.cli.commands.Describe;
import org.infinispan.cli.commands.Disconnect;
import org.infinispan.cli.commands.Drop;
import org.infinispan.cli.commands.Echo;
import org.infinispan.cli.commands.Encoding;
import org.infinispan.cli.commands.Get;
import org.infinispan.cli.commands.Ls;
import org.infinispan.cli.commands.Patch;
import org.infinispan.cli.commands.Put;
import org.infinispan.cli.commands.Query;
import org.infinispan.cli.commands.Remove;
import org.infinispan.cli.commands.Replace;
import org.infinispan.cli.commands.Reset;
import org.infinispan.cli.commands.Run;
import org.infinispan.cli.commands.Schema;
import org.infinispan.cli.commands.Shutdown;
import org.infinispan.cli.commands.Site;
import org.infinispan.cli.commands.User;
import org.infinispan.cli.commands.Version;
import org.infinispan.cli.completers.ContextAwareCompleterInvocationProvider;
import org.infinispan.cli.impl.AeshDelegatingShell;
import org.infinispan.cli.impl.CliCommandNotFoundHandler;
import org.infinispan.cli.impl.CliRuntimeRunner;
import org.infinispan.cli.impl.ContextAwareCommandInvocation;
import org.infinispan.cli.impl.ContextAwareCommandInvocationProvider;
import org.infinispan.cli.impl.ContextAwareQuitHandler;
import org.infinispan.cli.impl.ContextImpl;
import org.infinispan.cli.impl.DefaultShell;
import org.infinispan.cli.impl.SSLContextSettings;
import org.infinispan.cli.logging.Messages;
import org.infinispan.cli.util.ZeroSecurityHostnameVerifier;
import org.infinispan.cli.util.ZeroSecurityTrustManager;
import org.infinispan.commons.util.ServiceFinder;
import org.wildfly.security.keystore.KeyStoreUtil;
import org.wildfly.security.provider.util.ProviderUtil;

@GroupCommandDefinition(name="cli", description="", groupCommands={Add.class, Cache.class, Cas.class, Cd.class, Clear.class, ClearCache.class, Config.class, Connect.class, Container.class, Counter.class, Create.class, Describe.class, Disconnect.class, Drop.class, Echo.class, Encoding.class, Get.class, Ls.class, Patch.class, Put.class, Query.class, Remove.class, Replace.class, Reset.class, Run.class, Schema.class, Shutdown.class, Site.class, User.class, Version.class})
public class CLI
extends CliCommand {
    public static final String CMD = "cli";
    private Context context;
    @Option(completer=FileOptionCompleter.class, shortName=116, name="truststore", description="A truststore to use when connecting to SSL/TLS-enabled servers")
    Resource truststore;
    @Option(shortName=115, name="truststore-password", description="The password for the truststore")
    String truststorePassword;
    @Option(shortName=118, hasValue=false, description="Shows version information")
    boolean version;
    @Option(hasValue=false, description="Whether to trust all certificates", name="trustall")
    boolean trustAll;
    @Option(completer=FileOptionCompleter.class, shortName=102, description="File for batch mode")
    Resource file;
    @Option(shortName=99, description="A connection URL. Use '-' to connect to http://localhost:11222")
    String connect;
    @Option(shortName=104, hasValue=false, overrideRequired=true)
    protected boolean help;

    @Override
    public boolean isHelp() {
        return this.help;
    }

    @Override
    public CommandResult exec(ContextAwareCommandInvocation invocation) {
        String connectionString;
        block14: {
            String sslTrustStore;
            if (this.help) {
                invocation.println(invocation.getHelpInfo());
                return CommandResult.SUCCESS;
            }
            if (this.version) {
                invocation.printf("%s CLI %s\n", org.infinispan.commons.util.Version.getBrandName(), org.infinispan.commons.util.Version.getBrandVersion());
                invocation.printf("Copyright (C) Red Hat Inc. and/or its affiliates and other contributors\n", new Object[0]);
                invocation.printf("License Apache License, v. 2.0. http://www.apache.org/licenses/LICENSE-2.0\n", new Object[0]);
                return CommandResult.SUCCESS;
            }
            this.context = invocation.getContext();
            String string = sslTrustStore = this.truststore != null ? this.truststore.getAbsolutePath() : this.context.getProperty(Context.Property.TRUSTSTORE);
            if (sslTrustStore != null) {
                String sslTrustStorePassword = this.truststorePassword != null ? this.truststorePassword : this.context.getProperty(Context.Property.TRUSTSTORE_PASSWORD);
                try (FileInputStream f = new FileInputStream(sslTrustStore);){
                    KeyStore keyStore = KeyStoreUtil.loadKeyStore((Supplier)ProviderUtil.INSTALLED_PROVIDERS, null, (FileInputStream)f, (String)sslTrustStore, (char[])(sslTrustStorePassword != null ? sslTrustStorePassword.toCharArray() : null));
                    TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                    trustManagerFactory.init(keyStore);
                    SSLContextSettings sslContext = SSLContextSettings.getInstance("TLS", null, trustManagerFactory.getTrustManagers(), null, null);
                    this.context.setSslContext(sslContext);
                    break block14;
                }
                catch (Exception e) {
                    invocation.getShell().writeln(Messages.MSG.keyStoreError(sslTrustStore, e));
                    return CommandResult.FAILURE;
                }
            }
            if (this.trustAll || Boolean.parseBoolean(this.context.getProperty(Context.Property.TRUSTALL))) {
                SSLContextSettings sslContext = SSLContextSettings.getInstance("TLS", null, new TrustManager[]{new ZeroSecurityTrustManager()}, null, new ZeroSecurityHostnameVerifier());
                this.context.setSslContext(sslContext);
            }
        }
        String string = connectionString = this.connect != null ? this.connect : this.context.getProperty(Context.Property.AUTOCONNECT_URL);
        if (connectionString != null) {
            this.context.connect(null, connectionString);
        }
        if (this.file != null) {
            return this.batch(this.file.getAbsolutePath(), invocation.getShell());
        }
        if (this.context.getProperty(Context.Property.AUTOEXEC) != null) {
            this.batch(this.context.getProperty(Context.Property.AUTOEXEC), invocation.getShell());
        }
        return this.interactive(invocation.getShell());
    }

    private CommandResult batch(String inputFile, Shell shell) {
        CommandRegistry commandRegistry = this.initializeCommands(Batch.class);
        AeshCommandRuntimeBuilder runtimeBuilder = AeshCommandRuntimeBuilder.builder();
        runtimeBuilder.commandActivatorProvider((CommandActivatorProvider)new ContextAwareCommandActivatorProvider(this.context)).commandInvocationProvider((CommandInvocationProvider)new ContextAwareCommandInvocationProvider(this.context)).commandNotFoundHandler((CommandNotFoundHandler)new CliCommandNotFoundHandler()).completerInvocationProvider((CompleterInvocationProvider)new ContextAwareCompleterInvocationProvider(this.context)).aeshContext((AeshContext)this.context).commandRegistry(commandRegistry);
        runtimeBuilder.shell(shell);
        CliRuntimeRunner cliRunner = CliRuntimeRunner.builder("batch", runtimeBuilder.build());
        cliRunner.args(new String[]{"run", inputFile}).execute();
        this.context.disconnect();
        return CommandResult.SUCCESS;
    }

    private CommandResult interactive(Shell shell) {
        CommandRegistry commandRegistry = this.initializeCommands(new Class[0]);
        this.context.setRegistry((CommandRegistry<? extends CommandInvocation>)commandRegistry);
        SettingsBuilder settings = SettingsBuilder.builder();
        settings.enableAlias(true).aliasFile(this.context.getConfigPath().resolve("aliases").toFile()).historyFile(this.context.getConfigPath().resolve("history").toFile()).outputStream(System.out).outputStreamError(System.err).inputStream(System.in).commandActivatorProvider((CommandActivatorProvider)new ContextAwareCommandActivatorProvider(this.context)).commandInvocationProvider((CommandInvocationProvider)new ContextAwareCommandInvocationProvider(this.context)).commandNotFoundHandler((CommandNotFoundHandler)new CliCommandNotFoundHandler()).completerInvocationProvider((CompleterInvocationProvider)new ContextAwareCompleterInvocationProvider(this.context)).commandRegistry(commandRegistry).aeshContext((AeshContext)this.context).quitHandler((QuitHandler)new ContextAwareQuitHandler(this.context));
        if (shell instanceof AeshDelegatingShell) {
            settings.connection(((AeshDelegatingShell)shell).getConnection());
        }
        ReadlineConsole console = new ReadlineConsole(settings.build());
        this.context.setConsole(console);
        try {
            console.start();
            return CommandResult.SUCCESS;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private CommandRegistry initializeCommands(Class<? extends Command> ... commands) {
        try {
            AeshCommandRegistryBuilder registryBuilder = AeshCommandRegistryBuilder.builder();
            for (Class<? extends Command> command : commands) {
                registryBuilder.command(command);
            }
            for (Command command : ServiceFinder.load(Command.class, (ClassLoader[])new ClassLoader[]{this.getClass().getClassLoader()})) {
                registryBuilder.command(command);
            }
            return registryBuilder.create();
        }
        catch (CommandRegistryException e) {
            throw new RuntimeException(e);
        }
    }

    private static AeshCommandRuntimeBuilder initialCommandRuntimeBuilder(Shell shell, Properties properties) throws CommandRegistryException {
        AeshCommandRegistryBuilder registryBuilder = AeshCommandRegistryBuilder.builder().command(CLI.class);
        ContextImpl context = new ContextImpl(properties);
        AeshCommandRuntimeBuilder runtimeBuilder = AeshCommandRuntimeBuilder.builder();
        runtimeBuilder.commandActivatorProvider((CommandActivatorProvider)new ContextAwareCommandActivatorProvider(context)).commandInvocationProvider((CommandInvocationProvider)new ContextAwareCommandInvocationProvider(context)).commandNotFoundHandler((CommandNotFoundHandler)new CliCommandNotFoundHandler()).completerInvocationProvider((CompleterInvocationProvider)new ContextAwareCompleterInvocationProvider(context)).shell(shell).aeshContext((AeshContext)context).commandRegistry(registryBuilder.create());
        return runtimeBuilder;
    }

    public static void main(Shell shell, String[] args, Properties properties) {
        try {
            AeshCommandRuntimeBuilder runtimeBuilder = CLI.initialCommandRuntimeBuilder(shell, properties);
            AeshRuntimeRunner.builder().commandRuntime(runtimeBuilder.build()).args(args).execute();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void main(String[] args) {
        try {
            AeshCommandRuntimeBuilder runtimeBuilder = CLI.initialCommandRuntimeBuilder(new DefaultShell(), System.getProperties());
            AeshRuntimeRunner.builder().commandRuntime(runtimeBuilder.build()).args(args).execute();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

