/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cli.commands;

import org.aesh.command.CommandDefinition;
import org.aesh.command.CommandException;
import org.aesh.command.CommandResult;
import org.aesh.command.GroupCommandDefinition;
import org.aesh.command.option.Option;
import org.infinispan.cli.activators.ConnectionActivator;
import org.infinispan.cli.activators.DisabledActivator;
import org.infinispan.cli.commands.CliCommand;
import org.infinispan.cli.commands.CommandInputLine;
import org.infinispan.cli.completers.CacheCompleter;
import org.infinispan.cli.converters.NullableIntegerConverter;
import org.infinispan.cli.impl.ContextAwareCommandInvocation;

@GroupCommandDefinition(name="migrate", description="Migration operations", groupCommands={Cluster.class})
public class Migrate
extends CliCommand {
    public static final String CMD = "migrate";
    public static final String TYPE = "type";
    public static final String SUBTYPE = "subtype";
    @Option(shortName=104, hasValue=false, overrideRequired=true)
    protected boolean help;

    @Override
    public boolean isHelp() {
        return this.help;
    }

    @Override
    public CommandResult exec(ContextAwareCommandInvocation invocation) {
        invocation.println(invocation.getHelpInfo());
        return CommandResult.FAILURE;
    }

    @CommandDefinition(name="synchronize", description="Synchronizes data from a source to a target cluster")
    public static class ClusterSynchronize
    extends CliCommand {
        public static final String CMD = "synchronize";
        public static final String READ_BATCH = "read-batch";
        public static final String THREADS = "threads";
        @Option(completer=CacheCompleter.class, shortName=99)
        String cache;
        @Option(shortName=104, hasValue=false, overrideRequired=true)
        protected boolean help;
        @Option(shortName=98, name="read-batch", description="The amount of entries to process in a batch", converter=NullableIntegerConverter.class)
        Integer readBatch;
        @Option(shortName=116, description="The number of threads to use. Defaults to the number of cores on the server", converter=NullableIntegerConverter.class)
        Integer threads;

        @Override
        public boolean isHelp() {
            return this.help;
        }

        @Override
        protected CommandResult exec(ContextAwareCommandInvocation invocation) throws CommandException {
            CommandInputLine cmd = new CommandInputLine(Migrate.CMD).arg(Migrate.TYPE, "cluster").arg(Migrate.SUBTYPE, CMD).option(READ_BATCH, this.readBatch).option(THREADS, this.threads).option("cache", this.cache);
            return invocation.execute(cmd);
        }
    }

    @CommandDefinition(name="disconnect", description="Disconnects from a source cluster")
    public static class ClusterDisconnect
    extends CliCommand {
        public static final String CMD = "disconnect";
        @Option(completer=CacheCompleter.class, shortName=99, description="The name of the cache.")
        String cache;
        @Option(shortName=104, hasValue=false, overrideRequired=true)
        protected boolean help;

        @Override
        public boolean isHelp() {
            return this.help;
        }

        @Override
        protected CommandResult exec(ContextAwareCommandInvocation invocation) throws CommandException {
            CommandInputLine cmd = new CommandInputLine(Migrate.CMD).arg(Migrate.TYPE, "cluster").arg(Migrate.SUBTYPE, CMD).option("cache", this.cache);
            return invocation.execute(cmd);
        }
    }

    @CommandDefinition(name="connect", description="Connects to a source cluster", activator=DisabledActivator.class)
    public static class ClusterConnect
    extends CliCommand {
        public static final String CMD = "connect";
        @Option(completer=CacheCompleter.class, shortName=99, description="The name of the cache.")
        String cache;
        @Option(shortName=117, description="The Hot Rod URL for the source cluster", required=true)
        String url;
        @Option(shortName=104, hasValue=false, overrideRequired=true)
        protected boolean help;

        @Override
        public boolean isHelp() {
            return this.help;
        }

        @Override
        protected CommandResult exec(ContextAwareCommandInvocation invocation) throws CommandException {
            throw new UnsupportedOperationException();
        }
    }

    @GroupCommandDefinition(name="cluster", description="Performs data migration between clusters", groupCommands={ClusterConnect.class, ClusterDisconnect.class, ClusterSynchronize.class}, activator=ConnectionActivator.class)
    public class Cluster
    extends CliCommand {
        public static final String CMD = "cluster";
        @Option(shortName=104, hasValue=false, overrideRequired=true)
        protected boolean help;

        @Override
        public boolean isHelp() {
            return this.help;
        }

        @Override
        public CommandResult exec(ContextAwareCommandInvocation invocation) {
            invocation.println(invocation.getHelpInfo());
            return CommandResult.FAILURE;
        }
    }
}

