/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cli.commands.rest;

import java.util.concurrent.CompletionStage;
import org.aesh.command.CommandDefinition;
import org.aesh.command.CommandResult;
import org.aesh.command.GroupCommandDefinition;
import org.aesh.command.option.Option;
import org.infinispan.cli.activators.ConnectionActivator;
import org.infinispan.cli.commands.CliCommand;
import org.infinispan.cli.commands.rest.RestCliCommand;
import org.infinispan.cli.connection.Connection;
import org.infinispan.cli.impl.ContextAwareCommandInvocation;
import org.infinispan.cli.resources.Resource;
import org.infinispan.client.rest.RestClient;
import org.infinispan.client.rest.RestResponse;

@GroupCommandDefinition(name="server", description="Obtains information about the server", activator=ConnectionActivator.class, groupCommands={Report.class})
public class Server
extends CliCommand {
    @Option(shortName=104, hasValue=false, overrideRequired=true)
    protected boolean help;

    @Override
    public boolean isHelp() {
        return this.help;
    }

    @Override
    public CommandResult exec(ContextAwareCommandInvocation commandInvocation) {
        commandInvocation.println(commandInvocation.getHelpInfo());
        return CommandResult.SUCCESS;
    }

    @CommandDefinition(name="report", description="Obtains an aggregate report from the server", activator=ConnectionActivator.class)
    public static class Report
    extends RestCliCommand {
        @Option(shortName=104, hasValue=false, overrideRequired=true)
        protected boolean help;

        @Override
        public boolean isHelp() {
            return this.help;
        }

        @Override
        protected CompletionStage<RestResponse> exec(ContextAwareCommandInvocation invocation, RestClient client, Resource resource) {
            return client.server().report();
        }

        @Override
        public Connection.ResponseMode getResponseMode() {
            return Connection.ResponseMode.FILE;
        }
    }
}

