/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cli.impl;

import java.io.IOException;
import java.io.PrintStream;
import java.util.Collections;
import java.util.List;
import org.aesh.command.CommandException;
import org.aesh.command.CommandNotFoundException;
import org.aesh.command.CommandResult;
import org.aesh.command.Executor;
import org.aesh.command.invocation.CommandInvocation;
import org.aesh.command.invocation.CommandInvocationConfiguration;
import org.aesh.command.parser.CommandLineParserException;
import org.aesh.command.shell.Shell;
import org.aesh.command.validator.CommandValidatorException;
import org.aesh.command.validator.OptionValidatorException;
import org.aesh.readline.Prompt;
import org.aesh.readline.action.KeyAction;
import org.infinispan.cli.Context;
import org.infinispan.cli.commands.CommandInputLine;
import org.infinispan.cli.impl.ShellOutputStreamAdapter;

public class ContextAwareCommandInvocation<CI extends CommandInvocation>
implements CommandInvocation {
    private final CommandInvocation<CI> invocation;
    private final Context context;

    public ContextAwareCommandInvocation(CommandInvocation<CI> commandInvocation, Context context) {
        this.invocation = commandInvocation;
        this.context = context;
    }

    public Shell getShell() {
        return this.invocation.getShell();
    }

    public void setPrompt(Prompt prompt) {
        this.invocation.setPrompt(prompt);
    }

    public Prompt getPrompt() {
        return this.invocation.getPrompt();
    }

    public String getHelpInfo(String commandName) {
        return this.invocation.getHelpInfo(commandName);
    }

    public String getHelpInfo() {
        return this.invocation.getHelpInfo();
    }

    public void stop() {
        this.invocation.stop();
    }

    public CommandInvocationConfiguration getConfiguration() {
        return this.invocation.getConfiguration();
    }

    public KeyAction input() throws InterruptedException {
        return this.invocation.input();
    }

    public String inputLine() throws InterruptedException {
        return this.invocation.inputLine();
    }

    public String inputLine(Prompt prompt) throws InterruptedException {
        return this.invocation.inputLine(prompt);
    }

    public void executeCommand(String input) throws CommandNotFoundException, CommandLineParserException, OptionValidatorException, CommandValidatorException, CommandException, InterruptedException, IOException {
        this.invocation.executeCommand(input);
    }

    public Executor<CI> buildExecutor(String line) throws CommandNotFoundException, CommandLineParserException, OptionValidatorException, CommandValidatorException, IOException {
        return this.invocation.buildExecutor(line);
    }

    public void print(String msg) {
        this.invocation.print(msg);
    }

    public void println(String msg) {
        this.invocation.println(msg);
    }

    public void printf(String format, Object ... args) {
        this.invocation.print(String.format(format, args));
    }

    public void print(String msg, boolean paging) {
        this.invocation.print(msg, paging);
    }

    public void println(String msg, boolean paging) {
        this.invocation.println(msg, paging);
    }

    public Context getContext() {
        return this.context;
    }

    public CommandResult execute(CommandInputLine cmd) {
        return this.context.execute(this.invocation.getShell(), Collections.singletonList(cmd));
    }

    public CommandResult execute(List<CommandInputLine> cmds) {
        return this.context.execute(this.invocation.getShell(), cmds);
    }

    public PrintStream getShellOutput() {
        return new PrintStream(new ShellOutputStreamAdapter(this.invocation.getShell()));
    }

    public PrintStream getShellError() {
        return new PrintStream(new ShellOutputStreamAdapter(this.invocation.getShell()));
    }
}

